/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain.export;

import com.nlbhub.nlb.api.TextChunk;
import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.export.ImagePathData;
import com.nlbhub.nlb.domain.export.LinkBuildingBlocks;
import com.nlbhub.nlb.domain.export.PageBuildingBlocks;
import com.nlbhub.nlb.domain.export.STEADExportManager;
import com.nlbhub.nlb.exception.NLBExportException;
import com.nlbhub.nlb.util.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VNSTEADExportManager
extends STEADExportManager {
    private static final Logger LOG = Logger.getLogger(VNSTEADExportManager.class.getName());
    private static final Pattern SENTENCE_PATTERN = Pattern.compile("((?:^|[^\\.\\?!]+)(?:[\\.\\?!]+(?:\\\\\")?|$))");
    private static final int PARAGRAPH_THRESHOLD = 100;
    private static final int PARAGRAPH_THRESHOLD_WARN = 330;
    private boolean m_technicalInstance = false;

    public VNSTEADExportManager(NonLinearBookImpl nlb, String encoding) throws NLBExportException {
        super(nlb, encoding);
    }

    protected VNSTEADExportManager(NonLinearBookImpl nlb, String encoding, boolean technicalInstance) throws NLBExportException {
        super(nlb, encoding, technicalInstance);
        this.m_technicalInstance = technicalInstance;
    }

    @Override
    protected boolean isVN(Theme theme) {
        return this.m_technicalInstance || theme != Theme.STANDARD;
    }

    @Override
    protected String getDefaultThemeSwitchExpression() {
        return "        return 'theme_vn.lua';" + this.getLineSeparator();
    }

    @Override
    protected String decoratePageTextStart(String labelText, int pageNumber, List<TextChunk> pageTextChunks, Theme theme) {
        if (!this.isVN(theme)) {
            return super.decoratePageTextStart(labelText, pageNumber, pageTextChunks, theme);
        }
        String lineSep = this.getLineSeparator();
        StringBuilder pageText = new StringBuilder();
        pageText.append("    dsc = function(s)").append(lineSep);
        if (pageTextChunks.size() > 0) {
            pageText.append("pn(\"");
            pageText.append(this.expandVariables(pageTextChunks, theme));
            pageText.append("\");").append(lineSep);
            pageText.append("pn();").append(lineSep);
        }
        return pageText.toString();
    }

    @Override
    protected String decoratePageTextEnd(String labelText, int pageNumber, Theme theme, boolean hasChoicesOrLeaf) {
        if (!this.isVN(theme)) {
            return super.decoratePageTextEnd(labelText, pageNumber, theme, hasChoicesOrLeaf);
        }
        String lineSep = this.getLineSeparator();
        StringBuilder pageText = new StringBuilder();
        pageText.append("    end,").append(lineSep);
        if (hasChoicesOrLeaf) {
            pageText.append("    walk_to = \"").append(this.decoratePageName(labelText, pageNumber)).append("_choices\",").append(lineSep);
        }
        return pageText.toString();
    }

    @Override
    protected boolean isDirectMode(PageBuildingBlocks pageBlocks) {
        return pageBlocks.isDirectMode() && pageBlocks.getTheme() != Theme.STANDARD;
    }

    @Override
    protected String generateDirectModeStartText(PageBuildingBlocks pageBlocks) {
        String lineSep = this.getLineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isDirectMode(pageBlocks)) {
            stringBuilder.append("        vn:request_full_clear();").append(lineSep);
            stringBuilder.append("        vn:lock_direct();").append(lineSep);
        }
        return stringBuilder.toString();
    }

    @Override
    protected String generateDirectModeStopText(PageBuildingBlocks pageBlocks) {
        String lineSep = this.getLineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isDirectMode(pageBlocks)) {
            stringBuilder.append("        vn:request_full_clear();").append(lineSep);
            stringBuilder.append("        vn:unlock_direct();").append(lineSep);
        }
        return stringBuilder.toString();
    }

    @Override
    protected String generateOrdinaryLinkTextInsideRoom(PageBuildingBlocks pageBuildingBlocks) {
        if (!this.isVN(pageBuildingBlocks.getTheme())) {
            return super.generateOrdinaryLinkTextInsideRoom(pageBuildingBlocks);
        }
        return "";
    }

    @Override
    protected String generatePostPageText(PageBuildingBlocks pageBlocks) {
        if (!this.isVN(pageBlocks.getTheme())) {
            return super.generatePostPageText(pageBlocks);
        }
        List<LinkBuildingBlocks> linksBuildingBlocks = pageBlocks.getLinksBuildingBlocks();
        boolean theEnd = linksBuildingBlocks.isEmpty();
        if (!this.hasChoicesOrLeaf(pageBlocks)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringBuilder linksBuilder = new StringBuilder();
        String lineSep = this.getLineSeparator();
        String roomName = pageBlocks.getPageName();
        result.append(roomName).append("_choices").append(" = vn_choices {").append(lineSep);
        result.append("    nam = \"").append(this.getNonEmptyTitle(pageBlocks.getModuleTitle())).append("\",").append(lineSep);
        result.append("    disp = true,").append(lineSep);
        result.append("    textbg = true,").append(lineSep);
        result.append("    ignore_preserved_gobjs = true,").append(lineSep);
        if (theEnd) {
            result.append("    dsc = true,").append(lineSep);
        }
        result.append("    var { paginator_state = false; },").append(lineSep);
        result.append("    enter = function(s) ").append(lineSep);
        result.append("        s.paginator_state = paginator.on;").append(lineSep);
        result.append("        objs():zap();").append(lineSep);
        result.append("        paginator:turnoff();").append(lineSep);
        if (pageBlocks.isHasTrivialLinks()) {
            for (LinkBuildingBlocks linkBlock : linksBuildingBlocks) {
                if (linkBlock.isAuto()) continue;
                boolean constrained = !StringHelper.isEmpty(linkBlock.getLinkConstraint());
                result.append("if ").append(constrained ? linkBlock.getLinkConstraint() : "true").append(" then").append(lineSep);
                result.append(linkBlock.getLinkModifications());
                result.append(linkBlock.getLinkVariable());
                result.append(linkBlock.getLinkVisitStateVariable());
                result.append(linkBlock.getLinkGoTo());
                result.append("    return;").append(lineSep);
                result.append("end;").append(lineSep);
            }
        } else {
            result.append("        vn.skip_mode = false;").append(lineSep);
            result.append("        vn:unlock_direct();").append(lineSep);
            for (LinkBuildingBlocks linkBlock : linksBuildingBlocks) {
                boolean constrained;
                if (linkBlock.isAuto()) continue;
                boolean bl = constrained = !StringHelper.isEmpty(linkBlock.getLinkConstraint());
                if (constrained) {
                    result.append("if ").append(linkBlock.getLinkConstraint()).append(" then").append(lineSep);
                }
                result.append("        put(").append(linkBlock.getLinkLabel()).append(");").append(lineSep);
                if (constrained) {
                    result.append("end;").append(lineSep);
                }
                linksBuilder.append(this.generateOrdinaryLinkCode(linkBlock));
            }
            if (theEnd) {
                result.append("        put(_try_again);").append(lineSep);
            }
            result.append("        s:initf();").append(lineSep);
        }
        result.append("    end,").append(lineSep);
        result.append("    theme_file = function(s) return \"theme_vn.lua\"; end,").append(lineSep);
        result.append("    initf = function(s) ").append(lineSep);
        if (theEnd) {
            result.append("        return vn:auto_geom_end('dissolve');").append(lineSep);
        } else {
            result.append("        return vn:auto_geom_choices('dissolve');").append(lineSep);
        }
        result.append("    end,").append(lineSep);
        result.append("    exit = function(s) ").append(lineSep);
        result.append("        if s.paginator_state then paginator:turnon(); end;").append(lineSep);
        result.append("    end").append(lineSep);
        result.append("}").append(lineSep).append(lineSep);
        result.append(linksBuilder.toString());
        return result.toString();
    }

    @Override
    protected String decoratePageLabel(String labelText, int pageNumber, Theme theme) {
        if (!this.isVN(theme)) {
            return super.decoratePageLabel(labelText, pageNumber, theme);
        }
        return this.generatePageBeginningCode(labelText, pageNumber) + "vnr {" + this.getLineSeparator();
    }

    @Override
    protected String decorateLinkLabel(String linkId, String linkText, Theme theme) {
        if (!this.isVN(theme)) {
            return super.decorateLinkLabel(linkId, linkText, theme);
        }
        return this.decorateId(linkId);
    }

    @Override
    protected String decorateLinkStart(String linkId, String linkText, boolean isAuto, boolean isTrivial, int pageNumber, Theme theme) {
        if (!this.isVN(theme)) {
            return super.decorateLinkStart(linkId, linkText, isAuto, isTrivial, pageNumber, theme);
        }
        String lineSep = this.getLineSeparator();
        StringBuilder result = new StringBuilder();
        result.append(this.decorateId(linkId)).append(" = menu {").append(lineSep);
        result.append("    nam = \"").append(this.decorateId(linkId)).append("\",").append(lineSep);
        result.append("    dsc = function(s) ").append("return \"{").append(linkText).append("}^^\" end, ").append(lineSep);
        return result.toString();
    }

    @Override
    protected String decorateLinkGoTo(String linkId, String linkText, String linkSource, int sourcePageNumber, String linkTarget, int targetPageNumber, Theme theme) {
        if (!this.isVN(theme)) {
            return super.decorateLinkGoTo(linkId, linkText, linkSource, sourcePageNumber, linkTarget, targetPageNumber, theme);
        }
        return "        nlb:nlbwalk(" + (this.getGoToPageNumbers() ? this.decorateId(String.valueOf(sourcePageNumber)) : this.decorateId(linkSource)) + ", " + (this.getGoToPageNumbers() ? this.decorateId(String.valueOf(targetPageNumber)) : this.decorateId(linkTarget)) + "); " + this.getLineSeparator();
    }

    @Override
    protected String decorateLinkEnd(Theme theme) {
        if (!this.isVN(theme)) {
            return super.decorateLinkEnd(theme);
        }
        return "}" + this.getLineSeparator();
    }

    @Override
    protected String generateOrdinaryLinkCode(LinkBuildingBlocks linkBlocks) {
        if (!this.isVN(linkBlocks.getTheme())) {
            return super.generateOrdinaryLinkCode(linkBlocks);
        }
        String lineSep = this.getLineSeparator();
        StringBuilder result = new StringBuilder();
        if (!linkBlocks.isAuto()) {
            result.append(linkBlocks.getLinkStart());
            result.append("    act = function(s) ").append(lineSep);
            result.append(linkBlocks.getLinkModifications());
            result.append(linkBlocks.getLinkVariable());
            result.append(linkBlocks.getLinkVisitStateVariable());
            result.append(linkBlocks.getLinkGoTo());
            result.append("    end").append(lineSep);
            result.append(linkBlocks.getLinkEnd()).append(lineSep);
        }
        return result.toString();
    }

    @Override
    protected String generateObjsCollection(PageBuildingBlocks pageBlocks, List<LinkBuildingBlocks> linksBlocks) {
        if (!this.isVN(pageBlocks.getTheme())) {
            return super.generateObjsCollection(pageBlocks, linksBlocks);
        }
        return "";
    }

    @Override
    protected String decoratePageImage(List<ImagePathData> pageImagePathDatas, boolean imageBackground, Theme theme) {
        if (!this.isVN(theme)) {
            return super.decoratePageImage(pageImagePathDatas, imageBackground, theme);
        }
        String lineSep = this.getLineSeparator();
        StringBuilder bgimgBuilder = new StringBuilder("    bgimg = function(s)" + lineSep);
        boolean notFirst = false;
        String bgimgIfTermination = "";
        for (ImagePathData pageImagePathData : pageImagePathDatas) {
            String pageImagePath;
            if (pageImagePathData.getMaxFrameNumber() == 0 && StringHelper.notEmpty(pageImagePath = pageImagePathData.getImagePath())) {
                StringBuilder tempBuilder = new StringBuilder();
                tempBuilder.append("        ").append(notFirst ? "else" : "").append("if (");
                String constraint = pageImagePathData.getConstraint();
                tempBuilder.append(StringHelper.notEmpty(constraint) ? "s.tag == '" + constraint + "'" : "true").append(") then");
                tempBuilder.append(lineSep);
                bgimgIfTermination = "        end" + lineSep;
                bgimgBuilder.append((CharSequence)tempBuilder).append("            ");
                bgimgBuilder.append("return '").append(pageImagePath).append("';").append(lineSep);
            }
            notFirst = true;
        }
        bgimgBuilder.append(bgimgIfTermination).append(lineSep);
        bgimgBuilder.append("    end,").append(lineSep);
        return bgimgBuilder.toString();
    }

    @Override
    protected String expandVariables(List<TextChunk> textChunks, Theme theme) {
        if (!this.isVN(theme)) {
            return super.expandVariables(textChunks, theme);
        }
        StringBuilder result = new StringBuilder();
        String lineSep = this.getLineSeparator();
        for (TextChunk textChunk : textChunks) {
            switch (textChunk.getType()) {
                case TEXT: {
                    result.append(this.preprocessText(textChunk.getText()));
                    break;
                }
                case ACTION_TEXT: {
                    result.append("\"..nlb:lasttext()..\"");
                    break;
                }
                case VARIABLE: {
                    result.append("\"..");
                    result.append("tostring(").append(this.getGlobalVarPrefix()).append(textChunk.getText()).append(")");
                    result.append("..\"");
                    break;
                }
                case NEWLINE: {
                    result.append("\");").append(lineSep);
                    result.append("pn();").append(lineSep);
                    result.append("pn(\"");
                }
            }
        }
        return result.toString();
    }

    protected String preprocessText(String text) {
        StringBuilder result = new StringBuilder();
        List<String> preprocessedChunks = this.getPreprocessedChunks(text);
        if (preprocessedChunks.size() == 1) {
            return preprocessedChunks.get(0);
        }
        preprocessedChunks.stream().map(this::getChunkText).forEach(result::append);
        return result.toString();
    }

    private String getChunkText(String chunk) {
        String lineSep = this.getLineSeparator();
        return chunk + "\");" + lineSep + "pn();" + lineSep + "pn(\"";
    }

    private List<String> getPreprocessedChunks(String text) {
        String prevText = "";
        String intermediateText = "";
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = SENTENCE_PATTERN.matcher(text);
        while (matcher.find()) {
            if ((intermediateText = intermediateText + matcher.group(1)).length() <= 100) continue;
            if (intermediateText.length() > 330) {
                LOG.warning("Length of the line during VN export is " + intermediateText.length() + ": " + intermediateText);
            }
            if (StringHelper.notEmpty(prevText)) {
                result.add(prevText);
            }
            prevText = intermediateText;
            intermediateText = "";
        }
        String tmpText = prevText + intermediateText;
        if (tmpText.length() <= 330) {
            if (StringHelper.notEmpty(tmpText)) {
                result.add(tmpText);
            }
        } else {
            if (StringHelper.notEmpty(prevText)) {
                result.add(prevText);
            }
            if (StringHelper.notEmpty(intermediateText)) {
                if (intermediateText.length() > 330) {
                    LOG.warning("Length of the line during VN export is " + intermediateText.length() + ": " + intermediateText);
                }
                result.add(intermediateText);
            }
        }
        return result;
    }
}

