/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain.export.hypertext;

import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.export.ExportManager;
import com.nlbhub.nlb.domain.export.LinkBuildingBlocks;
import com.nlbhub.nlb.domain.export.NLBBuildingBlocks;
import com.nlbhub.nlb.domain.export.PageBuildingBlocks;
import com.nlbhub.nlb.domain.export.hypertext.document.HTAnchor;
import com.nlbhub.nlb.domain.export.hypertext.document.HTDocument;
import com.nlbhub.nlb.domain.export.hypertext.document.HTFont;
import com.nlbhub.nlb.domain.export.hypertext.document.HTParagraph;
import com.nlbhub.nlb.exception.HTDocumentException;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBExportException;
import com.nlbhub.nlb.util.StringHelper;
import java.io.File;
import java.io.IOException;
import java.util.List;

public abstract class HypertextExportManager<P extends HTParagraph<F, A>, A extends HTAnchor<F>, F extends HTFont>
extends ExportManager {
    public HypertextExportManager(NonLinearBookImpl nlb, String encoding) throws NLBExportException {
        super(nlb, encoding);
    }

    @Override
    public void exportToFile(File targetFile) throws NLBExportException {
        try {
            NLBBuildingBlocks nlbBlocks = this.createNLBBuildingBlocks();
            HTDocument<P> document = this.createDocument(this.getEncoding(), this.getLineSeparator());
            document.initWriter(targetFile);
            document.open();
            this.generateHypertext(document, this.createParaFont(), this.createLinkFont(), nlbBlocks);
            document.close();
        }
        catch (HTDocumentException | NLBConsistencyException | IOException e) {
            throw new NLBExportException("Error while converting NLB to Hypertext", e);
        }
    }

    protected abstract HTDocument<P> createDocument(String var1, String var2);

    protected abstract F createParaFont() throws HTDocumentException;

    protected abstract F createLinkFont() throws HTDocumentException;

    protected abstract P createHTParagraph(String var1, F var2) throws HTDocumentException;

    protected abstract A createHTAnchor(boolean var1, String var2, F var3) throws HTDocumentException;

    private void generateHypertext(HTDocument<P> document, F paraFont, F linkFont, NLBBuildingBlocks nlbBlocks) throws IOException, HTDocumentException {
        List<PageBuildingBlocks> pagesBlocks = nlbBlocks.getPagesBuildingBlocks();
        for (int i = 0; i < pagesBlocks.size(); ++i) {
            document.add(this.createHTParagraph(paraFont, linkFont, pagesBlocks.get(i)));
        }
    }

    protected P createHTParagraph(F paraFont, F linkFont, PageBuildingBlocks pageBlocks) throws IOException, HTDocumentException {
        P page = this.createHTParagraph(this.getLineSeparator(), paraFont);
        A pageAnchor = this.createHTAnchor(false, pageBlocks.getPageNumber(), paraFont);
        ((HTAnchor)pageAnchor).setName(pageBlocks.getPageLabel());
        ((HTParagraph)page).add(pageAnchor);
        ((HTParagraph)page).add(this.getLineSeparator());
        ((HTParagraph)page).add(pageBlocks.getPageCaption());
        ((HTParagraph)page).add(pageBlocks.getPageImage());
        ((HTParagraph)page).add(pageBlocks.getPageTextStart());
        ((HTParagraph)page).add(pageBlocks.getPageTextEnd());
        ((HTParagraph)page).add(pageBlocks.getPageModifications());
        ((HTParagraph)page).add(pageBlocks.getPageVariable());
        List<LinkBuildingBlocks> linksBlocks = pageBlocks.getLinksBuildingBlocks();
        boolean first = true;
        for (LinkBuildingBlocks linkBlocks : linksBlocks) {
            boolean hasConstraint;
            if (first) {
                first = false;
            } else {
                ((HTParagraph)page).add(this.getLineSeparator());
            }
            boolean bl = hasConstraint = !StringHelper.isEmpty(linkBlocks.getLinkConstraint());
            if (hasConstraint) {
                ((HTParagraph)page).add("\u0415\u0441\u043b\u0438 ");
                ((HTParagraph)page).add(linkBlocks.getLinkConstraint());
                ((HTParagraph)page).add(", \u0442\u043e \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 ");
            }
            A linkAnchor = this.createHTAnchor(hasConstraint, linkBlocks.getLinkStart(), linkFont);
            ((HTAnchor)linkAnchor).setReference(this.getLinkReference(linkBlocks));
            ((HTParagraph)page).add(linkAnchor);
            ((HTParagraph)page).add(linkBlocks.getLinkModifications());
            ((HTParagraph)page).add(linkBlocks.getLinkVariable());
            ((HTParagraph)page).add(linkBlocks.getLinkVisitStateVariable());
        }
        return page;
    }

    protected String getLinkReference(LinkBuildingBlocks linkBlocks) {
        return "#" + linkBlocks.getLinkGoTo();
    }

    @Override
    protected String decorateAssignment(String variableName, String variableValue) {
        return variableName + "=" + variableValue;
    }

    @Override
    protected String decorateTag(String variable, String objId, String tag) {
        return "";
    }

    @Override
    protected String decorateGetTagOperation(String resultingVariable, String objId, String objVariableName) {
        return "";
    }

    @Override
    protected String decorateWhile(String constraint) {
        return "";
    }

    @Override
    protected String decorateIf(String constraint) {
        return "";
    }

    @Override
    protected String decorateIfHave(String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateElse() {
        return "";
    }

    @Override
    protected String decorateElseIf(String constraint) {
        return "";
    }

    @Override
    protected String decorateEnd() {
        return "";
    }

    @Override
    protected String decorateReturn(String returnValue) {
        return "";
    }

    @Override
    protected String decorateHaveOperation(String variableName, String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateCloneOperation(String variableName, String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateContainerOperation(String variableName, String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateGetIdOperation(String variableName, String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateDelObj(String destinationId, String destinationName, String objectId, String objectVar, String objectName, String objectDisplayName) {
        return "\u0412\u044b\u0447\u0435\u0440\u043a\u043d\u0438\u0442\u0435 \u0438\u0437 " + (destinationId != null ? destinationId : (destinationName != null ? destinationName : "\u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u043a\u043e\u043c\u043d\u0430\u0442\u044b")) + " " + objectDisplayName;
    }

    @Override
    protected String decorateDelInvObj(String objectId, String objectVar, String objectName, String objectDisplayName) {
        return "\u0412\u044b\u0447\u0435\u0440\u043a\u043d\u0438\u0442\u0435 \u0438\u0437 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044f " + objectDisplayName;
    }

    @Override
    protected String decorateAddObj(String destinationId, String objectId, String objectVar, String objectName, String objectDisplayName, boolean unique) {
        return "\u041f\u043e\u043b\u043e\u0436\u0438\u0442\u0435 \u0432 " + (destinationId != null ? destinationId : "\u0442\u0435\u043a\u0443\u0449\u0443\u044e \u043a\u043e\u043c\u043d\u0430\u0442\u0443") + " " + objectDisplayName;
    }

    @Override
    protected String decorateAddInvObj(String objectId, String objectVar, String objectName, String objectDisplayName) {
        return "\u041f\u043e\u043b\u043e\u0436\u0438\u0442\u0435 \u0432 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c " + objectDisplayName;
    }

    @Override
    protected String decorateAddAllOperation(String destinationId, String destinationListVariableName, String sourceListVariableName, boolean unique) {
        return "";
    }

    @Override
    protected String decorateObjsOperation(String listVariableName, String srcObjId, String objectVar) {
        return "";
    }

    @Override
    protected String decorateSSndOperation() {
        return "";
    }

    @Override
    protected String decorateWSndOperation() {
        return "";
    }

    @Override
    protected String decorateSndOperation(String objectId, String objectVar) {
        return "";
    }

    @Override
    protected String decorateSPushOperation(String listVariableName) {
        return "";
    }

    @Override
    protected String decorateWPushOperation(String listVariableName) {
        return "";
    }

    @Override
    protected String decoratePushOperation(String listVariableName, String objectId, String objectVar) {
        return "\u041f\u043e\u043b\u043e\u0436\u0438\u0442\u0435 \u0432 " + listVariableName + " " + objectVar;
    }

    @Override
    protected String decoratePopOperation(String variableName, String listVariableName) {
        return "";
    }

    @Override
    protected String decorateSInjectOperation(String listVariableName) {
        return "";
    }

    @Override
    protected String decorateInjectOperation(String listVariableName, String objectId, String objectVar) {
        return "";
    }

    @Override
    protected String decorateEjectOperation(String variableName, String listVariableName) {
        return "";
    }

    @Override
    protected String decorateClearOperation(String destinationId, String destinationVar) {
        return "";
    }

    @Override
    protected String decorateClearInvOperation() {
        return "";
    }

    @Override
    protected String decorateSizeOperation(String variableName, String listVariableName) {
        return "";
    }

    @Override
    protected String decorateRndOperation(String variableName, String maxValue) {
        return "";
    }

    @Override
    protected String decorateAchMaxOperation(String achievementName, int max) {
        return "";
    }

    @Override
    protected String decorateAchieveOperation(String achievementName, String modificationId) {
        return "";
    }

    @Override
    protected String decorateAchievedOperation(String variableName, String achievementName) {
        return "";
    }

    @Override
    protected String decorateGoToOperation(String locationId) {
        return "";
    }

    @Override
    protected String decorateSnapshotOperation(String snapshotId) {
        return "";
    }

    @Override
    protected String decorateOpenURLOperation(String url) {
        return "";
    }

    @Override
    protected String decorateWinGeomOperation(String arg) {
        return "";
    }

    @Override
    protected String decorateInvGeomOperation(String arg) {
        return "";
    }

    @Override
    protected String decorateWinColorOperation(String arg) {
        return "";
    }

    @Override
    protected String decorateInvColorOperation(String arg) {
        return "";
    }

    @Override
    protected String decorateShuffleOperation(String listVariableName) {
        return "";
    }

    @Override
    protected String decoratePRNOperation(String variableName) {
        return "";
    }

    @Override
    protected String decorateDSCOperation(String resultVariableName, String dscObjVariable, String dscObjId) {
        return "";
    }

    @Override
    protected String decoratePDscOperation(String objVariableName) {
        return "";
    }

    @Override
    protected String decoratePDscsOperation(String objId, String objVar) {
        return "";
    }

    @Override
    protected String decorateActOperation(String actingObjVariable, String actingObjId) {
        return "";
    }

    @Override
    protected String decorateActtOperation(String resultVariableName, String actObjVariable, String actObjId) {
        return "";
    }

    @Override
    protected String decorateActfOperation(String actingObjVariable, String actingObjId) {
        return "";
    }

    @Override
    protected String decorateUseOperation(String sourceVariable, String sourceId, String targetVariable, String targetId) {
        return "";
    }

    @Override
    protected String decorateTrue() {
        return "\u0418\u0421\u0422\u0418\u041d\u0410";
    }

    @Override
    protected String decorateFalse() {
        return "\u041b\u041e\u0416\u042c";
    }

    @Override
    protected String decorateEq() {
        return "\u0420\u0410\u0412\u041d\u041e";
    }

    @Override
    protected String decorateNEq() {
        return "\u041d\u0415 \u0420\u0410\u0412\u041d\u041e";
    }

    @Override
    protected String decorateGt() {
        return ">";
    }

    @Override
    protected String decorateGte() {
        return ">=";
    }

    @Override
    protected String decorateLt() {
        return "<";
    }

    @Override
    protected String decorateLte() {
        return "<=";
    }

    @Override
    protected String decorateNot() {
        return "\u041d\u0415 ";
    }

    @Override
    protected String decorateOr() {
        return "\u0418\u041b\u0418";
    }

    @Override
    protected String decorateAnd() {
        return "\u0418";
    }

    @Override
    protected String decorateBooleanVar(String constraintVar) {
        return constraintVar;
    }

    @Override
    protected String decorateStringVar(String constraintVar) {
        return constraintVar;
    }

    @Override
    protected String decorateNumberVar(String constraintVar) {
        return constraintVar;
    }

    @Override
    protected String decorateLinkLabel(String linkId, String linkText, Theme theme) {
        return linkId;
    }

    @Override
    protected String decorateLinkComment(String comment) {
        return comment;
    }

    @Override
    protected String decorateLinkStart(String linkId, String linkText, boolean isAuto, boolean isTrivial, int pageNumber, Theme theme) {
        return linkText + " (" + String.valueOf(pageNumber) + ")";
    }

    @Override
    protected String decorateLinkGoTo(String linkId, String linkText, String linkSource, int sourcePageNumber, String linkTarget, int targetPageNumber, Theme theme) {
        return linkTarget;
    }

    @Override
    protected String decoratePageEnd(boolean isFinish) {
        return "page end";
    }

    @Override
    protected String decorateLinkVariable(String variableName) {
        StringBuilder result = new StringBuilder();
        if (!StringHelper.isEmpty(variableName)) {
            result.append(this.getLineSeparator()).append("    ").append("\u0417\u0430\u043f\u0438\u0448\u0438\u0442\u0435 \u043a\u043b\u044e\u0447\u0435\u0432\u043e\u0435 \u0441\u043b\u043e\u0432\u043e: ").append(variableName);
        }
        return result.toString();
    }

    @Override
    protected String decorateLinkVisitStateVariable(String linkVisitStateVariable) {
        StringBuilder result = new StringBuilder();
        if (StringHelper.isEmpty(linkVisitStateVariable)) {
            result.append(this.getLineSeparator()).append("    ").append("\u0417\u0430\u043f\u0438\u0448\u0438\u0442\u0435 \u043a\u043b\u044e\u0447\u0435\u0432\u043e\u0435 \u0441\u043b\u043e\u0432\u043e: ").append(linkVisitStateVariable);
        }
        return result.toString();
    }

    @Override
    protected String decoratePageVariable(String variableName) {
        if (StringHelper.isEmpty(variableName)) {
            return "";
        }
        return this.getLineSeparator() + "\u0417\u0430\u043f\u0438\u0448\u0438\u0442\u0435 \u043a\u043b\u044e\u0447\u0435\u0432\u043e\u0435 \u0441\u043b\u043e\u0432\u043e: " + variableName + this.getLineSeparator();
    }

    @Override
    protected String decoratePageTimerVariableInit(String variableName) {
        return "";
    }

    @Override
    protected String decoratePageTimerVariable(String variableName) {
        return "";
    }

    @Override
    protected String decoratePageModifications(String modificationsText) {
        if (StringHelper.isEmpty(modificationsText)) {
            return "";
        }
        return this.getLineSeparator() + "\u0421\u0434\u0435\u043b\u0430\u0439\u0442\u0435 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f: " + this.getLineSeparator() + modificationsText + this.getLineSeparator();
    }

    @Override
    protected String decoratePageThemeModifications(String modificationsText) {
        return "";
    }

    @Override
    protected String decorateLinkModifications(String modificationsText) {
        if (StringHelper.isEmpty(modificationsText)) {
            return "";
        }
        return this.getLineSeparator() + "    \u0421\u0434\u0435\u043b\u0430\u0439\u0442\u0435 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f: " + this.getLineSeparator() + modificationsText;
    }

    @Override
    protected String decoratePageCaption(String caption, boolean useCaption, String moduleTitle, boolean noSave) {
        if (StringHelper.notEmpty(caption) && useCaption) {
            return caption + this.getLineSeparator();
        }
        return "";
    }

    @Override
    protected String decoratePageNotes(String notes) {
        return "";
    }

    @Override
    protected String decoratePageTextEnd(String labelText, int pageNumber, Theme theme, boolean hasChoicesOrLeaf) {
        return "";
    }

    @Override
    protected String decoratePageLabel(String labelText, int pageNumber, Theme theme) {
        return labelText;
    }

    @Override
    protected String decoratePageNumber(int pageNumber) {
        return String.valueOf(pageNumber) + ".";
    }

    @Override
    protected String decoratePageComment(String comment) {
        return comment;
    }
}

