/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain.export.hypertext;

import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.export.ImagePathData;
import com.nlbhub.nlb.domain.export.SoundPathData;
import com.nlbhub.nlb.domain.export.hypertext.HypertextExportManager;
import com.nlbhub.nlb.domain.export.hypertext.document.HTDocument;
import com.nlbhub.nlb.domain.export.hypertext.document.HTFont;
import com.nlbhub.nlb.domain.export.hypertext.document.PDFAnchor;
import com.nlbhub.nlb.domain.export.hypertext.document.PDFDocument;
import com.nlbhub.nlb.domain.export.hypertext.document.PDFFont;
import com.nlbhub.nlb.domain.export.hypertext.document.PDFParagraph;
import com.nlbhub.nlb.domain.export.hypertext.document.RGBColor;
import com.nlbhub.nlb.exception.HTDocumentException;
import com.nlbhub.nlb.exception.NLBExportException;
import java.util.List;

public class PDFExportManager
extends HypertextExportManager<PDFParagraph, PDFAnchor, PDFFont> {
    public PDFExportManager(NonLinearBookImpl nlb, String encoding) throws NLBExportException {
        super(nlb, encoding);
    }

    @Override
    protected String decorateExistence(String decoratedVariable) {
        return "";
    }

    @Override
    protected String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    @Override
    protected HTDocument<PDFParagraph> createDocument(String encoding, String lineSeparator) {
        return new PDFDocument(encoding, lineSeparator);
    }

    @Override
    protected PDFFont createParaFont() throws HTDocumentException {
        return new PDFFont(10.0f, HTFont.Style.REGULAR, new RGBColor(0, 0, 0));
    }

    @Override
    protected PDFFont createLinkFont() throws HTDocumentException {
        return new PDFFont(10.0f, HTFont.Style.UNDERLINE, new RGBColor(0, 0, 255));
    }

    @Override
    protected PDFParagraph createHTParagraph(String text, PDFFont font) throws HTDocumentException {
        return new PDFParagraph(text, font);
    }

    @Override
    protected PDFAnchor createHTAnchor(boolean decapitalize, String text, PDFFont font) throws HTDocumentException {
        return new PDFAnchor(decapitalize, text, font);
    }

    @Override
    protected String decoratePageImage(List<ImagePathData> pageImagePathDatas, boolean imageBackground, Theme theme) {
        return "";
    }

    @Override
    protected String decoratePageSound(String pageName, List<SoundPathData> pageSoundPathDatas, boolean soundSFX, Theme theme) {
        return "";
    }
}

