/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain.export.hypertext;

import com.nlbhub.nlb.api.TextChunk;
import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.export.ImagePathData;
import com.nlbhub.nlb.domain.export.LinkBuildingBlocks;
import com.nlbhub.nlb.domain.export.SoundPathData;
import com.nlbhub.nlb.domain.export.hypertext.HypertextExportManager;
import com.nlbhub.nlb.domain.export.hypertext.document.HTDocument;
import com.nlbhub.nlb.domain.export.hypertext.document.TXTAnchor;
import com.nlbhub.nlb.domain.export.hypertext.document.TXTDocument;
import com.nlbhub.nlb.domain.export.hypertext.document.TXTFont;
import com.nlbhub.nlb.domain.export.hypertext.document.TXTParagraph;
import com.nlbhub.nlb.exception.HTDocumentException;
import com.nlbhub.nlb.exception.NLBExportException;
import java.util.List;

public class TaggedTextExportManager
extends HypertextExportManager<TXTParagraph, TXTAnchor, TXTFont> {
    public TaggedTextExportManager(NonLinearBookImpl nlb, String encoding) throws NLBExportException {
        super(nlb, encoding);
    }

    @Override
    protected String decorateExistence(String decoratedVariable) {
        return "";
    }

    @Override
    protected String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    @Override
    protected String getLinkReference(LinkBuildingBlocks linkBlocks) {
        return linkBlocks.getLinkGoTo();
    }

    @Override
    protected String decorateLinkStart(String linkId, String linkText, boolean isAuto, boolean isTrivial, int pageNumber, Theme theme) {
        return linkText;
    }

    @Override
    protected String decorateLinkGoTo(String linkId, String linkText, String linkSource, int sourcePageNumber, String linkTarget, int targetPageNumber, Theme theme) {
        return String.valueOf(targetPageNumber);
    }

    @Override
    protected HTDocument<TXTParagraph> createDocument(String encoding, String lineSeparator) {
        return new TXTDocument(encoding, lineSeparator);
    }

    @Override
    protected TXTFont createParaFont() throws HTDocumentException {
        return new TXTFont();
    }

    @Override
    protected TXTFont createLinkFont() throws HTDocumentException {
        return new TXTFont();
    }

    @Override
    protected TXTParagraph createHTParagraph(String text, TXTFont font) throws HTDocumentException {
        return new TXTParagraph(text, font);
    }

    @Override
    protected TXTAnchor createHTAnchor(boolean decapitalize, String text, TXTFont font) throws HTDocumentException {
        return new TXTAnchor(decapitalize, text, font);
    }

    @Override
    protected String decoratePageTextStart(String labelText, int pageNumber, List<TextChunk> pageTextChunks, Theme theme) {
        StringBuilder result = new StringBuilder();
        result.append(super.decoratePageTextStart(labelText, pageNumber, pageTextChunks, theme));
        result.append(this.getLineSeparator());
        return result.toString();
    }

    @Override
    protected String decoratePageImage(List<ImagePathData> pageImagePathDatas, boolean imageBackground, Theme theme) {
        return "";
    }

    @Override
    protected String decoratePageSound(String pageName, List<SoundPathData> pageSoundPathDatas, boolean soundSFX, Theme theme) {
        return "";
    }
}

