/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain.export.hypertext.document;

import com.nlbhub.nlb.domain.export.hypertext.document.HTAnchor;
import com.nlbhub.nlb.domain.export.hypertext.document.HTMLFont;
import com.nlbhub.nlb.util.StringHelper;

public class HTMLAnchor
extends HTAnchor<HTMLFont> {
    private String m_name;
    private String m_reference;
    private String m_text;

    public HTMLAnchor(boolean decapitalize, String text, HTMLFont font) {
        super(decapitalize, text, font);
        this.m_text = text;
    }

    public String getText() {
        return this.m_text;
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    public String getReference() {
        return this.m_reference;
    }

    @Override
    public void setReference(String reference) {
        this.m_reference = reference;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("<a ");
        if (!StringHelper.isEmpty(this.m_name)) {
            sb.append("name='").append(this.m_name).append('\'');
        }
        if (!StringHelper.isEmpty(this.m_reference)) {
            sb.append("href='").append(this.m_reference).append('\'');
        }
        sb.append(">");
        if (this.isDecapitalize()) {
            sb.append(this.decapitalize(this.m_text));
        } else {
            sb.append(this.m_text);
        }
        sb.append("</a>");
        return sb.toString();
    }
}

