/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.domain.export.xml;

import com.nlbhub.nlb.domain.NonLinearBookImpl;
import com.nlbhub.nlb.domain.export.ExportManager;
import com.nlbhub.nlb.domain.export.NLBBuildingBlocks;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBExportException;
import com.nlbhub.nlb.exception.NLBJAXBException;
import com.nlbhub.nlb.util.JaxbMarshaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public abstract class XMLExportManager
extends ExportManager {
    protected XMLExportManager(NonLinearBookImpl nlb, String encoding) throws NLBExportException {
        super(nlb, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportToFile(File targetFile) throws NLBExportException {
        OutputStreamWriter writer = null;
        FileOutputStream stream = null;
        try {
            try {
                NLBBuildingBlocks nlbBlocks = this.createNLBBuildingBlocks();
                JaxbMarshaller marshaller = this.createMarshaller();
                Document document = marshaller.getAsDocument(this.createRootObject(nlbBlocks), false);
                stream = new FileOutputStream(targetFile);
                writer = new OutputStreamWriter((OutputStream)stream, this.getEncoding());
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer nullTransformer = transformerFactory.newTransformer();
                nullTransformer.setOutputProperty("indent", "yes");
                nullTransformer.setOutputProperty("cdata-section-elements", this.getCDataSectionElements());
                nullTransformer.transform(new DOMSource(document), new StreamResult(writer));
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (NLBConsistencyException | NLBJAXBException | IOException | TransformerException e) {
            throw new NLBExportException("Error while converting NLB to XML", e);
        }
    }

    protected abstract String getCDataSectionElements();

    protected abstract JaxbMarshaller createMarshaller();

    protected abstract Object createRootObject(NLBBuildingBlocks var1);
}

