/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.util;

import com.nlbhub.nlb.util.StringHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MultiLangString {
    private Map<String, String> m_content = new HashMap<String, String>();

    public MultiLangString(MultiLangString source) {
        this();
        this.m_content.putAll(source.m_content);
    }

    public MultiLangString() {
    }

    public static MultiLangString createEmptyText() {
        return new MultiLangString();
    }

    public static MultiLangString createDefaultLinkText() {
        MultiLangString linkText = new MultiLangString();
        linkText.put("ru", "\u0414\u0430\u043b\u0435\u0435");
        linkText.put("en", "Next");
        return linkText;
    }

    public static MultiLangString createDefaultTraverseText() {
        MultiLangString linkText = new MultiLangString();
        linkText.put("ru", "\u0417\u0430\u0439\u0442\u0438 \u0432\u043d\u0443\u0442\u0440\u044c");
        linkText.put("en", "Go inside");
        return linkText;
    }

    public static MultiLangString createCopy(MultiLangString source) {
        return new MultiLangString(source);
    }

    public Set<String> keySet() {
        return this.m_content.keySet();
    }

    public Collection<String> values() {
        return this.m_content.values();
    }

    public void put(String langKey, String value) {
        this.m_content.put(langKey, value);
    }

    public String get(String langKey) {
        String result = this.m_content.get(langKey);
        return result != null ? result : "";
    }

    public boolean equalsAs(String langKey, MultiLangString mlsToCompare) {
        String contentText = this.m_content.get(langKey);
        String contentTextToCompare = mlsToCompare.m_content.get(langKey);
        if (StringHelper.isEmpty(contentText)) {
            return StringHelper.isEmpty(contentTextToCompare);
        }
        return contentText.equals(contentTextToCompare);
    }

    public boolean isSubsetOf(MultiLangString mlsToCompare) {
        for (Map.Entry<String, String> entry : this.m_content.entrySet()) {
            String valueToCompare = mlsToCompare.get(entry.getKey());
            if (StringHelper.isEmpty(valueToCompare) && !StringHelper.isEmpty(entry.getValue())) {
                return false;
            }
            if (valueToCompare.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (Map.Entry<String, String> entry : this.m_content.entrySet()) {
            if (!StringHelper.notEmpty(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiLangString that = (MultiLangString)o;
        return !(this.m_content != null ? !this.m_content.equals(that.m_content) : that.m_content != null);
    }

    public int hashCode() {
        return this.m_content != null ? this.m_content.hashCode() : 0;
    }
}

