/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.vcs;

import com.nlbhub.nlb.api.ProgressData;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.vcs.Author;
import com.nlbhub.nlb.vcs.VCSAdapter;
import com.nlbhub.nlb.vcs.VCSProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.TreeWalk;

public class GitAdapter
implements VCSAdapter {
    private Repository m_localRepo = null;
    private Git m_git = null;
    private Map<String, VCSAdapter.Status> m_statuses = new HashMap<String, VCSAdapter.Status>();
    private Author m_author;

    public GitAdapter(Author author) {
        this.m_author = author;
    }

    @Override
    public void initRepo(String path) throws NLBVCSException {
        try {
            this.m_localRepo = FileRepositoryBuilder.create((File)new File(path, ".git"));
            GitAdapter.enableLongPaths(this.m_localRepo, false);
            this.m_localRepo.create();
            this.m_git = new Git(this.m_localRepo);
            this.initStatuses(false);
            this.commit("Initial commit");
        }
        catch (IOException e) {
            throw new NLBVCSException("Error while Git repository initialization", e);
        }
    }

    private static void enableLongPaths(Repository repository, boolean save) throws IOException {
        StoredConfig config = repository.getConfig();
        config.setString("core", null, "longpaths", "true");
        if (save) {
            config.save();
        }
    }

    @Override
    public void openRepo(String path) throws NLBVCSException {
        try {
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            this.m_localRepo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setWorkTree(new File(path))).readEnvironment()).setGitDir(new File(path, ".git"))).build();
            GitAdapter.enableLongPaths(this.m_localRepo, true);
            this.m_git = new Git(this.m_localRepo);
            this.initStatuses(true);
        }
        catch (IOException e) {
            throw new NLBVCSException("Error while Git repository opening", e);
        }
    }

    @Override
    public void closeAdapter() throws NLBVCSException {
        if (this.m_git != null) {
            this.m_git.close();
            this.m_git = null;
        }
        if (this.m_localRepo != null) {
            this.m_localRepo.close();
            this.m_localRepo = null;
        }
        this.m_statuses.clear();
    }

    @Override
    public boolean getDirAddFlag() {
        return false;
    }

    @Override
    public boolean getAddModifiedFilesFlag() {
        return true;
    }

    private void initStatuses(boolean processExistentFiles) throws NLBVCSException {
        this.m_statuses.clear();
        try {
            if (processExistentFiles) {
                List<String> filePaths = this.listRepositoryContents();
                for (String filePath : filePaths) {
                    this.m_statuses.put(filePath, VCSAdapter.Status.Clean);
                }
            }
            Status status = this.m_git.status().call();
            this.putItemsStatus(status.getAdded(), VCSAdapter.Status.Added);
            this.putItemsStatus(status.getChanged(), VCSAdapter.Status.Modified);
            this.putItemsStatus(status.getModified(), VCSAdapter.Status.Modified);
            this.putItemsStatus(status.getConflicting(), VCSAdapter.Status.Conflict);
            this.putItemsStatus(status.getIgnoredNotInIndex(), VCSAdapter.Status.Ignored);
            this.putItemsStatus(status.getMissing(), VCSAdapter.Status.Missing);
            this.putItemsStatus(status.getRemoved(), VCSAdapter.Status.Removed);
            this.putItemsStatus(status.getUntracked(), VCSAdapter.Status.Unknown);
            this.putItemsStatus(status.getUntrackedFolders(), VCSAdapter.Status.Unknown);
        }
        catch (IOException | GitAPIException e) {
            throw new NLBVCSException("Error while obtaining Git repository status", e);
        }
    }

    private List<String> listRepositoryContents() throws IOException, NLBVCSException {
        ArrayList<String> result = new ArrayList<String>();
        Ref head = this.m_localRepo.getRef("HEAD");
        if (head == null) {
            throw new NLBVCSException("Your Git repository is broken.\nPlease either properly clone it (using 'git clone' command) or use 'runlight' command to run the program.");
        }
        ObjectId objectId = head.getObjectId();
        if (objectId != null) {
            RevWalk walk = new RevWalk(this.m_localRepo);
            RevCommit commit = walk.parseCommit((AnyObjectId)objectId);
            RevTree tree = commit.getTree();
            TreeWalk treeWalk = new TreeWalk(this.m_localRepo);
            treeWalk.addTree((AnyObjectId)tree);
            treeWalk.setRecursive(false);
            while (treeWalk.next()) {
                if (treeWalk.isSubtree()) {
                    treeWalk.enterSubtree();
                    continue;
                }
                result.add(treeWalk.getPathString());
            }
        }
        return result;
    }

    private void putItemsStatus(Set<String> paths, VCSAdapter.Status status) {
        for (String path : paths) {
            this.m_statuses.put(path, status);
        }
    }

    @Override
    public VCSAdapter.Status getStatus(String path) throws NLBVCSException {
        VCSAdapter.Status status = this.m_statuses.get(path);
        if (status == null) {
            return VCSAdapter.Status.VCS_Undefined;
        }
        return status;
    }

    @Override
    public void add(String path) throws NLBVCSException {
        try {
            VCSAdapter.Status prevStatus = this.getStatus(path);
            this.m_git.add().addFilepattern(path).call();
            if (prevStatus == VCSAdapter.Status.Unknown || prevStatus == VCSAdapter.Status.VCS_Undefined) {
                this.m_statuses.put(path, VCSAdapter.Status.Added);
            }
        }
        catch (GitAPIException e) {
            throw new NLBVCSException("Error while adding to the Git repository", e);
        }
    }

    @Override
    public boolean remove(String path) throws NLBVCSException {
        try {
            this.m_git.rm().addFilepattern(path).setCached(true).call();
            this.m_statuses.put(path, VCSAdapter.Status.Removed);
            return false;
        }
        catch (GitAPIException e) {
            throw new NLBVCSException("Error while removing from the Git repository", e);
        }
    }

    @Override
    public void reset(String path) throws NLBVCSException {
        try {
            VCSAdapter.Status status = this.getStatus(path);
            this.m_git.reset().addPath(path).setRef("HEAD").call();
            switch (status) {
                case Added: {
                    this.m_statuses.put(path, VCSAdapter.Status.Unknown);
                    break;
                }
                case Removed: 
                case Modified: 
                case Missing: 
                case Clean: {
                    this.m_statuses.put(path, VCSAdapter.Status.Clean);
                    break;
                }
                case Unknown: 
                case Ignored: {
                    throw new NLBVCSException("Cannot issue reset command for file with path = " + path + ", because its status was " + (Object)((Object)status));
                }
            }
        }
        catch (GitAPIException e) {
            throw new NLBVCSException("Error while adding to the Git repository", e);
        }
    }

    @Override
    public void commit(String message) throws NLBVCSException {
        try {
            this.m_git.commit().setAll(false).setAmend(false).setAuthor(this.m_author.getName(), this.m_author.getEmail()).setMessage(message).call();
        }
        catch (GitAPIException e) {
            throw new NLBVCSException("Error while committing to the Git repository", e);
        }
    }

    @Override
    public void pull(String userName, String password, ProgressData progressData) throws NLBVCSException {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider(userName, password);
        progressData.setNoteText("Pulling...");
        VCSProgressMonitor monitor = new VCSProgressMonitor(progressData);
        try {
            ((PullCommand)this.m_git.pull().setRemote("origin").setCredentialsProvider((CredentialsProvider)provider)).setProgressMonitor((ProgressMonitor)monitor).call();
            this.m_git.clean().setCleanDirectories(true).setDryRun(false).setIgnore(true).call();
        }
        catch (GitAPIException e) {
            throw new NLBVCSException("Error while pulling from the Git repository: " + e.getMessage(), e);
        }
    }

    @Override
    public void push(String userName, String password, ProgressData progressData) throws NLBVCSException {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider(userName, password);
        progressData.setNoteText("Pushing...");
        VCSProgressMonitor monitor = new VCSProgressMonitor(progressData);
        try {
            ((PushCommand)this.m_git.push().setRemote("origin").setCredentialsProvider((CredentialsProvider)provider)).setProgressMonitor((ProgressMonitor)monitor).call();
        }
        catch (GitAPIException e) {
            throw new NLBVCSException("Error while pushing to the Git repository: " + e.getMessage(), e);
        }
    }
}

