/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.user.domain;

import com.nlbhub.nlb.util.StringHelper;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="decision-point")
public class DecisionPoint {
    private String m_bookId;
    private String m_fromPageId;
    private String m_toPageId;
    private String m_linkId;
    private String m_text;
    private Integer m_visitCount = 1;
    private List<DecisionPoint> m_possibleNextDecisionPoints = new ArrayList<DecisionPoint>();

    public DecisionPoint() {
    }

    public DecisionPoint(String bookId, String fromPageId, String linkId) {
        this();
        this.m_bookId = bookId;
        this.m_fromPageId = fromPageId;
        this.m_toPageId = "";
        this.m_linkId = linkId;
    }

    public DecisionPoint(String bookId, String toPageId) {
        this();
        this.m_bookId = bookId;
        this.m_fromPageId = "";
        this.m_toPageId = toPageId;
        this.m_linkId = "";
    }

    @XmlElement(name="bookId")
    public String getBookId() {
        return this.m_bookId;
    }

    public void setBookId(String bookId) {
        this.m_bookId = bookId;
    }

    @XmlElement(name="fromPageId")
    public String getFromPageId() {
        return this.m_fromPageId;
    }

    public void setFromPageId(String fromPageId) {
        this.m_fromPageId = fromPageId;
    }

    @XmlElement(name="toPageId")
    public String getToPageId() {
        return this.m_toPageId;
    }

    public void setToPageId(String toPageId) {
        this.m_toPageId = toPageId;
    }

    @XmlElement(name="linkId")
    public String getLinkId() {
        return this.m_linkId;
    }

    public void setLinkId(String linkId) {
        this.m_linkId = linkId;
    }

    public void addPossibleNextDecisionPoint(DecisionPoint decisionPoint) {
        this.m_possibleNextDecisionPoints.add(decisionPoint);
    }

    @XmlElement(name="text")
    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        this.m_text = text;
    }

    @XmlElement(name="visit-count")
    public Integer getVisitCount() {
        return this.m_visitCount;
    }

    public void setVisitCount(Integer visitCount) {
        this.m_visitCount = visitCount;
    }

    public void incVisitCount() {
        this.m_visitCount = this.m_visitCount + 1;
    }

    public List<DecisionPoint> getPossibleNextDecisionPoints() {
        return this.m_possibleNextDecisionPoints;
    }

    @XmlElement(name="is-link-info")
    public boolean isLinkInfo() {
        return !StringHelper.isEmpty(this.m_linkId);
    }

    public void clearPossibleNextDecisionPoints() {
        this.m_possibleNextDecisionPoints.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionPoint that = (DecisionPoint)o;
        if (!this.m_bookId.equals(that.m_bookId)) {
            return false;
        }
        if (!this.m_fromPageId.equals(that.m_fromPageId)) {
            return false;
        }
        if (!this.m_linkId.equals(that.m_linkId)) {
            return false;
        }
        return this.m_toPageId.equals(that.m_toPageId);
    }

    public int hashCode() {
        int result = this.m_bookId.hashCode();
        result = 31 * result + this.m_fromPageId.hashCode();
        result = 31 * result + this.m_toPageId.hashCode();
        result = 31 * result + this.m_linkId.hashCode();
        return result;
    }
}

