/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.form;

import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.Theme;
import com.nlbhub.nlb.domain.NonLinearBookFacade;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class DialogBookProperties
extends JDialog {
    private NonLinearBookFacade m_nlbFacade;
    private DefaultComboBoxModel<String> m_languageComboboxModel;
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextArea m_licenseTextArea;
    private JComboBox m_languageComboBox;
    private JTextField m_authorTextField;
    private JTextField m_versionTextField;
    private JCheckBox m_propagateToSubmodulesCheckBox;
    private JCheckBox m_fullAutowireCheckBox;
    private JCheckBox m_suppressMediaCheckBox;
    private JCheckBox m_suppressSoundCheckBox;
    private JTextField m_titleTextField;
    private JTextField m_perfectGameAchievementTextField;
    private JComboBox m_themeComboBox;

    public DialogBookProperties(NonLinearBookFacade nlbFacade) {
        this.$$$setupUI$$$();
        this.m_nlbFacade = nlbFacade;
        this.setBookProperties();
        this.setContentPane(this.contentPane);
        this.setTitle("Book properties");
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogBookProperties.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogBookProperties.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogBookProperties.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogBookProperties.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void setBookProperties() {
        Theme[] possibleValues;
        NonLinearBook nonLinearBook = this.m_nlbFacade.getNlb();
        this.m_licenseTextArea.setText(nonLinearBook.getLicense());
        this.m_titleTextField.setText(nonLinearBook.getTitle());
        this.m_authorTextField.setText(nonLinearBook.getAuthor());
        this.m_versionTextField.setText(nonLinearBook.getVersion());
        this.m_perfectGameAchievementTextField.setText(nonLinearBook.getPerfectGameAchievementName());
        this.m_fullAutowireCheckBox.setSelected(nonLinearBook.isFullAutowire());
        this.m_suppressMediaCheckBox.setSelected(nonLinearBook.isSuppressMedia());
        this.m_suppressSoundCheckBox.setSelected(nonLinearBook.isSuppressSound());
        this.m_languageComboboxModel = new DefaultComboBoxModel();
        this.m_languageComboboxModel.addElement("ru");
        this.m_languageComboboxModel.addElement("en");
        this.m_languageComboBox.setModel(this.m_languageComboboxModel);
        this.m_languageComboBox.setSelectedIndex(nonLinearBook.getLanguage().equals("ru") ? 0 : 1);
        DefaultComboBoxModel<Theme> themeComboboxModel = new DefaultComboBoxModel<Theme>();
        for (Theme theme : possibleValues = (Theme[])nonLinearBook.getTheme().getDeclaringClass().getEnumConstants()) {
            themeComboboxModel.addElement(theme);
        }
        this.m_themeComboBox.setModel(themeComboboxModel);
        this.m_themeComboBox.setSelectedItem(nonLinearBook.getTheme());
    }

    public void showDialog() {
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogBookProperties.this.buttonOK.requestFocusInWindow();
            }
        });
        this.setVisible(true);
    }

    private void onOK() {
        this.m_nlbFacade.updateBookProperties(this.m_licenseTextArea.getText(), (Theme)this.m_themeComboBox.getSelectedItem(), this.m_languageComboboxModel.getElementAt(this.m_languageComboBox.getSelectedIndex()), this.m_titleTextField.getText(), this.m_authorTextField.getText(), this.m_versionTextField.getText(), this.m_perfectGameAchievementTextField.getText(), this.m_fullAutowireCheckBox.isSelected(), this.m_suppressMediaCheckBox.isSelected(), this.m_suppressSoundCheckBox.isSelected(), this.m_propagateToSubmodulesCheckBox.isSelected());
        this.dispose();
    }

    private void onCancel() {
        this.dispose();
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout(0, 0));
        this.contentPane.add((Component)panel1, "Center");
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)panel2, "North");
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BorderLayout(0, 0));
        panel2.add((Component)panel3, "Center");
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)panel4, "East");
        JPanel panel5 = new JPanel();
        panel5.setLayout(new GridBagLayout());
        panel4.add((Component)panel5, "North");
        JPanel panel6 = new JPanel();
        panel6.setLayout(new FlowLayout(1, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel5.add((Component)panel6, gbc);
        this.buttonOK = new JButton();
        this.buttonOK.setMaximumSize(new Dimension(85, 25));
        this.buttonOK.setMinimumSize(new Dimension(85, 25));
        this.buttonOK.setPreferredSize(new Dimension(85, 25));
        this.buttonOK.setText("OK");
        panel6.add(this.buttonOK);
        JPanel panel7 = new JPanel();
        panel7.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        panel5.add((Component)panel7, gbc);
        this.buttonCancel = new JButton();
        this.buttonCancel.setMaximumSize(new Dimension(85, 25));
        this.buttonCancel.setMinimumSize(new Dimension(85, 25));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setText("Cancel");
        panel7.add(this.buttonCancel);
        JPanel panel8 = new JPanel();
        panel8.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)panel8, "Center");
        JPanel panel9 = new JPanel();
        panel9.setLayout(new BorderLayout(0, 0));
        panel8.add((Component)panel9, "Center");
        JPanel panel10 = new JPanel();
        panel10.setLayout(new GridBagLayout());
        panel9.add((Component)panel10, "Center");
        JLabel label1 = new JLabel();
        label1.setText("License text");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        panel10.add((Component)label1, gbc);
        JPanel panel11 = new JPanel();
        panel11.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)panel11, gbc);
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setHorizontalScrollBarPolicy(31);
        scrollPane1.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel11.add((Component)scrollPane1, gbc);
        this.m_licenseTextArea = new JTextArea();
        this.m_licenseTextArea.setColumns(50);
        this.m_licenseTextArea.setRows(10);
        scrollPane1.setViewportView(this.m_licenseTextArea);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 11;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        panel10.add((Component)spacer1, gbc);
        JPanel panel12 = new JPanel();
        panel12.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)panel12, gbc);
        JScrollPane scrollPane2 = new JScrollPane();
        scrollPane2.setHorizontalScrollBarPolicy(31);
        scrollPane2.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel12.add((Component)scrollPane2, gbc);
        this.m_languageComboBox = new JComboBox();
        scrollPane2.setViewportView(this.m_languageComboBox);
        JLabel label2 = new JLabel();
        label2.setText("Active language");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        panel10.add((Component)label2, gbc);
        JPanel panel13 = new JPanel();
        panel13.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)panel13, gbc);
        JScrollPane scrollPane3 = new JScrollPane();
        scrollPane3.setHorizontalScrollBarPolicy(31);
        scrollPane3.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel13.add((Component)scrollPane3, gbc);
        this.m_authorTextField = new JTextField();
        scrollPane3.setViewportView(this.m_authorTextField);
        JLabel label3 = new JLabel();
        label3.setText("Author");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 13;
        panel10.add((Component)label3, gbc);
        JPanel panel14 = new JPanel();
        panel14.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)panel14, gbc);
        JScrollPane scrollPane4 = new JScrollPane();
        scrollPane4.setHorizontalScrollBarPolicy(31);
        scrollPane4.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel14.add((Component)scrollPane4, gbc);
        this.m_versionTextField = new JTextField();
        scrollPane4.setViewportView(this.m_versionTextField);
        JLabel label4 = new JLabel();
        label4.setText("Version");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 13;
        panel10.add((Component)label4, gbc);
        JPanel panel15 = new JPanel();
        panel15.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 8;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)panel15, gbc);
        JScrollPane scrollPane5 = new JScrollPane();
        scrollPane5.setHorizontalScrollBarPolicy(31);
        scrollPane5.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel15.add((Component)scrollPane5, gbc);
        this.m_propagateToSubmodulesCheckBox = new JCheckBox();
        this.m_propagateToSubmodulesCheckBox.setSelected(true);
        this.m_propagateToSubmodulesCheckBox.setText("Propagate to submodules");
        scrollPane5.setViewportView(this.m_propagateToSubmodulesCheckBox);
        JPanel panel16 = new JPanel();
        panel16.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)panel16, gbc);
        JScrollPane scrollPane6 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel16.add((Component)scrollPane6, gbc);
        this.m_fullAutowireCheckBox = new JCheckBox();
        this.m_fullAutowireCheckBox.setText("Full autowire");
        scrollPane6.setViewportView(this.m_fullAutowireCheckBox);
        JPanel panel17 = new JPanel();
        panel17.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 9;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)panel17, gbc);
        JScrollPane scrollPane7 = new JScrollPane();
        scrollPane7.setHorizontalScrollBarPolicy(31);
        scrollPane7.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel17.add((Component)scrollPane7, gbc);
        this.m_suppressMediaCheckBox = new JCheckBox();
        this.m_suppressMediaCheckBox.setSelected(false);
        this.m_suppressMediaCheckBox.setText("Suppress media");
        scrollPane7.setViewportView(this.m_suppressMediaCheckBox);
        JPanel panel18 = new JPanel();
        panel18.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 10;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)panel18, gbc);
        JScrollPane scrollPane8 = new JScrollPane();
        scrollPane8.setHorizontalScrollBarPolicy(31);
        scrollPane8.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel18.add((Component)scrollPane8, gbc);
        this.m_suppressSoundCheckBox = new JCheckBox();
        this.m_suppressSoundCheckBox.setSelected(false);
        this.m_suppressSoundCheckBox.setText("Suppress sound");
        scrollPane8.setViewportView(this.m_suppressSoundCheckBox);
        JPanel panel19 = new JPanel();
        panel19.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)panel19, gbc);
        JScrollPane scrollPane9 = new JScrollPane();
        scrollPane9.setHorizontalScrollBarPolicy(31);
        scrollPane9.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel19.add((Component)scrollPane9, gbc);
        this.m_titleTextField = new JTextField();
        scrollPane9.setViewportView(this.m_titleTextField);
        JLabel label5 = new JLabel();
        label5.setText("Title");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 13;
        panel10.add((Component)label5, gbc);
        JPanel panel20 = new JPanel();
        panel20.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)panel20, gbc);
        JScrollPane scrollPane10 = new JScrollPane();
        scrollPane10.setHorizontalScrollBarPolicy(31);
        scrollPane10.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel20.add((Component)scrollPane10, gbc);
        this.m_perfectGameAchievementTextField = new JTextField();
        scrollPane10.setViewportView(this.m_perfectGameAchievementTextField);
        JLabel label6 = new JLabel();
        label6.setText("Perfect game achievement");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.anchor = 13;
        panel10.add((Component)label6, gbc);
        JPanel panel21 = new JPanel();
        panel21.setLayout(new GridBagLayout());
        panel21.setMinimumSize(new Dimension(468, 33));
        panel21.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel10.add((Component)panel21, gbc);
        JScrollPane scrollPane11 = new JScrollPane();
        scrollPane11.setHorizontalScrollBarPolicy(31);
        scrollPane11.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel21.add((Component)scrollPane11, gbc);
        this.m_themeComboBox = new JComboBox();
        scrollPane11.setViewportView(this.m_themeComboBox);
        JLabel label7 = new JLabel();
        label7.setText("Theme");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 13;
        panel10.add((Component)label7, gbc);
        JPanel panel22 = new JPanel();
        panel22.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)panel22, "Center");
        label1.setLabelFor(this.m_licenseTextArea);
        label2.setLabelFor(this.m_languageComboBox);
        label3.setLabelFor(this.m_authorTextField);
        label4.setLabelFor(this.m_versionTextField);
        label5.setLabelFor(this.m_titleTextField);
        label6.setLabelFor(this.m_perfectGameAchievementTextField);
        label7.setLabelFor(this.m_themeComboBox);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

