/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.form;

import com.nlbhub.nlb.api.MediaFile;
import com.nlbhub.nlb.builder.form.DialogSearch;
import com.nlbhub.nlb.builder.form.MainFrame;
import com.nlbhub.nlb.builder.model.ListSingleSelectionModel;
import com.nlbhub.nlb.builder.model.MediaFileModelSwing;
import com.nlbhub.nlb.builder.util.ImageHelper;
import com.nlbhub.nlb.builder.util.WheelScaleListener;
import com.nlbhub.nlb.builder.util.Zoomer;
import com.nlbhub.nlb.domain.NonLinearBookFacade;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBFileManipulationException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import com.nlbhub.nlb.util.StringHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXImageView;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class DialogMediaLibrary
extends JDialog {
    private static final String PH_IMAGE_EXT = ".png";
    private static final File PLACEHOLDER_IMAGE = new File("template/sample.png");
    private static final String PH_SOUND_EXT = ".ogg";
    private static final File PLACEHOLDER_SOUND = new File("template/sample.ogg");
    private final String[] m_itemsSelectedByDefault;
    private final JFileChooser m_fileChooser = new JFileChooser();
    private MediaFileModelSwing m_mediaFileModelSwing;
    private Zoomer m_zoomer;
    private String m_selectedFileName;
    private boolean m_isCanceled = false;
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JPanel m_imagePreviewPanel;
    private JButton m_buttonAdd;
    private JXTable m_mediaFileList;
    private JXImageView m_imageView;
    private JButton m_buttonRemove;
    private JButton m_noneButton;
    private JButton m_voidButton;
    private JButton m_buttonPlaceholder;
    private JButton m_buttonSearchUsages;
    private JButton m_buttonZoomIn;
    private JButton m_buttonZoomOut;

    public DialogMediaLibrary(final MainFrame mainFrame, final NonLinearBookFacade nonLinearBookFacade, final MediaFile.Type mediaType, String[] itemsSelectedByDefault) {
        this.$$$setupUI$$$();
        final DialogMediaLibrary self = this;
        this.setContentPane(this.contentPane);
        this.m_zoomer = new Zoomer(this.m_imageView);
        this.m_mediaFileModelSwing = new MediaFileModelSwing(nonLinearBookFacade, mediaType);
        this.m_mediaFileList.setModel((TableModel)this.m_mediaFileModelSwing);
        ListSingleSelectionModel listSingleSelectionModel = new ListSingleSelectionModel();
        listSingleSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                block4: {
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    if (mediaType != MediaFile.Type.Image) {
                        return;
                    }
                    try {
                        if (lsm.isSelectionEmpty()) break block4;
                        int minIndex = lsm.getMinSelectionIndex();
                        int maxIndex = lsm.getMaxSelectionIndex();
                        for (int i = minIndex; i <= maxIndex; ++i) {
                            if (!lsm.isSelectedIndex(i)) continue;
                            File imageFile = new File(nonLinearBookFacade.getNlb().getImagesDir(), (String)DialogMediaLibrary.this.m_mediaFileModelSwing.getValueAt(i, 0));
                            DialogMediaLibrary.this.m_imageView.setImage(imageFile);
                            DialogMediaLibrary.this.m_imageView.setScale(ImageHelper.getScaleToFit((JPanel)DialogMediaLibrary.this.m_imageView, imageFile));
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        this.m_itemsSelectedByDefault = itemsSelectedByDefault;
        this.m_mediaFileList.setSelectionModel((ListSelectionModel)listSingleSelectionModel);
        TableColumnExt flagColumn = this.m_mediaFileList.getColumnExt(1);
        JComboBox<String> flags = new JComboBox<String>();
        flags.addItem("YES");
        flags.addItem("NO");
        flagColumn.setCellEditor((TableCellEditor)new DefaultCellEditor(flags));
        TableColumnExt redirectColumn = this.m_mediaFileList.getColumnExt(2);
        JComboBox<String> redirects = new JComboBox<String>();
        for (String value : this.m_mediaFileModelSwing.getRedirectsValues()) {
            redirects.addItem(value);
        }
        redirectColumn.setCellEditor((TableCellEditor)new DefaultCellEditor(redirects));
        TableColumnExt constraintColumn = this.m_mediaFileList.getColumnExt(3);
        JComboBox<String> constraints = new JComboBox<String>();
        for (String value : this.m_mediaFileModelSwing.getConstraintsValues()) {
            constraints.addItem(value);
        }
        constraintColumn.setCellEditor((TableCellEditor)new DefaultCellEditor(constraints));
        TableColumnExt presetColumn = this.m_mediaFileList.getColumnExt(4);
        JComboBox<String> presets = new JComboBox<String>();
        for (String value : this.m_mediaFileModelSwing.getPresetsValues()) {
            presets.addItem(value);
        }
        presetColumn.setCellEditor((TableCellEditor)new DefaultCellEditor(presets));
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogMediaLibrary.this.onOK();
            }
        });
        this.m_noneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogMediaLibrary.this.onNone();
            }
        });
        this.m_voidButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogMediaLibrary.this.onVoid();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogMediaLibrary.this.onCancel();
            }
        });
        this.m_buttonSearchUsages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = DialogMediaLibrary.this.m_mediaFileList.getSelectedRow();
                DialogSearch dialog = new DialogSearch(mainFrame, nonLinearBookFacade.getNlb(), "MAIN", selectedRow == -1 ? "" : (String)DialogMediaLibrary.this.m_mediaFileModelSwing.getValueAt(selectedRow, 0));
                dialog.showDialog();
            }
        });
        this.m_buttonPlaceholder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String placeholderName = JOptionPane.showInputDialog("Placeholder name:");
                    if (StringHelper.notEmpty((String)placeholderName)) {
                        switch (mediaType) {
                            case Image: {
                                File tempFile = File.createTempFile("ph_img", "dat");
                                tempFile.deleteOnExit();
                                if (ImageHelper.textToGraphics(placeholderName, tempFile)) {
                                    nonLinearBookFacade.addImageFile(tempFile, placeholderName + DialogMediaLibrary.PH_IMAGE_EXT);
                                    break;
                                }
                                nonLinearBookFacade.addImageFile(PLACEHOLDER_IMAGE, placeholderName + DialogMediaLibrary.PH_IMAGE_EXT);
                                break;
                            }
                            case Sound: {
                                nonLinearBookFacade.addSoundFile(PLACEHOLDER_SOUND, placeholderName + DialogMediaLibrary.PH_SOUND_EXT);
                            }
                        }
                        DialogMediaLibrary.this.m_mediaFileList.updateUI();
                    }
                }
                catch (NLBConsistencyException | NLBFileManipulationException | NLBIOException | NLBVCSException | IOException ex) {
                    JOptionPane.showMessageDialog(self, "Error while adding: " + ex.toString());
                }
            }
        });
        this.m_buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File mediaFile = DialogMediaLibrary.this.chooseMediaFile();
                    if (mediaFile != null) {
                        switch (mediaType) {
                            case Image: {
                                nonLinearBookFacade.addImageFile(mediaFile, null);
                                break;
                            }
                            case Sound: {
                                nonLinearBookFacade.addSoundFile(mediaFile, null);
                            }
                        }
                    }
                    DialogMediaLibrary.this.m_mediaFileList.updateUI();
                }
                catch (NLBConsistencyException | NLBFileManipulationException | NLBIOException | NLBVCSException ex) {
                    JOptionPane.showMessageDialog(self, "Error while adding: " + ex.toString());
                }
            }
        });
        this.m_buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int selectedRow = DialogMediaLibrary.this.m_mediaFileList.getSelectedRow();
                    String mediaFileName = (String)DialogMediaLibrary.this.m_mediaFileModelSwing.getValueAt(selectedRow, 0);
                    switch (mediaType) {
                        case Image: {
                            nonLinearBookFacade.removeImageFile(mediaFileName);
                            break;
                        }
                        case Sound: {
                            nonLinearBookFacade.removeSoundFile(mediaFileName);
                        }
                    }
                    DialogMediaLibrary.this.m_mediaFileList.updateUI();
                }
                catch (NLBConsistencyException | NLBFileManipulationException | NLBIOException ex) {
                    JOptionPane.showMessageDialog(self, "Error while removing: " + ex.toString());
                }
            }
        });
        this.m_buttonZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogMediaLibrary.this.m_zoomer.zoomIn();
            }
        });
        this.m_buttonZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogMediaLibrary.this.m_zoomer.zoomOut();
            }
        });
        this.m_imageView.addMouseWheelListener((MouseWheelListener)new WheelScaleListener(this.m_imageView));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogMediaLibrary.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogMediaLibrary.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        switch (mediaType) {
            case Image: {
                this.m_voidButton.setVisible(false);
                break;
            }
            case Sound: {
                this.m_imagePreviewPanel.setVisible(false);
            }
        }
    }

    private void selectItems(String[] itemsSelectedByDefault) {
        Integer[] focusedLines;
        this.m_mediaFileList.setSelectionMode(2);
        ListSelectionModel model = this.m_mediaFileList.getSelectionModel();
        model.clearSelection();
        for (Integer actualRow : focusedLines = this.getFocusedLines(Arrays.asList(itemsSelectedByDefault))) {
            model.addSelectionInterval(actualRow, actualRow);
        }
        this.m_mediaFileList.requestFocusInWindow();
    }

    private Integer[] getFocusedLines(Collection<String> itemsSelectedByDefault) {
        ArrayList<Integer> selectedLines = new ArrayList<Integer>();
        for (int i = 0; i < this.m_mediaFileModelSwing.getRowCount(); ++i) {
            String value = (String)this.m_mediaFileModelSwing.getValueAt(i, 0);
            if (!itemsSelectedByDefault.contains(value)) continue;
            selectedLines.add(i);
        }
        return selectedLines.toArray(new Integer[selectedLines.size()]);
    }

    private File chooseMediaFile() {
        int returnVal = this.m_fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            return this.m_fileChooser.getSelectedFile();
        }
        return null;
    }

    public void showDialog() {
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogMediaLibrary.this.selectItems(DialogMediaLibrary.this.m_itemsSelectedByDefault);
                DialogMediaLibrary.this.buttonOK.requestFocusInWindow();
            }
        });
        this.setVisible(true);
    }

    private String getSelectedFileNames(int[] selectedRows) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (int selectedRow : selectedRows) {
            if (first) {
                first = false;
            } else {
                result.append(";");
            }
            result.append((String)this.m_mediaFileModelSwing.getValueAt(selectedRow, 0));
        }
        return result.toString();
    }

    private void onOK() {
        int[] selectedRows = this.m_mediaFileList.getSelectedRows();
        this.m_selectedFileName = selectedRows.length == 0 ? null : this.getSelectedFileNames(selectedRows);
        this.dispose();
    }

    private void onNone() {
        this.m_selectedFileName = "";
        this.dispose();
    }

    private void onVoid() {
        this.m_selectedFileName = "VOID";
        this.dispose();
    }

    private void onCancel() {
        this.m_isCanceled = true;
        this.m_selectedFileName = null;
        this.dispose();
    }

    public boolean isCanceled() {
        return this.m_isCanceled;
    }

    public String getSelectedFileName() {
        return this.m_selectedFileName;
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout(0, 0));
        this.contentPane.add((Component)panel1, "South");
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout(1, 0, 0));
        panel1.add((Component)panel2, "East");
        JPanel panel3 = new JPanel();
        panel3.setLayout(new GridBagLayout());
        panel2.add(panel3);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new FlowLayout(1, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel3.add((Component)panel4, gbc);
        this.buttonOK = new JButton();
        this.buttonOK.setMaximumSize(new Dimension(85, 25));
        this.buttonOK.setMinimumSize(new Dimension(85, 25));
        this.buttonOK.setPreferredSize(new Dimension(85, 25));
        this.buttonOK.setText("OK");
        panel4.add(this.buttonOK);
        this.m_noneButton = new JButton();
        this.m_noneButton.setMaximumSize(new Dimension(85, 25));
        this.m_noneButton.setMinimumSize(new Dimension(85, 25));
        this.m_noneButton.setPreferredSize(new Dimension(85, 25));
        this.m_noneButton.setText("None");
        panel4.add(this.m_noneButton);
        this.m_voidButton = new JButton();
        this.m_voidButton.setMaximumSize(new Dimension(85, 25));
        this.m_voidButton.setMinimumSize(new Dimension(85, 25));
        this.m_voidButton.setPreferredSize(new Dimension(85, 25));
        this.m_voidButton.setText("Void");
        panel4.add(this.m_voidButton);
        this.buttonCancel = new JButton();
        this.buttonCancel.setMaximumSize(new Dimension(85, 25));
        this.buttonCancel.setMinimumSize(new Dimension(85, 25));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setText("Cancel");
        panel4.add(this.buttonCancel);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout(1, 0, 0));
        panel1.add((Component)panel5, "West");
        JPanel panel6 = new JPanel();
        panel6.setLayout(new GridBagLayout());
        panel5.add(panel6);
        JPanel panel7 = new JPanel();
        panel7.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel6.add((Component)panel7, gbc);
        this.m_buttonPlaceholder = new JButton();
        this.m_buttonPlaceholder.setMaximumSize(new Dimension(110, 25));
        this.m_buttonPlaceholder.setMinimumSize(new Dimension(110, 25));
        this.m_buttonPlaceholder.setPreferredSize(new Dimension(110, 25));
        this.m_buttonPlaceholder.setText("Placeholder");
        panel7.add(this.m_buttonPlaceholder);
        this.m_buttonAdd = new JButton();
        this.m_buttonAdd.setMaximumSize(new Dimension(85, 25));
        this.m_buttonAdd.setMinimumSize(new Dimension(85, 25));
        this.m_buttonAdd.setPreferredSize(new Dimension(85, 25));
        this.m_buttonAdd.setText("Add...");
        panel7.add(this.m_buttonAdd);
        this.m_buttonRemove = new JButton();
        this.m_buttonRemove.setMaximumSize(new Dimension(85, 25));
        this.m_buttonRemove.setMinimumSize(new Dimension(85, 25));
        this.m_buttonRemove.setPreferredSize(new Dimension(85, 25));
        this.m_buttonRemove.setText("Remove");
        panel7.add(this.m_buttonRemove);
        this.m_buttonSearchUsages = new JButton();
        this.m_buttonSearchUsages.setMaximumSize(new Dimension(115, 25));
        this.m_buttonSearchUsages.setMinimumSize(new Dimension(115, 25));
        this.m_buttonSearchUsages.setPreferredSize(new Dimension(115, 25));
        this.m_buttonSearchUsages.setText("Search usages...");
        panel7.add(this.m_buttonSearchUsages);
        JPanel panel8 = new JPanel();
        panel8.setLayout(new BorderLayout(0, 0));
        this.contentPane.add((Component)panel8, "Center");
        this.m_imagePreviewPanel = new JPanel();
        this.m_imagePreviewPanel.setLayout(new BorderLayout(0, 0));
        this.m_imagePreviewPanel.setMinimumSize(new Dimension(220, 220));
        this.m_imagePreviewPanel.setPreferredSize(new Dimension(220, 220));
        panel8.add((Component)this.m_imagePreviewPanel, "West");
        this.m_imageView = new JXImageView();
        this.m_imagePreviewPanel.add((Component)this.m_imageView, "Center");
        JPanel panel9 = new JPanel();
        panel9.setLayout(new FlowLayout(1, 5, 5));
        this.m_imagePreviewPanel.add((Component)panel9, "North");
        this.m_buttonZoomIn = new JButton();
        this.m_buttonZoomIn.setText("+");
        panel9.add(this.m_buttonZoomIn);
        this.m_buttonZoomOut = new JButton();
        this.m_buttonZoomOut.setText("\u2015");
        panel9.add(this.m_buttonZoomOut);
        JPanel panel10 = new JPanel();
        panel10.setLayout(new BorderLayout(0, 0));
        panel8.add((Component)panel10, "Center");
        JScrollPane scrollPane1 = new JScrollPane();
        panel10.add((Component)scrollPane1, "Center");
        this.m_mediaFileList = new JXTable();
        this.m_mediaFileList.setSortable(false);
        this.m_mediaFileList.setVisibleRowCount(10);
        this.m_mediaFileList.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        scrollPane1.setViewportView((Component)this.m_mediaFileList);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

