/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.form;

import com.nlbhub.nlb.api.MediaFile;
import com.nlbhub.nlb.api.ModifyingItem;
import com.nlbhub.nlb.api.NLBObserver;
import com.nlbhub.nlb.api.Obj;
import com.nlbhub.nlb.api.Variable;
import com.nlbhub.nlb.builder.form.DialogMediaLibrary;
import com.nlbhub.nlb.builder.form.DialogModifications;
import com.nlbhub.nlb.builder.form.MainFrame;
import com.nlbhub.nlb.builder.util.ImageHelper;
import com.nlbhub.nlb.builder.util.WheelScaleListener;
import com.nlbhub.nlb.builder.util.Zoomer;
import com.nlbhub.nlb.domain.NonLinearBookFacade;
import com.nlbhub.nlb.util.MultiLangString;
import com.nlbhub.nlb.util.StringHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXImageView;

public class DialogObjProperties
extends JDialog
implements NLBObserver {
    private final String m_observerId;
    private Zoomer m_zoomer;
    private Obj m_obj;
    private NonLinearBookFacade m_nlbFacade;
    private MultiLangString m_objDisplayNames;
    private MultiLangString m_objTexts;
    private MultiLangString m_objActTexts;
    private MultiLangString m_objNouseTexts;
    private String m_selectedLanguage;
    private String m_imageFileName;
    private String m_soundFileName;
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField m_objIdTextField;
    private JTextField m_objNameTextField;
    private JTextField m_objVariableTextField;
    private JButton m_modificationsButton;
    private JCheckBox m_objIsTakable;
    private JButton m_undoButton;
    private JButton m_redoButton;
    private JTextField m_objDispTextField;
    private JComboBox m_languageComboBox;
    private JTabbedPane m_tabbedPane1;
    private JButton m_setTextColorButton;
    private JButton m_setObjColorButton;
    private JButton m_setBorderColorButton;
    private JButton m_setImageButton;
    private JLabel m_imageFileNameLabel;
    private JXImageView m_imageView;
    private JTextArea m_objTextTextArea;
    private JCheckBox m_imageInScene;
    private JCheckBox m_imageInInventory;
    private JTextArea m_objActTextTextArea;
    private JTextField m_objConstraintTextField;
    private JCheckBox m_animatedImageCheckBox;
    private JButton m_buttonZoomIn;
    private JButton m_buttonZoomOut;
    private JCheckBox m_suppressDsc;
    private JButton m_setSoundButton;
    private JLabel m_soundFileNameLabel;
    private JCheckBox m_soundSFXCheckBox;
    private JTextField m_objCommonToTextField;
    private JTextField m_objDefaultTagTextField;
    private JCheckBox m_objIsGraphical;
    private JTextField m_morphOver;
    private JTextField m_morphOut;
    private JCheckBox m_objIsPreserved;
    private JCheckBox m_objIsClearUnderTooltip;
    private JRadioButton m_movementDirectionTop;
    private JRadioButton m_movementDirectionBottom;
    private JRadioButton m_movementDirectionLeft;
    private JRadioButton m_movementDirectionRight;
    private JRadioButton m_movementDirectionNone;
    private JCheckBox m_objIsCollapsable;
    private JTextField m_offset;
    private JRadioButton m_effectMoveIn;
    private JRadioButton m_effectMoveOut;
    private JRadioButton m_effectFadeIn;
    private JRadioButton m_effectFadeOut;
    private JRadioButton m_effectZoomIn;
    private JRadioButton m_effectZoomOut;
    private JRadioButton m_effectNone;
    private JRadioButton m_coordsOriginLeftTop;
    private JRadioButton m_coordsOriginLeftMiddle;
    private JRadioButton m_coordsOriginLeftBottom;
    private JRadioButton m_coordsOriginMiddleTop;
    private JRadioButton m_coordsOriginMiddleMiddle;
    private JRadioButton m_coordsOriginMiddleBottom;
    private JRadioButton m_coordsOriginRightTop;
    private JRadioButton m_coordsOriginRightMiddle;
    private JRadioButton m_coordsOriginRightBottom;
    private JRadioButton m_effectOverlap;
    private JSpinner m_spinnerMaxFrame;
    private JTextArea m_objDispTextArea;
    private JCheckBox m_objIsActOnKey;
    private JSpinner m_spinnerPreloadFrames;
    private JCheckBox m_objLoadOnce;
    private JCheckBox m_objIsCacheText;
    private JCheckBox m_objIsLooped;
    private JSpinner m_spinnerStartFrame;
    private JCheckBox m_objIsNoRedrawOnAct;
    private JTextArea m_objNouseTextTextArea;
    private JCheckBox m_objIsShowOnCursor;
    private JSpinner m_spinnerPauseFrames;

    public DialogObjProperties(final MainFrame mainFrame, final NonLinearBookFacade nlbFacade, final Obj obj) {
        this.$$$setupUI$$$();
        this.m_nlbFacade = nlbFacade;
        this.setObjProperties(obj);
        this.setContentPane(this.contentPane);
        this.m_zoomer = new Zoomer(this.m_imageView);
        this.setModal(true);
        this.setTitle("Obj properties");
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogObjProperties.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogObjProperties.this.onCancel();
            }
        });
        this.m_undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nlbFacade.undo(obj.getId());
                DialogObjProperties.this.setObjProperties(obj);
                DialogObjProperties.this.setObjImage(obj.getImageFileName());
            }
        });
        this.m_redoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                nlbFacade.redo(obj.getId());
                DialogObjProperties.this.setObjProperties(obj);
                DialogObjProperties.this.setObjImage(obj.getImageFileName());
            }
        });
        this.m_setSoundButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogMediaLibrary dialog = new DialogMediaLibrary(mainFrame, DialogObjProperties.this.m_nlbFacade.getMainFacade(), MediaFile.Type.Sound, DialogObjProperties.this.m_soundFileName.split(";"));
                dialog.showDialog();
                if (!dialog.isCanceled()) {
                    DialogObjProperties.this.m_soundFileName = dialog.getSelectedFileName();
                    DialogObjProperties.this.m_soundFileNameLabel.setText(DialogObjProperties.this.m_soundFileName);
                }
            }
        });
        this.m_modificationsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogModifications dialog = new DialogModifications(DialogObjProperties.this.m_nlbFacade, (ModifyingItem)obj);
                dialog.showDialog();
            }
        });
        this.m_languageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                DialogObjProperties.this.refreshTextsForCurrentLanguage();
                String selectedLanguage = (String)cb.getSelectedItem();
                DialogObjProperties.this.m_objDispTextArea.setText(DialogObjProperties.this.m_objDisplayNames.get(selectedLanguage));
                DialogObjProperties.this.m_objTextTextArea.setText(DialogObjProperties.this.m_objTexts.get(selectedLanguage));
                DialogObjProperties.this.m_objActTextTextArea.setText(DialogObjProperties.this.m_objActTexts.get(selectedLanguage));
                DialogObjProperties.this.m_objNouseTextTextArea.setText(DialogObjProperties.this.m_objNouseTexts.get(selectedLanguage));
                DialogObjProperties.this.m_selectedLanguage = selectedLanguage;
            }
        });
        this.m_setImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogMediaLibrary dialog = new DialogMediaLibrary(mainFrame, DialogObjProperties.this.m_nlbFacade.getMainFacade(), MediaFile.Type.Image, DialogObjProperties.this.m_imageFileName.split(";"));
                dialog.showDialog();
                if (!dialog.isCanceled()) {
                    DialogObjProperties.this.m_imageFileName = dialog.getSelectedFileName();
                    DialogObjProperties.this.m_imageFileNameLabel.setText(DialogObjProperties.this.m_imageFileName);
                    DialogObjProperties.this.setObjImage(DialogObjProperties.this.m_imageFileName);
                }
            }
        });
        this.m_buttonZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogObjProperties.this.m_zoomer.zoomIn();
            }
        });
        this.m_buttonZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogObjProperties.this.m_zoomer.zoomOut();
            }
        });
        this.m_imageView.addMouseWheelListener((MouseWheelListener)new WheelScaleListener(this.m_imageView));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogObjProperties.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogObjProperties.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.m_observerId = nlbFacade.addObserver((NLBObserver)this);
    }

    private void refreshTextsForCurrentLanguage() {
        this.m_objDisplayNames.put(this.m_selectedLanguage, this.m_objDispTextArea.getText());
        this.m_objTexts.put(this.m_selectedLanguage, this.m_objTextTextArea.getText());
        this.m_objActTexts.put(this.m_selectedLanguage, this.m_objActTextTextArea.getText());
        this.m_objNouseTexts.put(this.m_selectedLanguage, this.m_objNouseTextTextArea.getText());
    }

    public void showDialog() {
        this.pack();
        this.updateView();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogObjProperties.this.setObjImage(DialogObjProperties.this.m_obj.getImageFileName());
                DialogObjProperties.this.buttonOK.requestFocusInWindow();
            }
        });
        this.setVisible(true);
    }

    private void setObjProperties(Obj obj) {
        this.m_obj = obj;
        Variable variable = this.m_nlbFacade.getNlb().getVariableById(obj.getVarId());
        Variable deftag = this.m_nlbFacade.getNlb().getVariableById(obj.getDefaultTagId());
        Variable constraint = this.m_nlbFacade.getNlb().getVariableById(obj.getConstrId());
        Variable commonTo = this.m_nlbFacade.getNlb().getVariableById(obj.getCommonToId());
        Variable morphOver = this.m_nlbFacade.getNlb().getVariableById(obj.getMorphOverId());
        Variable morphOut = this.m_nlbFacade.getNlb().getVariableById(obj.getMorphOutId());
        this.m_objIdTextField.setText(obj.getId());
        this.m_objNameTextField.setText(obj.getName());
        this.m_objDispTextArea.setText(obj.getDisp());
        this.m_objVariableTextField.setText(variable != null ? variable.getName() : "");
        this.m_objDefaultTagTextField.setText(deftag != null ? deftag.getValue() : "");
        this.m_objConstraintTextField.setText(constraint != null ? constraint.getValue() : "");
        this.m_objCommonToTextField.setText(commonTo != null ? commonTo.getName() : "");
        this.m_objTextTextArea.setText(obj.getText());
        this.m_objActTextTextArea.setText(obj.getActText());
        this.m_objNouseTextTextArea.setText(obj.getNouseText());
        this.m_suppressDsc.setSelected(obj.isSuppressDsc());
        this.m_objIsTakable.setSelected(obj.isTakable());
        this.m_objIsGraphical.setSelected(obj.isGraphical());
        this.m_objIsShowOnCursor.setSelected(obj.isShowOnCursor());
        this.m_objIsPreserved.setSelected(obj.isPreserved());
        this.m_objLoadOnce.setSelected(obj.isLoadOnce());
        this.m_objIsCollapsable.setSelected(obj.isCollapsable());
        this.m_offset.setText(obj.getOffset());
        switch (obj.getMovementDirection()) {
            case Top: {
                this.m_movementDirectionTop.setSelected(true);
                break;
            }
            case Left: {
                this.m_movementDirectionLeft.setSelected(true);
                break;
            }
            case Right: {
                this.m_movementDirectionRight.setSelected(true);
                break;
            }
            case Bottom: {
                this.m_movementDirectionBottom.setSelected(true);
                break;
            }
            default: {
                this.m_movementDirectionNone.setSelected(true);
            }
        }
        this.m_spinnerStartFrame.setValue(obj.getStartFrame());
        this.m_spinnerMaxFrame.setValue(obj.getMaxFrame());
        this.m_spinnerPreloadFrames.setValue(obj.getPreloadFrames());
        this.m_spinnerPauseFrames.setValue(obj.getPauseFrames());
        switch (obj.getEffect()) {
            case MoveIn: {
                this.m_effectMoveIn.setSelected(true);
                break;
            }
            case MoveOut: {
                this.m_effectMoveOut.setSelected(true);
                break;
            }
            case ZoomIn: {
                this.m_effectZoomIn.setSelected(true);
                break;
            }
            case ZoomOut: {
                this.m_effectZoomOut.setSelected(true);
                break;
            }
            case FadeIn: {
                this.m_effectFadeIn.setSelected(true);
                break;
            }
            case FadeOut: {
                this.m_effectFadeOut.setSelected(true);
                break;
            }
            case Overlap: {
                this.m_effectOverlap.setSelected(true);
                break;
            }
            default: {
                this.m_effectNone.setSelected(true);
            }
        }
        switch (obj.getCoordsOrigin()) {
            case LeftTop: {
                this.m_coordsOriginLeftTop.setSelected(true);
                break;
            }
            case MiddleTop: {
                this.m_coordsOriginMiddleTop.setSelected(true);
                break;
            }
            case RightTop: {
                this.m_coordsOriginRightTop.setSelected(true);
                break;
            }
            case LeftMiddle: {
                this.m_coordsOriginLeftMiddle.setSelected(true);
                break;
            }
            case MiddleMiddle: {
                this.m_coordsOriginMiddleMiddle.setSelected(true);
                break;
            }
            case RightMiddle: {
                this.m_coordsOriginRightMiddle.setSelected(true);
                break;
            }
            case LeftBottom: {
                this.m_coordsOriginLeftBottom.setSelected(true);
                break;
            }
            case MiddleBottom: {
                this.m_coordsOriginMiddleBottom.setSelected(true);
                break;
            }
            case RightBottom: {
                this.m_coordsOriginRightBottom.setSelected(true);
                break;
            }
            default: {
                this.m_coordsOriginLeftTop.setSelected(true);
            }
        }
        this.m_objIsClearUnderTooltip.setSelected(obj.isClearUnderTooltip());
        this.m_objIsActOnKey.setSelected(obj.isActOnKey());
        this.m_objIsCacheText.setSelected(obj.isCacheText());
        this.m_objIsLooped.setSelected(obj.isLooped());
        this.m_objIsNoRedrawOnAct.setSelected(obj.isNoRedrawOnAct());
        this.m_morphOver.setText(morphOver != null ? morphOver.getName() : "");
        this.m_morphOut.setText(morphOut != null ? morphOut.getName() : "");
        this.m_imageInScene.setSelected(obj.isImageInScene());
        this.m_imageInInventory.setSelected(obj.isImageInInventory());
        this.m_soundFileName = obj.getSoundFileName();
        this.m_soundSFXCheckBox.setSelected(obj.isSoundSFX());
        this.m_soundFileNameLabel.setText(this.m_soundFileName);
        DefaultComboBoxModel<String> languageComboboxModel = new DefaultComboBoxModel<String>();
        languageComboboxModel.addElement("ru");
        languageComboboxModel.addElement("en");
        this.m_languageComboBox.setModel(languageComboboxModel);
        this.m_languageComboBox.setSelectedIndex(obj.getCurrentNLB().getLanguage().equals("ru") ? 0 : 1);
        this.m_objDisplayNames = obj.getDisps();
        this.m_objTexts = obj.getTexts();
        this.m_objActTexts = obj.getActTexts();
        this.m_objNouseTexts = obj.getNouseTexts();
        this.m_selectedLanguage = (String)languageComboboxModel.getSelectedItem();
        this.m_imageFileName = obj.getImageFileName();
        this.m_animatedImageCheckBox.setSelected(obj.isAnimatedImage());
        this.m_imageFileNameLabel.setText(this.m_imageFileName);
    }

    private void onOK() {
        this.refreshTextsForCurrentLanguage();
        this.m_nlbFacade.updateObj(this.m_obj, this.m_objVariableTextField.getText(), this.m_objDefaultTagTextField.getText(), this.m_objConstraintTextField.getText(), this.m_objCommonToTextField.getText(), this.m_objNameTextField.getText(), this.m_imageFileName, this.m_soundFileName, this.m_soundSFXCheckBox.isSelected(), this.m_animatedImageCheckBox.isSelected(), this.m_suppressDsc.isSelected(), this.m_objDisplayNames, this.m_objTexts, this.m_objActTexts, this.m_objNouseTexts, this.m_objIsGraphical.isSelected(), this.m_objIsShowOnCursor.isSelected(), this.m_objIsPreserved.isSelected(), this.m_objLoadOnce.isSelected(), this.m_objIsCollapsable.isSelected(), this.m_offset.getText(), this.getMovementDirection(), this.getEffect(), Integer.parseInt(this.m_spinnerStartFrame.getValue().toString()), Integer.parseInt(this.m_spinnerMaxFrame.getValue().toString()), Integer.parseInt(this.m_spinnerPreloadFrames.getValue().toString()), Integer.parseInt(this.m_spinnerPauseFrames.getValue().toString()), this.getCoordsOrigin(), this.m_objIsClearUnderTooltip.isSelected(), this.m_objIsActOnKey.isSelected(), this.m_objIsCacheText.isSelected(), this.m_objIsLooped.isSelected(), this.m_objIsNoRedrawOnAct.isSelected(), this.m_morphOver.getText(), this.m_morphOut.getText(), this.m_objIsTakable.isSelected(), this.m_imageInScene.isSelected(), this.m_imageInInventory.isSelected());
        this.m_nlbFacade.removeObserver(this.m_observerId);
        this.dispose();
    }

    private Obj.CoordsOrigin getCoordsOrigin() {
        if (this.m_coordsOriginLeftTop.isSelected()) {
            return Obj.CoordsOrigin.LeftTop;
        }
        if (this.m_coordsOriginMiddleTop.isSelected()) {
            return Obj.CoordsOrigin.MiddleTop;
        }
        if (this.m_coordsOriginRightTop.isSelected()) {
            return Obj.CoordsOrigin.RightTop;
        }
        if (this.m_coordsOriginLeftMiddle.isSelected()) {
            return Obj.CoordsOrigin.LeftMiddle;
        }
        if (this.m_coordsOriginMiddleMiddle.isSelected()) {
            return Obj.CoordsOrigin.MiddleMiddle;
        }
        if (this.m_coordsOriginRightMiddle.isSelected()) {
            return Obj.CoordsOrigin.RightMiddle;
        }
        if (this.m_coordsOriginLeftBottom.isSelected()) {
            return Obj.CoordsOrigin.LeftBottom;
        }
        if (this.m_coordsOriginMiddleBottom.isSelected()) {
            return Obj.CoordsOrigin.MiddleBottom;
        }
        if (this.m_coordsOriginRightBottom.isSelected()) {
            return Obj.CoordsOrigin.RightBottom;
        }
        return Obj.CoordsOrigin.LeftTop;
    }

    private Obj.Effect getEffect() {
        if (this.m_effectFadeIn.isSelected()) {
            return Obj.Effect.FadeIn;
        }
        if (this.m_effectFadeOut.isSelected()) {
            return Obj.Effect.FadeOut;
        }
        if (this.m_effectZoomIn.isSelected()) {
            return Obj.Effect.ZoomIn;
        }
        if (this.m_effectZoomOut.isSelected()) {
            return Obj.Effect.ZoomOut;
        }
        if (this.m_effectMoveIn.isSelected()) {
            return Obj.Effect.MoveIn;
        }
        if (this.m_effectMoveOut.isSelected()) {
            return Obj.Effect.MoveOut;
        }
        if (this.m_effectOverlap.isSelected()) {
            return Obj.Effect.Overlap;
        }
        return Obj.Effect.None;
    }

    Obj.MovementDirection getMovementDirection() {
        if (this.m_movementDirectionTop.isSelected()) {
            return Obj.MovementDirection.Top;
        }
        if (this.m_movementDirectionLeft.isSelected()) {
            return Obj.MovementDirection.Left;
        }
        if (this.m_movementDirectionRight.isSelected()) {
            return Obj.MovementDirection.Right;
        }
        if (this.m_movementDirectionBottom.isSelected()) {
            return Obj.MovementDirection.Bottom;
        }
        return Obj.MovementDirection.None;
    }

    private void onCancel() {
        this.m_nlbFacade.redoAll(this.m_obj.getId());
        this.m_nlbFacade.removeObserver(this.m_observerId);
        this.dispose();
    }

    public void updateView() {
        this.m_undoButton.setEnabled(this.m_nlbFacade.canUndo(this.m_obj.getId()));
        this.m_redoButton.setEnabled(this.m_nlbFacade.canRedo(this.m_obj.getId()));
    }

    private void setObjImage(String imageFileName) {
        try {
            if (StringHelper.isEmpty((String)this.m_imageFileName)) {
                this.m_imageView.setVisible(false);
            } else {
                File file = new File(this.m_nlbFacade.getMainFacade().getNlb().getImagesDir(), imageFileName);
                if (file.exists()) {
                    this.m_imageView.setImage(file);
                    this.m_imageView.setScale(ImageHelper.getScaleToFit((JPanel)this.m_imageView, file));
                    this.m_imageView.setVisible(true);
                } else {
                    this.m_imageView.setVisible(false);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout(0, 0));
        this.contentPane.add((Component)panel1, "Center");
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)panel2, "North");
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BorderLayout(0, 0));
        panel2.add((Component)panel3, "Center");
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)panel4, "East");
        JPanel panel5 = new JPanel();
        panel5.setLayout(new GridBagLayout());
        panel4.add((Component)panel5, "North");
        JPanel panel6 = new JPanel();
        panel6.setLayout(new FlowLayout(1, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel5.add((Component)panel6, gbc);
        this.buttonOK = new JButton();
        this.buttonOK.setMaximumSize(new Dimension(120, 36));
        this.buttonOK.setMinimumSize(new Dimension(120, 36));
        this.buttonOK.setPreferredSize(new Dimension(120, 36));
        this.buttonOK.setText("OK");
        panel6.add(this.buttonOK);
        JPanel panel7 = new JPanel();
        panel7.setLayout(new FlowLayout(1, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        panel5.add((Component)panel7, gbc);
        this.buttonCancel = new JButton();
        this.buttonCancel.setMaximumSize(new Dimension(120, 36));
        this.buttonCancel.setMinimumSize(new Dimension(120, 36));
        this.buttonCancel.setPreferredSize(new Dimension(120, 36));
        this.buttonCancel.setText("Cancel");
        panel7.add(this.buttonCancel);
        JPanel panel8 = new JPanel();
        panel8.setLayout(new BorderLayout(0, 0));
        panel4.add((Component)panel8, "Center");
        JPanel panel9 = new JPanel();
        panel9.setLayout(new BorderLayout(0, 0));
        panel8.add((Component)panel9, "North");
        JPanel panel10 = new JPanel();
        panel10.setLayout(new FlowLayout(1, 5, 5));
        panel9.add((Component)panel10, "North");
        this.m_setSoundButton = new JButton();
        this.m_setSoundButton.setMaximumSize(new Dimension(120, 36));
        this.m_setSoundButton.setMinimumSize(new Dimension(120, 36));
        this.m_setSoundButton.setPreferredSize(new Dimension(120, 36));
        this.m_setSoundButton.setText("Set sound...");
        panel10.add(this.m_setSoundButton);
        JPanel panel11 = new JPanel();
        panel11.setLayout(new BorderLayout(0, 0));
        panel9.add((Component)panel11, "Center");
        JPanel panel12 = new JPanel();
        panel12.setLayout(new BorderLayout(0, 0));
        panel11.add((Component)panel12, "North");
        this.m_soundFileNameLabel = new JLabel();
        this.m_soundFileNameLabel.setHorizontalAlignment(0);
        this.m_soundFileNameLabel.setHorizontalTextPosition(0);
        this.m_soundFileNameLabel.setText("<NO_SOUND>");
        panel12.add((Component)this.m_soundFileNameLabel, "Center");
        this.m_soundSFXCheckBox = new JCheckBox();
        this.m_soundSFXCheckBox.setText("SFX");
        panel12.add((Component)this.m_soundSFXCheckBox, "North");
        JPanel panel13 = new JPanel();
        panel13.setLayout(new BorderLayout(0, 0));
        panel8.add((Component)panel13, "Center");
        JPanel panel14 = new JPanel();
        panel14.setLayout(new FlowLayout(1, 5, 5));
        panel13.add((Component)panel14, "North");
        this.m_setImageButton = new JButton();
        this.m_setImageButton.setMaximumSize(new Dimension(120, 36));
        this.m_setImageButton.setMinimumSize(new Dimension(120, 36));
        this.m_setImageButton.setPreferredSize(new Dimension(120, 36));
        this.m_setImageButton.setText("Set image...");
        panel14.add(this.m_setImageButton);
        JPanel panel15 = new JPanel();
        panel15.setLayout(new BorderLayout(0, 0));
        panel13.add((Component)panel15, "Center");
        JPanel panel16 = new JPanel();
        panel16.setLayout(new BorderLayout(0, 0));
        panel15.add((Component)panel16, "North");
        this.m_imageFileNameLabel = new JLabel();
        this.m_imageFileNameLabel.setHorizontalAlignment(0);
        this.m_imageFileNameLabel.setHorizontalTextPosition(0);
        this.m_imageFileNameLabel.setText("<NO IMAGE>");
        panel16.add((Component)this.m_imageFileNameLabel, "Center");
        JPanel panel17 = new JPanel();
        panel17.setLayout(new FlowLayout(1, 5, 5));
        panel16.add((Component)panel17, "South");
        this.m_buttonZoomIn = new JButton();
        this.m_buttonZoomIn.setText("+");
        panel17.add(this.m_buttonZoomIn);
        this.m_buttonZoomOut = new JButton();
        this.m_buttonZoomOut.setText("\u2015");
        panel17.add(this.m_buttonZoomOut);
        this.m_imageView = new JXImageView();
        panel15.add((Component)this.m_imageView, "Center");
        JPanel panel18 = new JPanel();
        panel18.setLayout(new BorderLayout(0, 0));
        panel3.add((Component)panel18, "Center");
        JPanel panel19 = new JPanel();
        panel19.setLayout(new BorderLayout(0, 0));
        panel18.add((Component)panel19, "North");
        JToolBar toolBar1 = new JToolBar();
        toolBar1.setBorderPainted(false);
        toolBar1.setFloatable(false);
        panel19.add((Component)toolBar1, "West");
        this.m_undoButton = new JButton();
        this.m_undoButton.setIcon(new ImageIcon(this.getClass().getResource("/common/undo.png")));
        this.m_undoButton.setText("Undo");
        toolBar1.add(this.m_undoButton);
        this.m_redoButton = new JButton();
        this.m_redoButton.setIcon(new ImageIcon(this.getClass().getResource("/common/redo.png")));
        this.m_redoButton.setText("Redo");
        toolBar1.add(this.m_redoButton);
        this.m_languageComboBox = new JComboBox();
        panel19.add((Component)this.m_languageComboBox, "East");
        JPanel panel20 = new JPanel();
        panel20.setLayout(new BorderLayout(0, 0));
        panel18.add((Component)panel20, "Center");
        this.m_tabbedPane1 = new JTabbedPane();
        panel20.add((Component)this.m_tabbedPane1, "Center");
        JPanel panel21 = new JPanel();
        panel21.setLayout(new GridBagLayout());
        this.m_tabbedPane1.addTab("Text", panel21);
        JPanel panel22 = new JPanel();
        panel22.setLayout(new GridBagLayout());
        panel22.setMinimumSize(new Dimension(468, 33));
        panel22.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel21.add((Component)panel22, gbc);
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setHorizontalScrollBarPolicy(31);
        scrollPane1.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel22.add((Component)scrollPane1, gbc);
        this.m_objDispTextArea = new JTextArea();
        this.m_objDispTextArea.setColumns(50);
        this.m_objDispTextArea.setLineWrap(true);
        this.m_objDispTextArea.setRows(10);
        this.m_objDispTextArea.setWrapStyleWord(true);
        scrollPane1.setViewportView(this.m_objDispTextArea);
        JLabel label1 = new JLabel();
        Font label1Font = this.$$$getFont$$$(null, -1, -1, label1.getFont());
        if (label1Font != null) {
            label1.setFont(label1Font);
        }
        label1.setText("Obj display name");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        panel21.add((Component)label1, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        panel21.add((Component)spacer1, gbc);
        JPanel panel23 = new JPanel();
        panel23.setLayout(new GridBagLayout());
        panel23.setMinimumSize(new Dimension(468, 33));
        panel23.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel21.add((Component)panel23, gbc);
        JScrollPane scrollPane2 = new JScrollPane();
        scrollPane2.setHorizontalScrollBarPolicy(31);
        scrollPane2.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel23.add((Component)scrollPane2, gbc);
        this.m_objTextTextArea = new JTextArea();
        this.m_objTextTextArea.setColumns(50);
        this.m_objTextTextArea.setLineWrap(true);
        this.m_objTextTextArea.setRows(10);
        this.m_objTextTextArea.setWrapStyleWord(true);
        scrollPane2.setViewportView(this.m_objTextTextArea);
        JLabel label2 = new JLabel();
        Font label2Font = this.$$$getFont$$$(null, -1, -1, label2.getFont());
        if (label2Font != null) {
            label2.setFont(label2Font);
        }
        label2.setText("Obj text");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        panel21.add((Component)label2, gbc);
        JPanel panel24 = new JPanel();
        panel24.setLayout(new GridBagLayout());
        panel24.setMinimumSize(new Dimension(468, 33));
        panel24.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel21.add((Component)panel24, gbc);
        JScrollPane scrollPane3 = new JScrollPane();
        scrollPane3.setHorizontalScrollBarPolicy(31);
        scrollPane3.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel24.add((Component)scrollPane3, gbc);
        this.m_objActTextTextArea = new JTextArea();
        this.m_objActTextTextArea.setColumns(50);
        this.m_objActTextTextArea.setLineWrap(true);
        this.m_objActTextTextArea.setRows(10);
        this.m_objActTextTextArea.setWrapStyleWord(true);
        scrollPane3.setViewportView(this.m_objActTextTextArea);
        JLabel label3 = new JLabel();
        Font label3Font = this.$$$getFont$$$(null, -1, -1, label3.getFont());
        if (label3Font != null) {
            label3.setFont(label3Font);
        }
        label3.setText("Obj Act text");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 13;
        panel21.add((Component)label3, gbc);
        JPanel panel25 = new JPanel();
        panel25.setLayout(new GridBagLayout());
        panel25.setMinimumSize(new Dimension(468, 33));
        panel25.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel21.add((Component)panel25, gbc);
        JScrollPane scrollPane4 = new JScrollPane();
        scrollPane4.setHorizontalScrollBarPolicy(31);
        scrollPane4.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel25.add((Component)scrollPane4, gbc);
        this.m_objNouseTextTextArea = new JTextArea();
        this.m_objNouseTextTextArea.setColumns(50);
        this.m_objNouseTextTextArea.setLineWrap(true);
        this.m_objNouseTextTextArea.setRows(10);
        this.m_objNouseTextTextArea.setWrapStyleWord(true);
        scrollPane4.setViewportView(this.m_objNouseTextTextArea);
        JLabel label4 = new JLabel();
        Font label4Font = this.$$$getFont$$$(null, -1, -1, label4.getFont());
        if (label4Font != null) {
            label4.setFont(label4Font);
        }
        label4.setText("Obj nouse text");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 13;
        panel21.add((Component)label4, gbc);
        JPanel panel26 = new JPanel();
        panel26.setLayout(new GridBagLayout());
        this.m_tabbedPane1.addTab("Properties", panel26);
        JLabel label5 = new JLabel();
        label5.setText("Obj Id");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        panel26.add((Component)label5, gbc);
        JLabel label6 = new JLabel();
        Font label6Font = this.$$$getFont$$$(null, -1, -1, label6.getFont());
        if (label6Font != null) {
            label6.setFont(label6Font);
        }
        label6.setText("Obj name");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        panel26.add((Component)label6, gbc);
        JPanel panel27 = new JPanel();
        panel27.setLayout(new GridBagLayout());
        panel27.setMinimumSize(new Dimension(468, 33));
        panel27.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel26.add((Component)panel27, gbc);
        JScrollPane scrollPane5 = new JScrollPane();
        scrollPane5.setHorizontalScrollBarPolicy(31);
        scrollPane5.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel27.add((Component)scrollPane5, gbc);
        this.m_objIdTextField = new JTextField();
        this.m_objIdTextField.setColumns(40);
        this.m_objIdTextField.setEditable(false);
        scrollPane5.setViewportView(this.m_objIdTextField);
        JPanel panel28 = new JPanel();
        panel28.setLayout(new GridBagLayout());
        panel28.setMinimumSize(new Dimension(468, 33));
        panel28.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel26.add((Component)panel28, gbc);
        JScrollPane scrollPane6 = new JScrollPane();
        scrollPane6.setHorizontalScrollBarPolicy(31);
        scrollPane6.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel28.add((Component)scrollPane6, gbc);
        this.m_objNameTextField = new JTextField();
        this.m_objNameTextField.setColumns(40);
        scrollPane6.setViewportView(this.m_objNameTextField);
        JPanel panel29 = new JPanel();
        panel29.setLayout(new BorderLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel26.add((Component)panel29, gbc);
        JPanel panel30 = new JPanel();
        panel30.setLayout(new FlowLayout(1, 5, 5));
        panel29.add((Component)panel30, "East");
        this.m_modificationsButton = new JButton();
        this.m_modificationsButton.setText("Modifications...");
        panel30.add(this.m_modificationsButton);
        JPanel panel31 = new JPanel();
        panel31.setLayout(new FlowLayout(0, 5, 5));
        panel29.add((Component)panel31, "West");
        this.m_setTextColorButton = new JButton();
        this.m_setTextColorButton.setEnabled(false);
        this.m_setTextColorButton.setText("Set text color");
        panel31.add(this.m_setTextColorButton);
        this.m_setObjColorButton = new JButton();
        this.m_setObjColorButton.setEnabled(false);
        this.m_setObjColorButton.setText("Set obj color");
        panel31.add(this.m_setObjColorButton);
        this.m_setBorderColorButton = new JButton();
        this.m_setBorderColorButton.setEnabled(false);
        this.m_setBorderColorButton.setText("Set border color");
        panel31.add(this.m_setBorderColorButton);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel26.add((Component)spacer2, gbc);
        JLabel label7 = new JLabel();
        label7.setText("Obj variable");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 13;
        panel26.add((Component)label7, gbc);
        JPanel panel32 = new JPanel();
        panel32.setLayout(new GridBagLayout());
        panel32.setMinimumSize(new Dimension(468, 33));
        panel32.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel26.add((Component)panel32, gbc);
        JScrollPane scrollPane7 = new JScrollPane();
        scrollPane7.setHorizontalScrollBarPolicy(31);
        scrollPane7.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel32.add((Component)scrollPane7, gbc);
        this.m_objVariableTextField = new JTextField();
        this.m_objVariableTextField.setColumns(40);
        scrollPane7.setViewportView(this.m_objVariableTextField);
        JPanel panel33 = new JPanel();
        panel33.setLayout(new FlowLayout(0, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.fill = 1;
        panel26.add((Component)panel33, gbc);
        this.m_objIsTakable = new JCheckBox();
        this.m_objIsTakable.setText("Can be taken to the inventory");
        panel33.add(this.m_objIsTakable);
        this.m_suppressDsc = new JCheckBox();
        this.m_suppressDsc.setText("Suppress dsc");
        panel33.add(this.m_suppressDsc);
        this.m_imageInScene = new JCheckBox();
        this.m_imageInScene.setText("Image in scene");
        panel33.add(this.m_imageInScene);
        this.m_imageInInventory = new JCheckBox();
        this.m_imageInInventory.setText("Image in inventory");
        panel33.add(this.m_imageInInventory);
        this.m_animatedImageCheckBox = new JCheckBox();
        this.m_animatedImageCheckBox.setText("Animated image");
        panel33.add(this.m_animatedImageCheckBox);
        JPanel panel34 = new JPanel();
        panel34.setLayout(new GridBagLayout());
        panel34.setMinimumSize(new Dimension(468, 33));
        panel34.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel26.add((Component)panel34, gbc);
        JScrollPane scrollPane8 = new JScrollPane();
        scrollPane8.setHorizontalScrollBarPolicy(31);
        scrollPane8.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel34.add((Component)scrollPane8, gbc);
        this.m_objConstraintTextField = new JTextField();
        this.m_objConstraintTextField.setColumns(40);
        scrollPane8.setViewportView(this.m_objConstraintTextField);
        JLabel label8 = new JLabel();
        label8.setText("Obj constraint");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 13;
        panel26.add((Component)label8, gbc);
        JPanel panel35 = new JPanel();
        panel35.setLayout(new GridBagLayout());
        panel35.setMinimumSize(new Dimension(468, 33));
        panel35.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel26.add((Component)panel35, gbc);
        JScrollPane scrollPane9 = new JScrollPane();
        scrollPane9.setHorizontalScrollBarPolicy(31);
        scrollPane9.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel35.add((Component)scrollPane9, gbc);
        this.m_objCommonToTextField = new JTextField();
        this.m_objCommonToTextField.setColumns(40);
        scrollPane9.setViewportView(this.m_objCommonToTextField);
        JLabel label9 = new JLabel();
        label9.setText("Common To");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 13;
        panel26.add((Component)label9, gbc);
        JPanel panel36 = new JPanel();
        panel36.setLayout(new GridBagLayout());
        panel36.setMinimumSize(new Dimension(468, 33));
        panel36.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel26.add((Component)panel36, gbc);
        JScrollPane scrollPane10 = new JScrollPane();
        scrollPane10.setHorizontalScrollBarPolicy(31);
        scrollPane10.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel36.add((Component)scrollPane10, gbc);
        this.m_objDefaultTagTextField = new JTextField();
        this.m_objDefaultTagTextField.setColumns(40);
        scrollPane10.setViewportView(this.m_objDefaultTagTextField);
        JLabel label10 = new JLabel();
        label10.setText("Default tag");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 13;
        panel26.add((Component)label10, gbc);
        JPanel panel37 = new JPanel();
        panel37.setLayout(new GridBagLayout());
        this.m_tabbedPane1.addTab("Graphical", panel37);
        JPanel spacer3 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        panel37.add((Component)spacer3, gbc);
        JLabel label11 = new JLabel();
        label11.setText("Morph over");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        panel37.add((Component)label11, gbc);
        JPanel spacer4 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel37.add((Component)spacer4, gbc);
        JPanel panel38 = new JPanel();
        panel38.setLayout(new GridBagLayout());
        panel38.setMinimumSize(new Dimension(468, 33));
        panel38.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel37.add((Component)panel38, gbc);
        JScrollPane scrollPane11 = new JScrollPane();
        scrollPane11.setHorizontalScrollBarPolicy(31);
        scrollPane11.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel38.add((Component)scrollPane11, gbc);
        this.m_morphOver = new JTextField();
        this.m_morphOver.setColumns(40);
        scrollPane11.setViewportView(this.m_morphOver);
        JPanel panel39 = new JPanel();
        panel39.setLayout(new FlowLayout(0, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.fill = 1;
        panel37.add((Component)panel39, gbc);
        this.m_objIsGraphical = new JCheckBox();
        this.m_objIsGraphical.setText("Graphical");
        panel39.add(this.m_objIsGraphical);
        this.m_objIsShowOnCursor = new JCheckBox();
        this.m_objIsShowOnCursor.setText("Show on cursor");
        panel39.add(this.m_objIsShowOnCursor);
        this.m_objIsPreserved = new JCheckBox();
        this.m_objIsPreserved.setText("Preserved");
        panel39.add(this.m_objIsPreserved);
        this.m_objLoadOnce = new JCheckBox();
        this.m_objLoadOnce.setText("Load once");
        panel39.add(this.m_objLoadOnce);
        this.m_objIsCollapsable = new JCheckBox();
        this.m_objIsCollapsable.setText("Collapsable");
        panel39.add(this.m_objIsCollapsable);
        this.m_objIsClearUnderTooltip = new JCheckBox();
        this.m_objIsClearUnderTooltip.setText("Clear under tooltip");
        panel39.add(this.m_objIsClearUnderTooltip);
        this.m_objIsActOnKey = new JCheckBox();
        this.m_objIsActOnKey.setText("Act on key");
        panel39.add(this.m_objIsActOnKey);
        this.m_objIsCacheText = new JCheckBox();
        this.m_objIsCacheText.setText("Cache text");
        panel39.add(this.m_objIsCacheText);
        this.m_objIsLooped = new JCheckBox();
        this.m_objIsLooped.setText("Looped");
        panel39.add(this.m_objIsLooped);
        this.m_objIsNoRedrawOnAct = new JCheckBox();
        this.m_objIsNoRedrawOnAct.setText("Don't redraw on act");
        panel39.add(this.m_objIsNoRedrawOnAct);
        JPanel panel40 = new JPanel();
        panel40.setLayout(new GridBagLayout());
        panel40.setMinimumSize(new Dimension(468, 33));
        panel40.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel37.add((Component)panel40, gbc);
        JScrollPane scrollPane12 = new JScrollPane();
        scrollPane12.setHorizontalScrollBarPolicy(31);
        scrollPane12.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel40.add((Component)scrollPane12, gbc);
        this.m_morphOut = new JTextField();
        this.m_morphOut.setColumns(40);
        scrollPane12.setViewportView(this.m_morphOut);
        JLabel label12 = new JLabel();
        label12.setText("Morph out");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        panel37.add((Component)label12, gbc);
        JPanel panel41 = new JPanel();
        panel41.setLayout(new FlowLayout(0, 5, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel37.add((Component)panel41, gbc);
        JPanel panel42 = new JPanel();
        panel42.setLayout(new BorderLayout(0, 0));
        panel42.setMinimumSize(new Dimension(380, 180));
        panel42.setPreferredSize(new Dimension(380, 180));
        panel41.add(panel42);
        panel42.setBorder(BorderFactory.createTitledBorder("Coords origin"));
        JPanel panel43 = new JPanel();
        panel43.setLayout(new BorderLayout(0, 0));
        panel42.add((Component)panel43, "Center");
        JPanel panel44 = new JPanel();
        panel44.setLayout(new GridBagLayout());
        panel43.add((Component)panel44, "Center");
        this.m_coordsOriginLeftTop = new JRadioButton();
        this.m_coordsOriginLeftTop.setMinimumSize(new Dimension(130, 26));
        this.m_coordsOriginLeftTop.setPreferredSize(new Dimension(130, 26));
        this.m_coordsOriginLeftTop.setText("left-top");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.33;
        gbc.weighty = 0.33;
        panel44.add((Component)this.m_coordsOriginLeftTop, gbc);
        JPanel spacer5 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel44.add((Component)spacer5, gbc);
        JPanel spacer6 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        panel44.add((Component)spacer6, gbc);
        this.m_coordsOriginMiddleTop = new JRadioButton();
        this.m_coordsOriginMiddleTop.setMinimumSize(new Dimension(130, 26));
        this.m_coordsOriginMiddleTop.setPreferredSize(new Dimension(130, 26));
        this.m_coordsOriginMiddleTop.setText("middle-top");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.33;
        gbc.weighty = 0.33;
        panel44.add((Component)this.m_coordsOriginMiddleTop, gbc);
        this.m_coordsOriginLeftMiddle = new JRadioButton();
        this.m_coordsOriginLeftMiddle.setMinimumSize(new Dimension(130, 26));
        this.m_coordsOriginLeftMiddle.setPreferredSize(new Dimension(130, 26));
        this.m_coordsOriginLeftMiddle.setText("left-middle");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.33;
        gbc.weighty = 0.33;
        panel44.add((Component)this.m_coordsOriginLeftMiddle, gbc);
        this.m_coordsOriginMiddleMiddle = new JRadioButton();
        this.m_coordsOriginMiddleMiddle.setMinimumSize(new Dimension(130, 26));
        this.m_coordsOriginMiddleMiddle.setPreferredSize(new Dimension(130, 26));
        this.m_coordsOriginMiddleMiddle.setText("middle-middle");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.33;
        gbc.weighty = 0.33;
        panel44.add((Component)this.m_coordsOriginMiddleMiddle, gbc);
        this.m_coordsOriginLeftBottom = new JRadioButton();
        this.m_coordsOriginLeftBottom.setMinimumSize(new Dimension(130, 26));
        this.m_coordsOriginLeftBottom.setPreferredSize(new Dimension(130, 26));
        this.m_coordsOriginLeftBottom.setText("left-bottom");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.33;
        gbc.weighty = 0.33;
        panel44.add((Component)this.m_coordsOriginLeftBottom, gbc);
        this.m_coordsOriginMiddleBottom = new JRadioButton();
        this.m_coordsOriginMiddleBottom.setMinimumSize(new Dimension(130, 26));
        this.m_coordsOriginMiddleBottom.setPreferredSize(new Dimension(130, 26));
        this.m_coordsOriginMiddleBottom.setText("middle-bottom");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 0.33;
        gbc.weighty = 0.33;
        panel44.add((Component)this.m_coordsOriginMiddleBottom, gbc);
        this.m_coordsOriginRightBottom = new JRadioButton();
        this.m_coordsOriginRightBottom.setMinimumSize(new Dimension(130, 26));
        this.m_coordsOriginRightBottom.setPreferredSize(new Dimension(130, 26));
        this.m_coordsOriginRightBottom.setText("right-bottom");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.weightx = 0.33;
        gbc.weighty = 0.33;
        panel44.add((Component)this.m_coordsOriginRightBottom, gbc);
        this.m_coordsOriginRightMiddle = new JRadioButton();
        this.m_coordsOriginRightMiddle.setMinimumSize(new Dimension(130, 26));
        this.m_coordsOriginRightMiddle.setPreferredSize(new Dimension(130, 26));
        this.m_coordsOriginRightMiddle.setText("right-middle");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0.33;
        gbc.weighty = 0.33;
        panel44.add((Component)this.m_coordsOriginRightMiddle, gbc);
        this.m_coordsOriginRightTop = new JRadioButton();
        this.m_coordsOriginRightTop.setMinimumSize(new Dimension(130, 26));
        this.m_coordsOriginRightTop.setPreferredSize(new Dimension(130, 26));
        this.m_coordsOriginRightTop.setText("right-top");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.33;
        gbc.weighty = 0.33;
        panel44.add((Component)this.m_coordsOriginRightTop, gbc);
        JPanel panel45 = new JPanel();
        panel45.setLayout(new BorderLayout(0, 0));
        panel45.setMinimumSize(new Dimension(260, 180));
        panel45.setPreferredSize(new Dimension(260, 180));
        panel41.add(panel45);
        panel45.setBorder(BorderFactory.createTitledBorder("Effect"));
        JPanel panel46 = new JPanel();
        panel46.setLayout(new BorderLayout(0, 0));
        panel45.add((Component)panel46, "Center");
        JPanel panel47 = new JPanel();
        panel47.setLayout(new GridBagLayout());
        panel46.add((Component)panel47, "Center");
        this.m_effectMoveIn = new JRadioButton();
        this.m_effectMoveIn.setMinimumSize(new Dimension(90, 26));
        this.m_effectMoveIn.setPreferredSize(new Dimension(90, 26));
        this.m_effectMoveIn.setText("movein");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel47.add((Component)this.m_effectMoveIn, gbc);
        JPanel spacer7 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel47.add((Component)spacer7, gbc);
        JPanel spacer8 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        panel47.add((Component)spacer8, gbc);
        this.m_effectMoveOut = new JRadioButton();
        this.m_effectMoveOut.setMinimumSize(new Dimension(90, 26));
        this.m_effectMoveOut.setPreferredSize(new Dimension(90, 26));
        this.m_effectMoveOut.setText("moveout");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        panel47.add((Component)this.m_effectMoveOut, gbc);
        this.m_effectFadeIn = new JRadioButton();
        this.m_effectFadeIn.setMinimumSize(new Dimension(90, 26));
        this.m_effectFadeIn.setPreferredSize(new Dimension(90, 26));
        this.m_effectFadeIn.setText("fadein");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel47.add((Component)this.m_effectFadeIn, gbc);
        this.m_effectFadeOut = new JRadioButton();
        this.m_effectFadeOut.setMinimumSize(new Dimension(90, 26));
        this.m_effectFadeOut.setPreferredSize(new Dimension(90, 26));
        this.m_effectFadeOut.setText("fadeout");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        panel47.add((Component)this.m_effectFadeOut, gbc);
        this.m_effectZoomIn = new JRadioButton();
        this.m_effectZoomIn.setMinimumSize(new Dimension(90, 26));
        this.m_effectZoomIn.setPreferredSize(new Dimension(90, 26));
        this.m_effectZoomIn.setText("zoomin");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        panel47.add((Component)this.m_effectZoomIn, gbc);
        this.m_effectZoomOut = new JRadioButton();
        this.m_effectZoomOut.setMinimumSize(new Dimension(90, 26));
        this.m_effectZoomOut.setPreferredSize(new Dimension(90, 26));
        this.m_effectZoomOut.setText("zoomout");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        panel47.add((Component)this.m_effectZoomOut, gbc);
        this.m_effectNone = new JRadioButton();
        this.m_effectNone.setMinimumSize(new Dimension(90, 26));
        this.m_effectNone.setPreferredSize(new Dimension(90, 26));
        this.m_effectNone.setText("none");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        panel47.add((Component)this.m_effectNone, gbc);
        this.m_effectOverlap = new JRadioButton();
        this.m_effectOverlap.setMinimumSize(new Dimension(90, 26));
        this.m_effectOverlap.setPreferredSize(new Dimension(90, 26));
        this.m_effectOverlap.setText("overlap");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        panel47.add((Component)this.m_effectOverlap, gbc);
        JPanel panel48 = new JPanel();
        panel48.setLayout(new FlowLayout(0, 5, 5));
        panel48.setMinimumSize(new Dimension(140, 180));
        panel48.setPreferredSize(new Dimension(140, 180));
        panel41.add(panel48);
        panel48.setBorder(BorderFactory.createTitledBorder("Frames"));
        JPanel panel49 = new JPanel();
        panel49.setLayout(new BorderLayout(0, 0));
        panel49.setMinimumSize(new Dimension(110, 30));
        panel49.setPreferredSize(new Dimension(110, 30));
        panel48.add(panel49);
        JLabel label13 = new JLabel();
        label13.setText("Start");
        panel49.add((Component)label13, "West");
        this.m_spinnerStartFrame = new JSpinner();
        this.m_spinnerStartFrame.setMinimumSize(new Dimension(60, 26));
        this.m_spinnerStartFrame.setPreferredSize(new Dimension(60, 26));
        panel49.add((Component)this.m_spinnerStartFrame, "East");
        JPanel panel50 = new JPanel();
        panel50.setLayout(new BorderLayout(0, 0));
        panel50.setMinimumSize(new Dimension(110, 30));
        panel50.setPreferredSize(new Dimension(110, 30));
        panel48.add(panel50);
        JLabel label14 = new JLabel();
        label14.setText("Max");
        panel50.add((Component)label14, "West");
        this.m_spinnerMaxFrame = new JSpinner();
        this.m_spinnerMaxFrame.setMinimumSize(new Dimension(60, 26));
        this.m_spinnerMaxFrame.setPreferredSize(new Dimension(60, 26));
        panel50.add((Component)this.m_spinnerMaxFrame, "East");
        JPanel panel51 = new JPanel();
        panel51.setLayout(new BorderLayout(0, 0));
        panel51.setMinimumSize(new Dimension(110, 30));
        panel51.setPreferredSize(new Dimension(110, 30));
        panel48.add(panel51);
        JLabel label15 = new JLabel();
        label15.setText("Preload");
        panel51.add((Component)label15, "West");
        this.m_spinnerPreloadFrames = new JSpinner();
        this.m_spinnerPreloadFrames.setMinimumSize(new Dimension(60, 26));
        this.m_spinnerPreloadFrames.setPreferredSize(new Dimension(60, 26));
        panel51.add((Component)this.m_spinnerPreloadFrames, "East");
        JPanel panel52 = new JPanel();
        panel52.setLayout(new BorderLayout(0, 0));
        panel52.setMinimumSize(new Dimension(110, 30));
        panel52.setPreferredSize(new Dimension(110, 30));
        panel48.add(panel52);
        JLabel label16 = new JLabel();
        label16.setText("Pause");
        panel52.add((Component)label16, "West");
        this.m_spinnerPauseFrames = new JSpinner();
        this.m_spinnerPauseFrames.setMinimumSize(new Dimension(60, 26));
        this.m_spinnerPauseFrames.setPreferredSize(new Dimension(60, 26));
        panel52.add((Component)this.m_spinnerPauseFrames, "East");
        JPanel panel53 = new JPanel();
        panel53.setLayout(new BorderLayout(0, 0));
        panel53.setMinimumSize(new Dimension(260, 150));
        panel53.setPreferredSize(new Dimension(260, 150));
        panel41.add(panel53);
        panel53.setBorder(BorderFactory.createTitledBorder("Movement direction"));
        JPanel panel54 = new JPanel();
        panel54.setLayout(new FlowLayout(1, 5, 5));
        panel53.add((Component)panel54, "North");
        this.m_movementDirectionTop = new JRadioButton();
        this.m_movementDirectionTop.setMinimumSize(new Dimension(90, 26));
        this.m_movementDirectionTop.setPreferredSize(new Dimension(90, 26));
        this.m_movementDirectionTop.setText("Top");
        panel54.add(this.m_movementDirectionTop);
        JPanel panel55 = new JPanel();
        panel55.setLayout(new FlowLayout(1, 5, 5));
        panel53.add((Component)panel55, "South");
        this.m_movementDirectionBottom = new JRadioButton();
        this.m_movementDirectionBottom.setMinimumSize(new Dimension(90, 26));
        this.m_movementDirectionBottom.setPreferredSize(new Dimension(90, 26));
        this.m_movementDirectionBottom.setText("Bottom");
        panel55.add(this.m_movementDirectionBottom);
        JPanel panel56 = new JPanel();
        panel56.setLayout(new FlowLayout(1, 5, 5));
        panel53.add((Component)panel56, "Center");
        this.m_movementDirectionNone = new JRadioButton();
        this.m_movementDirectionNone.setMinimumSize(new Dimension(90, 26));
        this.m_movementDirectionNone.setPreferredSize(new Dimension(90, 26));
        this.m_movementDirectionNone.setText("None");
        panel56.add(this.m_movementDirectionNone);
        JPanel panel57 = new JPanel();
        panel57.setLayout(new FlowLayout(1, 5, 5));
        panel53.add((Component)panel57, "West");
        this.m_movementDirectionLeft = new JRadioButton();
        this.m_movementDirectionLeft.setMinimumSize(new Dimension(60, 26));
        this.m_movementDirectionLeft.setPreferredSize(new Dimension(60, 26));
        this.m_movementDirectionLeft.setText("Left");
        panel57.add(this.m_movementDirectionLeft);
        JPanel panel58 = new JPanel();
        panel58.setLayout(new FlowLayout(1, 5, 5));
        panel53.add((Component)panel58, "East");
        this.m_movementDirectionRight = new JRadioButton();
        this.m_movementDirectionRight.setMinimumSize(new Dimension(60, 26));
        this.m_movementDirectionRight.setPreferredSize(new Dimension(60, 26));
        this.m_movementDirectionRight.setText("Right");
        panel58.add(this.m_movementDirectionRight);
        JPanel panel59 = new JPanel();
        panel59.setLayout(new GridBagLayout());
        panel59.setMinimumSize(new Dimension(468, 33));
        panel59.setPreferredSize(new Dimension(468, 33));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        panel37.add((Component)panel59, gbc);
        JScrollPane scrollPane13 = new JScrollPane();
        scrollPane13.setHorizontalScrollBarPolicy(31);
        scrollPane13.setVerticalScrollBarPolicy(21);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel59.add((Component)scrollPane13, gbc);
        this.m_offset = new JTextField();
        this.m_offset.setColumns(40);
        scrollPane13.setViewportView(this.m_offset);
        JLabel label17 = new JLabel();
        label17.setText("Offset");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        panel37.add((Component)label17, gbc);
        JPanel panel60 = new JPanel();
        panel60.setLayout(new BorderLayout(0, 0));
        panel1.add((Component)panel60, "Center");
        label1.setLabelFor(this.m_objDispTextArea);
        label2.setLabelFor(this.m_objTextTextArea);
        label3.setLabelFor(this.m_objActTextTextArea);
        label4.setLabelFor(this.m_objNouseTextTextArea);
        label5.setLabelFor(this.m_objIdTextField);
        label6.setLabelFor(this.m_objNameTextField);
        label7.setLabelFor(this.m_objVariableTextField);
        label8.setLabelFor(this.m_objConstraintTextField);
        label9.setLabelFor(this.m_objCommonToTextField);
        label10.setLabelFor(this.m_objDefaultTagTextField);
        label11.setLabelFor(this.m_morphOver);
        label12.setLabelFor(this.m_morphOut);
        label13.setLabelFor(this.m_spinnerStartFrame);
        label14.setLabelFor(this.m_spinnerMaxFrame);
        label15.setLabelFor(this.m_spinnerPreloadFrames);
        label16.setLabelFor(this.m_spinnerPauseFrames);
        label17.setLabelFor(this.m_offset);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_movementDirectionNone);
        buttonGroup.add(this.m_movementDirectionNone);
        buttonGroup.add(this.m_movementDirectionBottom);
        buttonGroup.add(this.m_movementDirectionTop);
        buttonGroup.add(this.m_movementDirectionRight);
        buttonGroup.add(this.m_movementDirectionLeft);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_effectNone);
        buttonGroup.add(this.m_effectNone);
        buttonGroup.add(this.m_effectFadeIn);
        buttonGroup.add(this.m_effectMoveOut);
        buttonGroup.add(this.m_effectZoomIn);
        buttonGroup.add(this.m_effectMoveIn);
        buttonGroup.add(this.m_effectZoomOut);
        buttonGroup.add(this.m_effectFadeOut);
        buttonGroup.add(this.m_effectOverlap);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_coordsOriginLeftBottom);
        buttonGroup.add(this.m_coordsOriginLeftBottom);
        buttonGroup.add(this.m_coordsOriginMiddleTop);
        buttonGroup.add(this.m_coordsOriginRightMiddle);
        buttonGroup.add(this.m_coordsOriginRightTop);
        buttonGroup.add(this.m_coordsOriginLeftMiddle);
        buttonGroup.add(this.m_coordsOriginLeftTop);
        buttonGroup.add(this.m_coordsOriginMiddleBottom);
        buttonGroup.add(this.m_coordsOriginMiddleMiddle);
        buttonGroup.add(this.m_coordsOriginRightBottom);
    }

    private Font $$$getFont$$$(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        return new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

