/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.model;

import com.nlbhub.nlb.api.MediaFile;
import com.nlbhub.nlb.api.Variable;
import com.nlbhub.nlb.domain.MediaExportParameters;
import com.nlbhub.nlb.domain.NonLinearBookFacade;
import com.nlbhub.nlb.util.StringHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class MediaFileModelSwing
extends AbstractTableModel {
    private static final String NC = "<N/C>";
    private NonLinearBookFacade m_nonLinearBookFacade;
    private MediaFile.Type m_mediaType;
    private Map<String, String> m_namesToIdsMap;
    private Set<String> m_usages;

    public MediaFileModelSwing(NonLinearBookFacade nonLinearBookFacade, MediaFile.Type mediaType) {
        this.m_nonLinearBookFacade = nonLinearBookFacade;
        this.m_mediaType = mediaType;
        this.m_namesToIdsMap = new HashMap<String, String>();
        this.m_namesToIdsMap.put(NC, "");
        for (Variable variable : nonLinearBookFacade.getNlb().getVariables()) {
            if (variable.getType() != Variable.Type.TAG || this.m_namesToIdsMap.containsKey(variable.getValue())) continue;
            this.m_namesToIdsMap.put(variable.getValue(), variable.getId());
        }
        switch (this.m_mediaType) {
            case Image: {
                this.m_usages = this.m_nonLinearBookFacade.getNlb().getUsedImages();
                break;
            }
            case Sound: {
                this.m_usages = this.m_nonLinearBookFacade.getNlb().getUsedSounds();
                break;
            }
            default: {
                this.m_usages = Collections.emptySet();
            }
        }
    }

    public List<String> getRedirectsValues() {
        ArrayList<String> result = new ArrayList<String>();
        List mediaFiles = null;
        switch (this.m_mediaType) {
            case Image: {
                mediaFiles = this.m_nonLinearBookFacade.getNlb().getImageFiles();
                break;
            }
            case Sound: {
                mediaFiles = this.m_nonLinearBookFacade.getNlb().getSoundFiles();
            }
        }
        if (mediaFiles != null) {
            for (MediaFile mediaFile : mediaFiles) {
                if (!StringHelper.isEmpty((String)mediaFile.getRedirect())) continue;
                result.add(mediaFile.getFileName());
            }
        }
        result.add(NC);
        Collections.sort(result);
        return result;
    }

    public List<String> getConstraintsValues() {
        ArrayList<String> result = new ArrayList<String>();
        for (String value : this.m_namesToIdsMap.keySet()) {
            result.add(value);
        }
        Collections.sort(result);
        return result;
    }

    public List<String> getPresetsValues() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(MediaExportParameters.Preset.DEFAULT.name());
        result.add(MediaExportParameters.Preset.NOCHANGE.name());
        result.add(MediaExportParameters.Preset.COMPRESSED.name());
        Collections.sort(result);
        return result;
    }

    @Override
    public int getRowCount() {
        switch (this.m_mediaType) {
            case Image: {
                return this.m_nonLinearBookFacade.getNlb().getImageFiles().size();
            }
            case Sound: {
                return this.m_nonLinearBookFacade.getNlb().getSoundFiles().size();
            }
        }
        return -1;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                switch (this.m_mediaType) {
                    case Image: {
                        return ((MediaFile)this.m_nonLinearBookFacade.getNlb().getImageFiles().get(rowIndex)).getFileName();
                    }
                    case Sound: {
                        return ((MediaFile)this.m_nonLinearBookFacade.getNlb().getSoundFiles().get(rowIndex)).getFileName();
                    }
                }
                return null;
            }
            case 1: {
                boolean flag;
                MediaFile mediaFile = this.getMediaFile(rowIndex);
                boolean bl = flag = mediaFile != null && mediaFile.isFlagged();
                if (flag) {
                    return "YES";
                }
                return "NO";
            }
            case 2: {
                String redirect;
                MediaFile mediaFile0 = this.getMediaFile(rowIndex);
                String string = redirect = mediaFile0 != null ? mediaFile0.getRedirect() : null;
                if (StringHelper.notEmpty((String)redirect)) {
                    return redirect;
                }
                return "";
            }
            case 3: {
                String constrId;
                MediaFile mediaFile1 = this.getMediaFile(rowIndex);
                String string = constrId = mediaFile1 != null ? mediaFile1.getConstrId() : null;
                if (StringHelper.notEmpty((String)constrId)) {
                    Variable constraint = this.m_nonLinearBookFacade.getNlb().getVariableById(constrId);
                    return constraint.getValue();
                }
                return "";
            }
            case 4: {
                MediaFile mediaFile2 = this.getMediaFile(rowIndex);
                if (mediaFile2 != null) {
                    return mediaFile2.getMediaExportParameters().getPreset().name();
                }
                return MediaExportParameters.Preset.DEFAULT.name();
            }
            case 5: {
                MediaFile mediaFile3 = this.getMediaFile(rowIndex);
                if (mediaFile3 != null && this.m_usages.contains(mediaFile3.getFileName())) {
                    return "";
                }
                return "UNUSED";
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String value = (String)aValue;
        switch (columnIndex) {
            case 1: {
                if ("YES".equalsIgnoreCase(value)) {
                    this.setMediaFileFlag(rowIndex, true);
                    break;
                }
                this.setMediaFileFlag(rowIndex, false);
                break;
            }
            case 2: {
                if (NC.equalsIgnoreCase(value)) {
                    this.setMediaFileRedirect(rowIndex, "");
                    break;
                }
                this.setMediaFileRedirect(rowIndex, value);
                break;
            }
            case 3: {
                this.setMediaFileConstrId(rowIndex, this.m_namesToIdsMap.get(value));
                break;
            }
            case 4: {
                this.setMediaFileExportParameters(rowIndex, value);
                break;
            }
            default: {
                super.setValueAt(aValue, rowIndex, columnIndex);
            }
        }
    }

    private void setMediaFileExportParameters(int rowIndex, String value) {
        MediaFile mediaFile = this.getMediaFile(rowIndex);
        if (mediaFile != null) {
            MediaExportParameters.Preset preset = MediaExportParameters.Preset.valueOf((String)value);
            this.m_nonLinearBookFacade.setMediaFileExportParametersPreset(this.m_mediaType, mediaFile.getFileName(), preset);
        }
    }

    private MediaFile getMediaFile(int rowIndex) {
        switch (this.m_mediaType) {
            case Image: {
                return (MediaFile)this.m_nonLinearBookFacade.getNlb().getImageFiles().get(rowIndex);
            }
            case Sound: {
                return (MediaFile)this.m_nonLinearBookFacade.getNlb().getSoundFiles().get(rowIndex);
            }
        }
        return null;
    }

    private void setMediaFileConstrId(int rowIndex, String constrId) {
        MediaFile mediaFile = this.getMediaFile(rowIndex);
        if (mediaFile != null) {
            this.m_nonLinearBookFacade.setMediaFileConstrId(this.m_mediaType, mediaFile.getFileName(), constrId);
        }
    }

    private void setMediaFileRedirect(int rowIndex, String redirect) {
        MediaFile mediaFile = this.getMediaFile(rowIndex);
        if (mediaFile != null) {
            this.m_nonLinearBookFacade.setMediaFileRedirect(this.m_mediaType, mediaFile.getFileName(), redirect);
        }
    }

    private void setMediaFileFlag(int rowIndex, boolean flag) {
        MediaFile mediaFile = this.getMediaFile(rowIndex);
        if (mediaFile != null) {
            this.m_nonLinearBookFacade.setMediaFileFlag(this.m_mediaType, mediaFile.getFileName(), flag);
        }
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Media file name";
            }
            case 1: {
                return this.m_mediaType == MediaFile.Type.Image ? "BG" : "SFX";
            }
            case 2: {
                return "Redirect";
            }
            case 3: {
                return "Constraint";
            }
            case 4: {
                return "Export Parameters";
            }
            case 5: {
                return "Usages";
            }
        }
        return super.getColumnName(column);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0 && columnIndex <= 4;
    }
}

