/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class ImageHelper {
    public static boolean textToGraphics(String text, File outputFile) {
        try {
            BufferedImage img = new BufferedImage(1, 1, 2);
            Graphics2D g2d = img.createGraphics();
            Font font = new Font("Arial", 0, 48);
            g2d.setFont(font);
            FontMetrics fm = g2d.getFontMetrics();
            int width = fm.stringWidth(text);
            int height = fm.getHeight();
            g2d.dispose();
            img = new BufferedImage(width, height, 2);
            g2d = img.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2d.setFont(font);
            fm = g2d.getFontMetrics();
            g2d.setColor(Color.BLACK);
            g2d.drawString(text, 0, fm.getAscent());
            g2d.dispose();
            ImageIO.write((RenderedImage)img, "png", outputFile);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static double getScaleToFit(JPanel componentToFit, File imageFile) throws IOException {
        double scaley;
        BufferedImage bimg = ImageIO.read(imageFile);
        int width = bimg.getWidth();
        int height = bimg.getHeight();
        double scalex = componentToFit.getVisibleRect().getWidth() / (double)width;
        return scalex < (scaley = componentToFit.getVisibleRect().getHeight() / (double)height) ? scalex : scaley;
    }
}

