/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.view;

import com.nlbhub.nlb.api.NodeItem;
import com.nlbhub.nlb.builder.view.GraphItemsMapper;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PNodeFilter;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class BulkSelectionHandler {
    private static final Set<String> EMPTY_SET = new HashSet<String>();
    private Set<String> m_selectedPagesIds = new HashSet<String>();
    private Set<String> m_selectedObjsIds = new HashSet<String>();

    public void clear() {
        this.m_selectedPagesIds.clear();
        this.m_selectedObjsIds.clear();
    }

    public Set<String> getSelectedPagesIds() {
        return this.getSelectedPagesIds(EMPTY_SET);
    }

    public Set<String> getSelectedPagesIds(Set<String> excludeIdsSet) {
        HashSet<String> selectedPagesIds = new HashSet<String>();
        for (String pageId : this.m_selectedPagesIds) {
            if (excludeIdsSet.contains(pageId)) continue;
            selectedPagesIds.add(pageId);
        }
        return selectedPagesIds;
    }

    public Set<String> getSelectedObjsIds() {
        return this.getSelectedObjsIds(EMPTY_SET);
    }

    public Set<String> getSelectedObjsIds(Set<String> excludeIdsSet) {
        HashSet<String> selectedObjsIds = new HashSet<String>();
        for (String objId : this.m_selectedObjsIds) {
            if (excludeIdsSet.contains(objId)) continue;
            selectedObjsIds.add(objId);
        }
        return selectedObjsIds;
    }

    public void makeSelection(final PPath selectionFrame, PLayer objLayer, PLayer nodeLayer) {
        NodeItem nodeItem;
        this.clear();
        PNodeFilter nodeFilter = new PNodeFilter(){

            public boolean accept(PNode pNode) {
                return pNode.getGlobalFullBounds().intersects((Rectangle2D)selectionFrame.getGlobalFullBounds());
            }

            public boolean acceptChildrenOf(PNode pNode) {
                return this.accept(pNode);
            }
        };
        Collection resultantObjNodes = new ArrayList();
        Collection resultantNodes = new ArrayList();
        resultantObjNodes = objLayer.getAllNodes(nodeFilter, resultantObjNodes);
        resultantNodes = nodeLayer.getAllNodes(nodeFilter, resultantNodes);
        for (PNode node : resultantObjNodes) {
            nodeItem = (NodeItem)node.getAttribute((Object)"nlbobj");
            if (nodeItem == null) continue;
            this.m_selectedObjsIds.add(nodeItem.getId());
            for (String containedObjId : nodeItem.getContainedObjIds()) {
                this.m_selectedObjsIds.add(containedObjId);
            }
        }
        for (PNode node : resultantNodes) {
            nodeItem = (NodeItem)node.getAttribute((Object)"nlbpage");
            if (nodeItem == null) continue;
            this.m_selectedPagesIds.add(nodeItem.getId());
            for (String containedObjId : nodeItem.getContainedObjIds()) {
                this.m_selectedObjsIds.add(containedObjId);
            }
        }
    }

    public boolean isSelected(PNode node) {
        NodeItem nodeItem = (NodeItem)node.getAttribute((Object)"nlbpage");
        if (nodeItem != null) {
            return this.m_selectedPagesIds.contains(nodeItem.getId());
        }
        nodeItem = (NodeItem)node.getAttribute((Object)"nlbobj");
        if (nodeItem != null) {
            return this.m_selectedObjsIds.contains(nodeItem.getId());
        }
        return false;
    }

    public boolean hasSelection() {
        return !this.m_selectedPagesIds.isEmpty() || !this.m_selectedObjsIds.isEmpty();
    }

    public void recolor(GraphItemsMapper graphItemsMapper, Color color) {
        for (String selectedPageId : this.getSelectedPagesIds(EMPTY_SET)) {
            graphItemsMapper.getPageById(selectedPageId).setPaint(color);
        }
        for (String selectedObjId : this.getSelectedObjsIds(EMPTY_SET)) {
            graphItemsMapper.getObjById(selectedObjId).setPaint(color);
        }
    }
}

