/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.view;

import com.nlbhub.nlb.api.Coords;
import com.nlbhub.nlb.api.Link;
import com.nlbhub.nlb.api.NodeItem;
import com.nlbhub.nlb.api.Obj;
import com.nlbhub.nlb.api.Page;
import com.nlbhub.nlb.api.ProgressData;
import com.nlbhub.nlb.builder.form.DialogLinkProperties;
import com.nlbhub.nlb.builder.form.DialogObjProperties;
import com.nlbhub.nlb.builder.form.DialogPageProperties;
import com.nlbhub.nlb.builder.form.MainFrame;
import com.nlbhub.nlb.builder.model.LinkSelectionData;
import com.nlbhub.nlb.builder.view.BulkSelectionHandler;
import com.nlbhub.nlb.builder.view.GraphItemsMapper;
import com.nlbhub.nlb.builder.view.ItemPath;
import com.nlbhub.nlb.builder.view.LinkPath;
import com.nlbhub.nlb.builder.view.NodePath;
import com.nlbhub.nlb.builder.view.NodeResizeExecutor;
import com.nlbhub.nlb.builder.view.ObjPath;
import com.nlbhub.nlb.builder.view.PagePath;
import com.nlbhub.nlb.domain.NonLinearBookFacade;
import com.nlbhub.nlb.exception.NLBConsistencyException;
import com.nlbhub.nlb.exception.NLBFileManipulationException;
import com.nlbhub.nlb.exception.NLBIOException;
import com.nlbhub.nlb.exception.NLBVCSException;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PNodeFilter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;

public class GraphEditor
extends PCanvas {
    private static final long ANIMATE_DURATION_MILLIS = 1000L;
    private static final Font FONT = new Font("Monospaced", 1, 12);
    private static final float DRAG_END_OFFSET_X = 10.0f;
    private static final float DRAG_END_OFFSET_Y = 10.0f;
    private static final Color NORMAL_NODE_COLOR = Color.WHITE;
    private static final Color SELECTED_NODE_COLOR = Color.GRAY;
    private EnumSet<GraphEditorMode> m_graphEditorMode = EnumSet.noneOf(GraphEditorMode.class);
    private PLayer m_dragLayer = this.getLayer();
    private PLayer m_edgeLayer = null;
    private PLayer m_nodeLayer = null;
    private PLayer m_objLayer = null;
    private GraphDragEventHandler m_dragEventHandler = null;
    private GraphDragEventHandler m_dragEventHandlerObjs = null;
    private GraphDragEventHandlerLinks m_dragEventHandlerLinks = null;
    private final NonLinearBookFacade m_nlbFacade;
    private GraphItemsMapper m_graphItemsMapper = new GraphItemsMapper();
    private NodeResizeExecutor m_nodeResizeExecutor;
    private Point2D m_selectionStart = null;
    private PPath m_selectionFrame = new PPath();
    private BulkSelectionHandler m_bulkSelectionHandler = new BulkSelectionHandler();
    private final MainFrame m_mainFrame;

    public GraphEditor(MainFrame mainFrame, NonLinearBookFacade nlbFacade) {
        this(mainFrame, nlbFacade, 500, 500);
        this.init();
    }

    protected GraphEditor(MainFrame mainFrame, NonLinearBookFacade nlbFacade, int width, int height) {
        this.m_mainFrame = mainFrame;
        this.m_nlbFacade = nlbFacade;
        this.m_nodeResizeExecutor = new NodeResizeExecutor(this.m_nlbFacade);
        this.setPreferredSize(new Dimension(width, height));
        this.m_edgeLayer = new PLayer();
        this.getRoot().addChild((PNode)this.m_edgeLayer);
        this.getCamera().addLayer(0, this.m_edgeLayer);
        this.m_objLayer = new PLayer();
        this.getRoot().addChild((PNode)this.m_objLayer);
        this.getCamera().addLayer(0, this.m_objLayer);
        this.m_nodeLayer = new PLayer();
        this.getRoot().addChild((PNode)this.m_nodeLayer);
        this.getCamera().addLayer(0, this.m_nodeLayer);
        int quality = 1;
        this.setDefaultRenderQuality(quality);
        this.setInteractingRenderQuality(quality);
        this.setAnimatingRenderQuality(quality);
        this.m_dragEventHandler = new GraphDragEventHandler(Color.RED, "nlbpage");
        this.m_dragEventHandlerObjs = new GraphDragEventHandler(Color.CYAN, "nlbobj");
        this.m_dragEventHandlerLinks = new GraphDragEventHandlerLinks();
        this.m_nodeLayer.addInputEventListener((PInputEventListener)this.m_dragEventHandler);
        this.m_objLayer.addInputEventListener((PInputEventListener)this.m_dragEventHandlerObjs);
        this.m_edgeLayer.addInputEventListener((PInputEventListener)this.m_dragEventHandlerLinks);
        this.m_selectionFrame.setStrokePaint((Paint)Color.BLACK);
        this.m_dragLayer.addChild((PNode)this.m_selectionFrame);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (GraphEditor.this.isAddPageMode()) {
                    GraphEditor.this.addNode(e.getPoint());
                } else if (GraphEditor.this.isAddObjMode()) {
                    GraphEditor.this.addObjNode(e.getPoint());
                } else if (GraphEditor.this.isSelectionMode()) {
                    if (GraphEditor.this.m_selectionStart == null) {
                        GraphEditor.this.m_selectionStart = new Point2D.Double();
                        Point2D ptDst = null;
                        ptDst = GraphEditor.this.getCamera().getViewTransform().inverseTransform((Point2D)e.getPoint(), ptDst);
                        GraphEditor.this.m_selectionStart.setLocation(ptDst);
                    } else {
                        GraphEditor.this.m_selectionStart = null;
                        GraphEditor.this.m_selectionFrame.reset();
                    }
                }
                super.mouseClicked(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                GraphEditor.this.m_bulkSelectionHandler.recolor(GraphEditor.this.m_graphItemsMapper, NORMAL_NODE_COLOR);
                if (GraphEditor.this.isSelectionMode()) {
                    GraphEditor.this.m_bulkSelectionHandler.makeSelection(GraphEditor.this.m_selectionFrame, GraphEditor.this.m_objLayer, GraphEditor.this.m_nodeLayer);
                }
                GraphEditor.this.m_bulkSelectionHandler.recolor(GraphEditor.this.m_graphItemsMapper, SELECTED_NODE_COLOR);
                super.mouseReleased(e);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    GraphEditor.this.m_dragEventHandler.resetLinkAddition();
                }
                super.keyPressed(e);
            }
        });
    }

    private Rectangle getBoundsUnion() {
        Rectangle nodeBounds = this.m_nodeLayer.getGlobalFullBounds().getBounds();
        HashSet<Rectangle> bounds = new HashSet<Rectangle>();
        bounds.add(this.m_objLayer.getGlobalFullBounds().getBounds());
        bounds.add(this.m_edgeLayer.getGlobalFullBounds().getBounds());
        double minX = nodeBounds.getX();
        double maxX = nodeBounds.getMaxX();
        double minY = nodeBounds.getY();
        double maxY = nodeBounds.getMaxY();
        for (Rectangle bound : bounds) {
            double maxY1;
            double maxX1;
            if (bound.getX() < minX) {
                minX = bound.getX();
            }
            if ((maxX1 = bound.getMaxX()) > maxX) {
                maxX = maxX1;
            }
            if (bound.getY() < minY) {
                minY = bound.getY();
            }
            if (!((maxY1 = bound.getMaxY()) > maxY)) continue;
            maxY = maxY1;
        }
        Rectangle rectangle = new Rectangle();
        rectangle.setFrame(minX, minY, maxX - minX, maxY - minY);
        return rectangle;
    }

    public void saveAsImage(File imageFile, ProgressData progressData) throws IOException {
        Rectangle rectangle = this.getBoundsUnion();
        double dx = rectangle.getX();
        double dy = rectangle.getY();
        double width = rectangle.width;
        double height = rectangle.height;
        BufferedImage image = new BufferedImage((int)width, (int)height, 1);
        this.getCamera().translateView(-dx, -dy);
        Rectangle prevViewRect = this.getBounds();
        Rectangle viewRect = new Rectangle();
        viewRect.setFrame(0.0, 0.0, width, height);
        this.setBounds(viewRect);
        Graphics graphics = image.getGraphics();
        this.paintAll(graphics);
        this.setBounds(prevViewRect);
        this.getCamera().translateView(dx, dy);
        progressData.setProgressValue(50);
        progressData.setNoteText("Saving file...");
        ImageIO.write((RenderedImage)image, "png", imageFile);
    }

    public void deselectAll() {
        this.m_dragEventHandler.deselect();
        this.m_dragEventHandlerObjs.deselect();
        this.m_dragEventHandlerLinks.deselect();
    }

    public void addNode(Point2D point) {
        Point2D ptDst = null;
        ptDst = this.getCamera().getViewTransform().inverseTransform(point, ptDst);
        Page page = this.createPage((float)ptDst.getX(), (float)ptDst.getY());
        this.m_nodeLayer.addChild((PNode)this.m_graphItemsMapper.addNode(this.m_nlbFacade.getNlb(), this.m_nodeResizeExecutor, page, FONT));
        this.m_nlbFacade.addPage(page);
    }

    public void addObjNode(Point2D point) {
        Point2D ptDst = null;
        ptDst = this.getCamera().getViewTransform().inverseTransform(point, ptDst);
        Obj obj = this.createObj((float)ptDst.getX(), (float)ptDst.getY());
        this.m_objLayer.addChild((PNode)this.m_graphItemsMapper.addObjNode(this.m_nlbFacade.getNlb(), this.m_nodeResizeExecutor, obj, FONT));
        this.m_nlbFacade.addObj(obj);
    }

    public void addLink(NodePath nodeFrom, NodePath nodeTo) {
        Link link = this.createLink(nodeFrom, nodeTo);
        this.m_edgeLayer.addChild((PNode)this.m_graphItemsMapper.addLink(this.m_nlbFacade.getNlb(), FONT, this.getFontMetrics(FONT), nodeFrom, nodeTo, link));
        this.m_nlbFacade.addLink(link);
    }

    public void mouseMove(Point2D position) {
        this.m_selectionFrame.reset();
        if (this.isSelectionMode() && this.m_selectionStart != null) {
            Point2D ptDst = null;
            ptDst = this.getCamera().getViewTransform().inverseTransform(position, ptDst);
            this.m_selectionFrame.moveTo((float)this.m_selectionStart.getX(), (float)this.m_selectionStart.getY());
            this.m_selectionFrame.lineTo((float)ptDst.getX(), (float)this.m_selectionStart.getY());
            this.m_selectionFrame.lineTo((float)ptDst.getX(), (float)ptDst.getY());
            this.m_selectionFrame.lineTo((float)this.m_selectionStart.getX(), (float)ptDst.getY());
            this.m_selectionFrame.lineTo((float)this.m_selectionStart.getX(), (float)this.m_selectionStart.getY());
        } else {
            this.m_dragEventHandler.mouseMove(position);
            this.m_dragEventHandlerObjs.mouseMove(position);
        }
    }

    public boolean isAddLinkMode() {
        return this.m_graphEditorMode.contains((Object)GraphEditorMode.ADD_LINK_MODE);
    }

    public void setAddLinkMode(boolean addLinkMode) {
        if (addLinkMode) {
            this.m_graphEditorMode.add(GraphEditorMode.ADD_LINK_MODE);
        } else {
            this.m_graphEditorMode.remove((Object)GraphEditorMode.ADD_LINK_MODE);
        }
    }

    public boolean isAddPageMode() {
        return this.m_graphEditorMode.contains((Object)GraphEditorMode.ADD_PAGE_MODE);
    }

    public void setAddPageMode(boolean addPageMode) {
        if (addPageMode) {
            this.m_graphEditorMode.add(GraphEditorMode.ADD_PAGE_MODE);
        } else {
            this.m_graphEditorMode.remove((Object)GraphEditorMode.ADD_PAGE_MODE);
        }
    }

    public boolean isAddObjMode() {
        return this.m_graphEditorMode.contains((Object)GraphEditorMode.ADD_OBJ_MODE);
    }

    public void setAddObjMode(boolean addObjMode) {
        if (addObjMode) {
            this.m_graphEditorMode.add(GraphEditorMode.ADD_OBJ_MODE);
        } else {
            this.m_graphEditorMode.remove((Object)GraphEditorMode.ADD_OBJ_MODE);
        }
    }

    public boolean isSelectionMode() {
        return this.m_graphEditorMode.contains((Object)GraphEditorMode.SELECTION_MODE);
    }

    public void setSelectionMode(boolean selectionMode) {
        if (selectionMode) {
            this.m_graphEditorMode.add(GraphEditorMode.SELECTION_MODE);
        } else {
            this.m_selectionStart = null;
            this.m_graphEditorMode.remove((Object)GraphEditorMode.SELECTION_MODE);
        }
    }

    public Page getSelectedPage() {
        PNode selectedNode = this.m_dragEventHandler.getSelectedNode();
        return selectedNode == null ? null : (Page)selectedNode.getAttribute((Object)"nlbpage");
    }

    public Obj getSelectedObj() {
        PNode selectedNode = this.m_dragEventHandlerObjs.getSelectedNode();
        return selectedNode == null ? null : (Obj)selectedNode.getAttribute((Object)"nlbobj");
    }

    public void updatePage(Page pageToUpdate) {
        this.m_nlbFacade.updateNode((NodeItem)pageToUpdate);
    }

    public void updateObj(Obj objToUpdate) {
        this.m_nlbFacade.updateNode((NodeItem)objToUpdate);
    }

    public void updateLink(Link link) {
        this.m_nlbFacade.updateLink(link);
    }

    public LinkSelectionData getSelectedLink() {
        return this.m_dragEventHandlerLinks.getSelectedLink();
    }

    private Page createPage(float left, float top) {
        return this.m_nlbFacade.createPage(left, top);
    }

    private Obj createObj(float left, float top) {
        return this.m_nlbFacade.createObj(left, top);
    }

    private Link createLink(NodePath nodeFrom, NodePath nodeTo) {
        NodeItem item = (NodeItem)nodeFrom.getAttribute("nlbpage");
        NodeItem target = (NodeItem)nodeTo.getAttribute("nlbpage");
        if (item == null) {
            item = (NodeItem)nodeFrom.getAttribute("nlbobj");
            target = (NodeItem)nodeTo.getAttribute("nlbobj");
        }
        return this.m_nlbFacade.createLink(item, target);
    }

    public void save(ProgressData progressData) throws NLBIOException, NLBConsistencyException, NLBVCSException, NLBFileManipulationException {
        this.m_nlbFacade.save(false, progressData);
    }

    public void saveAs(File nlbFolder, ProgressData progressData) throws NLBIOException, NLBConsistencyException, NLBVCSException, NLBFileManipulationException {
        this.m_nlbFacade.saveAs(nlbFolder, progressData);
    }

    public void load(File nlbFolder, ProgressData progressData) throws NLBIOException, NLBConsistencyException, NLBVCSException {
        try {
            this.m_nlbFacade.load(nlbFolder.getCanonicalPath(), progressData);
            progressData.setProgressValue(75);
            progressData.setNoteText("Drawing objects...");
            this.init();
        }
        catch (IOException e) {
            throw new NLBIOException("IOException while loading book", (Throwable)e);
        }
    }

    public void init() {
        this.clear();
        this.m_graphItemsMapper.init(this.m_nlbFacade, this.m_nodeResizeExecutor, FONT, this.getFontMetrics(FONT));
        for (Map.Entry<String, PagePath> entry : this.m_graphItemsMapper.pageEntrySet()) {
            this.m_nodeLayer.addChild((PNode)entry.getValue());
        }
        for (Map.Entry<String, NodePath> entry : this.m_graphItemsMapper.objEntrySet()) {
            this.m_objLayer.addChild((PNode)entry.getValue());
        }
        for (Map.Entry<String, ItemPath> entry : this.m_graphItemsMapper.linkEntrySet()) {
            this.m_edgeLayer.addChild((PNode)entry.getValue());
        }
        this.m_nlbFacade.updateAllViews();
        this.m_nodeLayer.repaint();
        this.m_objLayer.repaint();
        this.m_edgeLayer.repaint();
    }

    public void clear() {
        this.m_edgeLayer.removeAllChildren();
        this.m_nodeLayer.removeAllChildren();
        this.m_objLayer.removeAllChildren();
        this.m_dragEventHandler.clear();
        this.m_dragEventHandlerObjs.clear();
    }

    public void deleteSelectedPage() {
        PNode node = this.m_dragEventHandler.getSelectedNode();
        Page page = (Page)node.getAttribute((Object)"nlbpage");
        this.m_nlbFacade.deleteNode((NodeItem)page);
    }

    public void deleteSelectedObj() {
        PNode node = this.m_dragEventHandlerObjs.getSelectedNode();
        Obj obj = (Obj)node.getAttribute((Object)"nlbobj");
        this.m_nlbFacade.deleteNode((NodeItem)obj);
    }

    public void deleteSelectedLink() {
        PNode node = this.m_dragEventHandlerLinks.getSelectedLinkNode();
        if (node != null) {
            Link link = (Link)node.getAttribute((Object)"nlblink");
            this.m_nlbFacade.deleteLink(link);
        }
    }

    public void editSelectedItemProperties(MainFrame mainFrame) {
        Page selectedPage = this.getSelectedPage();
        Obj selectedObj = this.getSelectedObj();
        if (selectedPage != null) {
            DialogPageProperties dialog = new DialogPageProperties(mainFrame, this.m_nlbFacade, selectedPage);
            dialog.showDialog();
            this.updatePage(selectedPage);
        } else if (selectedObj != null) {
            DialogObjProperties dialog = new DialogObjProperties(mainFrame, this.m_nlbFacade, selectedObj);
            dialog.showDialog();
            this.updateObj(selectedObj);
        } else {
            LinkSelectionData selectedLink = this.getSelectedLink();
            if (selectedLink != null && selectedLink.getLink() != null) {
                DialogLinkProperties dialog = new DialogLinkProperties(this.m_nlbFacade, selectedLink.getLink());
                dialog.showDialog();
                this.updateLink(selectedLink.getLink());
            }
        }
    }

    public void addStartPoint() {
        Page page = this.getSelectedPage();
        if (page != null) {
            this.m_nlbFacade.changeStartPoint(page.getId());
        }
    }

    public void zoomIn() {
        this.zoom(2.0);
    }

    public void zoomOut() {
        this.zoom(0.5);
    }

    private void zoom(double scale) {
        PCamera camera = this.getCamera();
        PBounds viewBounds = camera.getViewBounds();
        Point2D center = viewBounds.getCenter2D();
        PBounds globalFullBounds = camera.getGlobalFullBounds();
        if (viewBounds.contains((Rectangle2D)globalFullBounds)) {
            center = globalFullBounds.getCenter2D();
        }
        camera.scaleViewAboutPoint(scale, center.getX(), center.getY());
    }

    public void goTo(String itemId) {
        Rectangle2D rect = this.m_graphItemsMapper.getItemRectById(itemId);
        if (rect != null) {
            this.getCamera().animateViewToCenterBounds(rect, false, 1000L);
        }
    }

    public BulkSelectionHandler getBulkSelectionHandler() {
        return this.m_bulkSelectionHandler;
    }

    private class GraphDragEventHandler<T extends NodePath>
    extends PDragEventHandler {
        private T m_prevNode = null;
        private T m_selectedNode = null;
        private PPath m_dragEdge = new PPath();
        private Color m_mouseOverColor;
        private String m_attributeName;
        private Set<NodeItem> m_additionallyMovedNodes = new HashSet<NodeItem>();

        private GraphDragEventHandler(Color mouseOverColor, String attributeName) {
            this.m_dragEdge.setStrokePaint(LinkPath.NORMAL_STROKE_PAINT);
            GraphEditor.this.m_dragLayer.addChild((PNode)this.m_dragEdge);
            PInputEventFilter filter = new PInputEventFilter();
            filter.setOrMask(20);
            this.setEventFilter(filter);
            this.m_mouseOverColor = mouseOverColor;
            this.m_attributeName = attributeName;
        }

        public void mouseEntered(PInputEvent e) {
            super.mouseEntered(e);
            if (e.getButton() == 0) {
                e.getPickedNode().setPaint((Paint)this.m_mouseOverColor);
            }
        }

        public void mouseExited(PInputEvent e) {
            super.mouseExited(e);
            if (e.getButton() == 0) {
                PNode pickedNode = e.getPickedNode();
                if (GraphEditor.this.m_bulkSelectionHandler.isSelected(pickedNode)) {
                    pickedNode.setPaint((Paint)SELECTED_NODE_COLOR);
                } else {
                    pickedNode.setPaint((Paint)NORMAL_NODE_COLOR);
                }
            }
            if (this.m_selectedNode != null) {
                this.m_selectedNode.setPaint((Paint)SELECTED_NODE_COLOR);
            }
        }

        protected void startDrag(PInputEvent e) {
            this.m_additionallyMovedNodes = new HashSet<NodeItem>();
            if (!GraphEditor.this.isAddLinkMode()) {
                super.startDrag(e);
                e.setHandled(true);
                this.moveToFront(e.getPickedNode());
            }
        }

        private void moveToFront(PNode node) {
            node.moveToFront();
            List<PNode> containedObjsNodes = GraphEditor.this.m_graphItemsMapper.getContainedObjsNodes(node);
            for (PNode containedNode : containedObjsNodes) {
                containedNode.moveInFrontOf(node);
            }
        }

        protected void drag(PInputEvent e) {
            if (!GraphEditor.this.isAddLinkMode()) {
                super.drag(e);
                PNode pickedNode = e.getPickedNode();
                PDimension delta = e.getDeltaRelativeTo(pickedNode);
                Set<String> alreadyMovedObjsIds = this.offsetContainedObjects(pickedNode, (float)delta.getWidth(), (float)delta.getHeight());
                NodeItem nodeItem = (NodeItem)pickedNode.getAttribute((Object)"nlbpage");
                if (nodeItem == null) {
                    nodeItem = (NodeItem)pickedNode.getAttribute((Object)"nlbobj");
                }
                GraphEditor.this.m_nlbFacade.invalidateAssociatedLinks(nodeItem);
                this.m_additionallyMovedNodes = this.offsetSelectedObjects(nodeItem, alreadyMovedObjsIds, (float)delta.getWidth(), (float)delta.getHeight());
                e.setHandled(true);
            }
        }

        private Set<String> offsetContainedObjects(PNode container, float deltaX, float deltaY) {
            HashSet<String> movedObjsIds = new HashSet<String>();
            List<PNode> containedObjsNodes = GraphEditor.this.m_graphItemsMapper.getContainedObjsNodes(container);
            for (PNode node : containedObjsNodes) {
                node.moveInFrontOf(container);
                node.offset((double)deltaX, (double)deltaY);
                NodeItem nodeItem = (NodeItem)node.getAttribute((Object)"nlbpage");
                if (nodeItem == null) {
                    nodeItem = (NodeItem)node.getAttribute((Object)"nlbobj");
                }
                movedObjsIds.add(nodeItem.getId());
                GraphEditor.this.m_nlbFacade.invalidateAssociatedLinks(nodeItem);
                movedObjsIds.addAll(this.offsetContainedObjects(node, deltaX, deltaY));
            }
            return movedObjsIds;
        }

        private Set<NodeItem> offsetSelectedObjects(NodeItem originator, Set<String> alreadyMovedObjsIds, float deltaX, float deltaY) {
            HashSet<String> allAlreadyMovedObjsIds = new HashSet<String>();
            HashSet<String> additionalAlreadyMovedObjsIds = new HashSet<String>();
            allAlreadyMovedObjsIds.addAll(alreadyMovedObjsIds);
            HashSet<NodeItem> changedNodes = new HashSet<NodeItem>();
            Set<String> selectedPagesIds = GraphEditor.this.m_bulkSelectionHandler.getSelectedPagesIds();
            for (String pageId : selectedPagesIds) {
                if (pageId.equals(originator.getId())) continue;
                PagePath pagePath = GraphEditor.this.m_graphItemsMapper.getPageById(pageId);
                pagePath.offset(deltaX, deltaY);
                allAlreadyMovedObjsIds.addAll(this.offsetContainedObjects((PNode)pagePath, deltaX, deltaY));
                NodeItem nodeItem = (NodeItem)pagePath.getAttribute("nlbpage");
                changedNodes.add(nodeItem);
                GraphEditor.this.m_nlbFacade.invalidateAssociatedLinks(nodeItem);
            }
            Set<String> selectedObjsIds = GraphEditor.this.m_bulkSelectionHandler.getSelectedObjsIds(allAlreadyMovedObjsIds);
            for (String objId : selectedObjsIds) {
                if (objId.equals(originator.getId()) || additionalAlreadyMovedObjsIds.contains(objId)) continue;
                ObjPath objPath = GraphEditor.this.m_graphItemsMapper.getObjById(objId);
                objPath.offset(deltaX, deltaY);
                additionalAlreadyMovedObjsIds.addAll(this.offsetContainedObjects((PNode)objPath, deltaX, deltaY));
                NodeItem nodeItem = (NodeItem)objPath.getAttribute("nlbobj");
                changedNodes.add(nodeItem);
                GraphEditor.this.m_nlbFacade.invalidateAssociatedLinks(nodeItem);
            }
            return changedNodes;
        }

        protected void endDrag(PInputEvent e) {
            if (!GraphEditor.this.isAddLinkMode()) {
                super.endDrag(e);
                PNode pickedNode = e.getPickedNode();
                Point2D ptDst = pickedNode.getGlobalFullBounds().getCenter2D();
                NodeItem nodeItem = (NodeItem)pickedNode.getAttribute((Object)"nlbpage");
                if (nodeItem == null) {
                    nodeItem = (NodeItem)pickedNode.getAttribute((Object)"nlbobj");
                }
                Coords coords = nodeItem.getCoords();
                ptDst.setLocation(ptDst.getX() - (double)coords.getWidth() / 2.0, ptDst.getY() - (double)coords.getHeight() / 2.0);
                float deltaX = (float)ptDst.getX() - coords.getLeft();
                float deltaY = (float)ptDst.getY() - coords.getTop();
                if (Math.abs(deltaX) > 1.0E-6f || Math.abs(deltaY) > 1.0E-6f) {
                    GraphEditor.this.m_nlbFacade.updateNodeCoords(nodeItem, this.m_additionallyMovedNodes, deltaX, deltaY);
                    final Obj obj = (Obj)pickedNode.getAttribute((Object)"nlbobj");
                    if (obj != null) {
                        final PBounds pickedNodeBounds = pickedNode.getGlobalFullBounds();
                        PNodeFilter nodeFilter = new PNodeFilter(){

                            public boolean accept(PNode pNode) {
                                PNode containerNode = GraphEditor.this.m_graphItemsMapper.getContainer(pNode);
                                if (containerNode != null) {
                                    NodeItem nodeItem = (NodeItem)containerNode.getAttribute((Object)"nlbpage");
                                    if (nodeItem == null) {
                                        nodeItem = (NodeItem)containerNode.getAttribute((Object)"nlbobj");
                                    }
                                    if (nodeItem.getId().equals(obj.getId())) {
                                        return false;
                                    }
                                }
                                return pNode.getGlobalFullBounds().intersects((Rectangle2D)pickedNodeBounds);
                            }

                            public boolean acceptChildrenOf(PNode pNode) {
                                return this.accept(pNode);
                            }
                        };
                        Collection resultantObjNodes = new ArrayList();
                        ArrayList<PNode> resultantNodes = new ArrayList();
                        resultantObjNodes = GraphEditor.this.m_objLayer.getAllNodes(nodeFilter, resultantObjNodes);
                        boolean processed = this.changeContainer(obj, resultantObjNodes);
                        if (!processed && !(processed = this.changeContainer(obj, resultantNodes = GraphEditor.this.m_nodeLayer.getAllNodes(nodeFilter, resultantNodes))) && obj.getContainerId() != null) {
                            GraphEditor.this.m_nlbFacade.changeContainer(obj.getContainerId(), null, obj.getId());
                        }
                    }
                }
            }
        }

        private boolean changeContainer(Obj obj, Collection<PNode> possibleContainers) {
            boolean processed = false;
            for (PNode node : possibleContainers) {
                boolean sameContainer;
                NodeItem nodeItem = (NodeItem)node.getAttribute((Object)"nlbpage");
                if (nodeItem == null) {
                    nodeItem = (NodeItem)node.getAttribute((Object)"nlbobj");
                }
                boolean bl = sameContainer = nodeItem != null && nodeItem.getId().equals(obj.getContainerId());
                if (sameContainer) {
                    return true;
                }
                if (nodeItem == null || nodeItem.isDeleted() || nodeItem.getId().equals(obj.getId())) continue;
                GraphEditor.this.m_nlbFacade.changeContainer(obj.getContainerId(), nodeItem.getId(), obj.getId());
                processed = true;
                break;
            }
            return processed;
        }

        public void mouseClicked(PInputEvent event) {
            super.mouseClicked(event);
            GraphEditor.this.m_bulkSelectionHandler.recolor(GraphEditor.this.m_graphItemsMapper, NORMAL_NODE_COLOR);
            GraphEditor.this.m_bulkSelectionHandler.clear();
            PNode node = event.getPickedNode();
            if (GraphEditor.this.isAddLinkMode()) {
                Object nodeData = node.getAttribute((Object)this.m_attributeName);
                if (nodeData == null) {
                    this.resetLinkAddition();
                } else if (this.m_prevNode != null) {
                    GraphEditor.this.addLink((NodePath)((Object)this.m_prevNode), (NodePath)node);
                    this.resetLinkAddition();
                } else {
                    this.m_prevNode = (NodePath)node;
                }
            } else {
                this.m_prevNode = null;
            }
            GraphEditor.this.deselectAll();
            this.m_selectedNode = (NodePath)node;
            this.m_selectedNode.setPaint((Paint)SELECTED_NODE_COLOR);
            if (event.getClickCount() > 1) {
                GraphEditor.this.editSelectedItemProperties(GraphEditor.this.m_mainFrame);
            }
        }

        public void resetLinkAddition() {
            this.m_prevNode = null;
            this.m_dragEdge.reset();
        }

        public void deselect() {
            if (this.m_selectedNode != null) {
                this.m_selectedNode.setPaint((Paint)NORMAL_NODE_COLOR);
                this.m_selectedNode = null;
            }
        }

        public void mouseMove(Point2D position) {
            if (this.m_prevNode != null) {
                Point2D start = this.m_prevNode.getFullBoundsReference().getCenter2D();
                this.m_dragEdge.reset();
                this.m_dragEdge.moveTo((float)start.getX(), (float)start.getY());
                Point2D ptDst = null;
                ptDst = GraphEditor.this.getCamera().getViewTransform().inverseTransform(position, ptDst);
                float offsetX = start.getX() < ptDst.getX() ? 10.0f : -10.0f;
                this.m_dragEdge.lineTo((float)ptDst.getX() - offsetX, (float)ptDst.getY());
                this.m_dragEdge.lineTo((float)ptDst.getX() - offsetX, (float)ptDst.getY() + 10.0f);
                this.m_dragEdge.lineTo((float)ptDst.getX() + offsetX, (float)ptDst.getY() + 10.0f);
                this.m_dragEdge.lineTo((float)ptDst.getX() + offsetX, (float)ptDst.getY() - 10.0f);
                this.m_dragEdge.lineTo((float)ptDst.getX() - offsetX, (float)ptDst.getY() - 10.0f);
                this.m_dragEdge.lineTo((float)ptDst.getX() - offsetX, (float)ptDst.getY());
            } else {
                this.m_dragEdge.reset();
            }
        }

        private PNode getSelectedNode() {
            return this.m_selectedNode;
        }

        public void clear() {
            this.m_prevNode = null;
            this.m_dragEdge.reset();
        }
    }

    private class GraphDragEventHandlerLinks
    extends PDragEventHandler {
        private PNode m_selectedNode = null;
        private Point2D m_pickedNodeOrigin = null;
        private boolean m_canDrag = false;

        private GraphDragEventHandlerLinks() {
        }

        public void mousePressed(PInputEvent event) {
            super.mousePressed(event);
            GraphEditor.this.deselectAll();
            this.reselectNode(event.getPickedNode());
            if (event.getClickCount() > 1) {
                GraphEditor.this.editSelectedItemProperties(GraphEditor.this.m_mainFrame);
            } else {
                this.m_canDrag = true;
            }
        }

        public void mouseReleased(PInputEvent event) {
            super.mouseReleased(event);
            this.m_canDrag = false;
        }

        private PNode reselectNode(PNode node) {
            List<PNode> relatedNodes;
            if (this.m_selectedNode != null) {
                relatedNodes = this.getRelatedNodesReference(this.m_selectedNode);
                this.m_selectedNode.setPaint(LinkPath.NORMAL_PAINT);
                this.m_selectedNode.repaint();
                for (PNode relNode : relatedNodes) {
                    relNode.setPaint(LinkPath.NORMAL_PAINT);
                    relNode.repaint();
                }
            }
            if (node != null) {
                relatedNodes = this.getRelatedNodesReference(node);
                this.m_pickedNodeOrigin = node.getFullBoundsReference().getOrigin();
                node.setPaint(LinkPath.SELECTED_PAINT);
                node.repaint();
                for (PNode relNode : relatedNodes) {
                    relNode.setPaint(LinkPath.SELECTED_PAINT);
                    relNode.repaint();
                }
            }
            this.m_selectedNode = node;
            return this.m_selectedNode;
        }

        public void deselect() {
            this.reselectNode(null);
        }

        private PNode getLinkNode(PNode node) {
            Link link = this.getLink(node);
            if (link == null) {
                return node.getParent();
            }
            return node;
        }

        private List<PNode> getRelatedNodesReference(PNode node) {
            ArrayList<PNode> result = new ArrayList<PNode>();
            if (this.isLinkNode(node)) {
                ListIterator iterator = node.getChildrenIterator();
                while (iterator.hasNext()) {
                    PNode curNode = (PNode)iterator.next();
                    result.add(curNode);
                }
            } else {
                result.add(node.getParent());
            }
            return result;
        }

        private boolean isLinkNode(PNode node) {
            return this.getLink(node) != null;
        }

        public LinkSelectionData getSelectedLink() {
            PNode linkNode = this.getLinkNode(this.m_selectedNode);
            Link link = this.getLink(linkNode);
            return new LinkSelectionData(link);
        }

        public PNode getSelectedLinkNode() {
            return this.getLinkNode(this.m_selectedNode);
        }

        private Link getLink(PNode node) {
            return (Link)node.getAttribute((Object)"nlblink");
        }

        protected void startDrag(PInputEvent e) {
            super.startDrag(e);
            e.setHandled(true);
        }

        protected void endDrag(PInputEvent event) {
            super.endDrag(event);
            if (this.m_canDrag && !this.isLinkNode(this.m_selectedNode)) {
                PNode pickedNode = this.m_selectedNode;
                Link link = this.getLink(pickedNode);
                if (link == null) {
                    link = this.getLink(pickedNode.getParent());
                }
                Coords coords = link.getCoords();
                Point2D shiftedOrigin = this.m_selectedNode.getFullBoundsReference().getOrigin();
                PAffineTransform transform = this.m_selectedNode.getInverseTransform();
                Point2D ptShO = null;
                ptShO = transform.transform(shiftedOrigin, ptShO);
                Point2D ptO = null;
                ptO = transform.transform(this.m_pickedNodeOrigin, ptO);
                if (this.m_pickedNodeOrigin != null) {
                    float oldLeft = coords.getLeft();
                    float oldTop = coords.getTop();
                    GraphEditor.this.m_nlbFacade.updateLinkCoords(link, oldLeft + (float)(ptShO.getX() - ptO.getX()), oldTop + (float)(ptShO.getY() - ptO.getY()));
                }
            }
        }

        protected void drag(PInputEvent event) {
            if (!this.isLinkNode(this.m_selectedNode)) {
                super.drag(event);
            }
        }
    }

    private static enum GraphEditorMode {
        ADD_PAGE_MODE,
        ADD_OBJ_MODE,
        ADD_LINK_MODE,
        SELECTION_MODE;

    }
}

