/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.view;

import com.nlbhub.nlb.api.Coords;
import com.nlbhub.nlb.api.Link;
import com.nlbhub.nlb.api.NodeItem;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.Obj;
import com.nlbhub.nlb.api.Page;
import com.nlbhub.nlb.builder.view.LinkPath;
import com.nlbhub.nlb.builder.view.NodePath;
import com.nlbhub.nlb.builder.view.NodeResizeExecutor;
import com.nlbhub.nlb.builder.view.ObjPath;
import com.nlbhub.nlb.builder.view.PagePath;
import com.nlbhub.nlb.domain.NonLinearBookFacade;
import com.nlbhub.nlb.util.StringHelper;
import edu.umd.cs.piccolo.PNode;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphItemsMapper {
    private Map<String, PagePath> m_pages = new HashMap<String, PagePath>();
    private Map<String, ObjPath> m_objs = new HashMap<String, ObjPath>();
    private Map<String, LinkPath> m_links = new HashMap<String, LinkPath>();

    public void init(NonLinearBookFacade nlbFacade, NodeResizeExecutor nodeResizeExecutor, Font font, FontMetrics metrics) {
        this.clear();
        NonLinearBook nlb = nlbFacade.getNlb();
        Map nlbPages = nlb.getPages();
        for (Map.Entry entry : nlbPages.entrySet()) {
            this.addNode(nlb, nodeResizeExecutor, (Page)entry.getValue(), font);
        }
        Map nlbObjs = nlb.getObjs();
        for (Map.Entry entry : nlbObjs.entrySet()) {
            this.addObjNode(nlb, nodeResizeExecutor, (Obj)entry.getValue(), font);
        }
        for (Map.Entry<Object, Object> entry : this.m_objs.entrySet()) {
            ObjPath objPathFrom = (ObjPath)((Object)entry.getValue());
            Obj objFrom = (Obj)objPathFrom.getAttribute("nlbobj");
            for (Link link : objFrom.getLinks()) {
                this.addLink(nlb, font, metrics, objPathFrom, this.getObjById(link.getTarget()), link);
            }
            for (String containedObjId : objFrom.getContainedObjIds()) {
                ObjPath objPath = this.getObjById(containedObjId);
                objPath.moveInFrontOf((PNode)objPathFrom);
            }
        }
        for (Map.Entry<Object, Object> entry : this.m_pages.entrySet()) {
            PagePath pagePathFrom = (PagePath)((Object)entry.getValue());
            Page pageFrom = (Page)pagePathFrom.getAttribute("nlbpage");
            for (Link link : pageFrom.getLinks()) {
                this.addLink(nlb, font, metrics, pagePathFrom, this.getPageById(link.getTarget()), link);
            }
        }
    }

    public void clear() {
        this.m_pages.clear();
        this.m_objs.clear();
        this.m_links.clear();
    }

    public Set<Map.Entry<String, PagePath>> pageEntrySet() {
        return this.m_pages.entrySet();
    }

    public Set<Map.Entry<String, ObjPath>> objEntrySet() {
        return this.m_objs.entrySet();
    }

    public Set<Map.Entry<String, LinkPath>> linkEntrySet() {
        return this.m_links.entrySet();
    }

    public void addPage(PagePath pagePath) {
        Page page = (Page)pagePath.getAttribute("nlbpage");
        if (page != null) {
            this.m_pages.put(page.getId(), pagePath);
        }
    }

    public void addObj(ObjPath objPath) {
        Obj obj = (Obj)objPath.getAttribute("nlbobj");
        if (obj != null) {
            this.m_objs.put(obj.getId(), objPath);
        }
    }

    public void addLink(LinkPath linkPath) {
        Link link = (Link)linkPath.getAttribute("nlblink");
        if (link != null) {
            this.m_links.put(link.getId(), linkPath);
        }
    }

    public LinkPath getLinkById(String id) {
        return this.m_links.get(id);
    }

    public ObjPath getObjById(String id) {
        return this.m_objs.get(id);
    }

    public PagePath getPageById(String id) {
        return this.m_pages.get(id);
    }

    public Rectangle2D getItemRectById(String id) {
        Coords coords;
        Rectangle2D.Float rect = new Rectangle2D.Float();
        PagePath page = this.getPageById(id);
        if (page == null) {
            ObjPath obj = this.getObjById(id);
            if (obj == null) {
                LinkPath link = this.getLinkById(id);
                if (link == null) {
                    return null;
                }
                Link linkData = (Link)link.getAttribute("nlblink");
                NodePath nodePath = this.getPageById(linkData.getTarget());
                if (nodePath != null) {
                    coords = ((Page)nodePath.getAttribute("nlbpage")).getCoords();
                } else {
                    nodePath = this.getObjById(linkData.getTarget());
                    coords = ((Obj)nodePath.getAttribute("nlbobj")).getCoords();
                }
            } else {
                coords = ((Obj)obj.getAttribute("nlbobj")).getCoords();
            }
        } else {
            coords = ((Page)page.getAttribute("nlbpage")).getCoords();
        }
        rect.setFrame(coords.getLeft(), coords.getTop(), coords.getWidth(), coords.getHeight());
        return rect;
    }

    public PagePath addNode(NonLinearBook nonLinearBook, NodeResizeExecutor nodeResizeExecutor, Page page, Font font) {
        PagePath pagePath = new PagePath(nonLinearBook, nodeResizeExecutor, page, font);
        this.addPage(pagePath);
        page.notifyObservers();
        return pagePath;
    }

    public ObjPath addObjNode(NonLinearBook nonLinearBook, NodeResizeExecutor nodeResizeExecutor, Obj obj, Font font) {
        ObjPath objPath = new ObjPath(nonLinearBook, nodeResizeExecutor, obj, font);
        this.addObj(objPath);
        obj.notifyObservers();
        return objPath;
    }

    public LinkPath addLink(NonLinearBook nonLinearBook, Font font, FontMetrics metrics, NodePath nodeFrom, NodePath nodeTo, Link link) {
        LinkPath linkPath = new LinkPath(nonLinearBook, font, metrics, nodeFrom, nodeTo, link);
        this.addLink(linkPath);
        link.notifyObservers();
        return linkPath;
    }

    public List<PNode> getContainedObjsNodes(PNode container) {
        ArrayList<PNode> result = new ArrayList<PNode>();
        NodeItem nodeItem = (NodeItem)container.getAttribute((Object)"nlbpage");
        if (nodeItem == null) {
            nodeItem = (NodeItem)container.getAttribute((Object)"nlbobj");
        }
        for (String objId : nodeItem.getContainedObjIds()) {
            result.add((PNode)this.m_objs.get(objId));
        }
        return result;
    }

    public PNode getContainer(PNode node) {
        Obj obj = (Obj)node.getAttribute((Object)"nlbobj");
        if (obj == null || StringHelper.isEmpty((String)obj.getContainerId())) {
            return null;
        }
        PNode result = (PNode)this.m_pages.get(obj.getContainerId());
        return result != null ? result : (PNode)this.m_objs.get(obj.getContainerId());
    }
}

