/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.view;

import com.nlbhub.nlb.api.Coords;
import com.nlbhub.nlb.api.Link;
import com.nlbhub.nlb.api.NLBObserver;
import com.nlbhub.nlb.api.NodeItem;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.Variable;
import com.nlbhub.nlb.builder.config.Parameters;
import com.nlbhub.nlb.builder.view.ItemPath;
import com.nlbhub.nlb.builder.view.NodePath;
import com.nlbhub.nlb.util.StringHelper;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.List;

public class LinkPath
extends ItemPath
implements NLBObserver {
    private static final int MAX_CAPTION_CHARS_IN_LINK_TEXT = 22;
    public static final Paint NORMAL_PAINT = Color.WHITE;
    public static final Paint NORMAL_STROKE_PAINT = Color.BLACK;
    public static final Paint SELECTED_PAINT = Color.GRAY;
    private NodePath m_nodeFrom;
    private NodePath m_nodeTo;
    private boolean m_linkToSelf;
    private PText m_textNode;
    private FontMetrics m_metrics;

    public LinkPath(NonLinearBook nonLinearBook, Font font, FontMetrics metrics, NodePath nodeFrom, NodePath nodeTo, Link link) {
        NodeItem itemTo;
        this.m_metrics = metrics;
        this.m_nodeFrom = nodeFrom;
        this.m_nodeTo = nodeTo;
        NodeItem itemFrom = (NodeItem)nodeFrom.getAttribute("nlbpage");
        if (itemFrom == null) {
            itemFrom = (NodeItem)nodeFrom.getAttribute("nlbobj");
        }
        if ((itemTo = (NodeItem)nodeTo.getAttribute("nlbpage")) == null) {
            itemTo = (NodeItem)nodeTo.getAttribute("nlbobj");
        }
        this.m_linkToSelf = itemFrom.getId().equals(itemTo.getId());
        this.m_textNode = new PText();
        this.m_textNode.setFont(font);
        this.m_textNode.setHorizontalAlignment(0.0f);
        this.m_textNode.setConstrainHeightToTextHeight(true);
        this.m_textNode.setConstrainWidthToTextWidth(true);
        this.m_textNode.setPickable(true);
        this.addChild((PNode)this.m_textNode);
        this.setPaint(NORMAL_PAINT);
        this.setStrokePaint(NORMAL_STROKE_PAINT);
        this.addAttribute("nlblink", link);
        this.addAttribute("nlbmod", nonLinearBook);
        link.addObserver((NLBObserver)this);
    }

    public NodePath getNodeFrom() {
        return this.m_nodeFrom;
    }

    public NodePath getNodeTo() {
        return this.m_nodeTo;
    }

    private PositionAndTotalCount findLinkPositionBetweenAdjacentLinks() {
        NodeItem itemTo;
        PositionAndTotalCount result = new PositionAndTotalCount();
        NodeItem itemFrom = (NodeItem)this.m_nodeFrom.getAttribute("nlbpage");
        if (itemFrom == null) {
            itemFrom = (NodeItem)this.m_nodeFrom.getAttribute("nlbobj");
        }
        if ((itemTo = (NodeItem)this.m_nodeTo.getAttribute("nlbpage")) == null) {
            itemTo = (NodeItem)this.m_nodeTo.getAttribute("nlbobj");
        }
        Link thisLink = (Link)this.getAttribute("nlblink");
        List pageFromLinks = itemFrom.getLinks();
        int totalCount = 0;
        for (Link link : pageFromLinks) {
            if (!link.getTarget().equals(itemTo.getId()) || link.isDeleted()) continue;
            if (link.getId().equals(thisLink.getId())) {
                result.setPosition(totalCount++);
                continue;
            }
            ++totalCount;
        }
        result.setTotalCount(totalCount);
        return result;
    }

    private Point2D getLinkOrigin() {
        Point2D centerFrom = this.m_nodeFrom.getFullBoundsReference().getCenter2D();
        Point2D centerTo = this.m_nodeTo.getFullBoundsReference().getCenter2D();
        Point2D.Double lineVectorTo = new Point2D.Double(centerTo.getX() - centerFrom.getX(), centerTo.getY() - centerFrom.getY());
        double lineVectorNorm = Math.sqrt(((Point2D)lineVectorTo).getX() * ((Point2D)lineVectorTo).getX() + ((Point2D)lineVectorTo).getY() * ((Point2D)lineVectorTo).getY());
        Point2D.Double lineVector_1 = new Point2D.Double(((Point2D)lineVectorTo).getX() / lineVectorNorm, ((Point2D)lineVectorTo).getY() / lineVectorNorm);
        double radiusFrom = NodePath.countPageRadius((PNode)this.m_nodeFrom, (PNode)this.m_nodeTo);
        double radiusTo = NodePath.countPageRadius((PNode)this.m_nodeTo, (PNode)this.m_nodeFrom);
        Point2D.Double boundaryFrom = new Point2D.Double(centerFrom.getX() + ((Point2D)lineVector_1).getX() * radiusFrom, centerFrom.getY() + ((Point2D)lineVector_1).getY() * radiusFrom);
        Point2D.Double boundaryTo = new Point2D.Double(centerTo.getX() - ((Point2D)lineVector_1).getX() * radiusTo, centerTo.getY() - ((Point2D)lineVector_1).getY() * radiusTo);
        Point2D.Float result = new Point2D.Float();
        ((Point2D)result).setLocation((float)((((Point2D)boundaryFrom).getX() + ((Point2D)boundaryTo).getX()) / 2.0), (float)((((Point2D)boundaryFrom).getY() + ((Point2D)boundaryTo).getY()) / 2.0));
        return result;
    }

    private double getTextRotationAngle() {
        Point2D centerFrom = this.m_nodeFrom.getFullBoundsReference().getCenter2D();
        Point2D centerTo = this.m_nodeTo.getFullBoundsReference().getCenter2D();
        double ratio = (centerTo.getY() - centerFrom.getY()) / (centerTo.getX() - centerFrom.getX());
        double theta = Math.atan(Math.abs(ratio));
        return ratio > 0.0 ? theta : Math.PI * 2 - theta;
    }

    private void update() {
        Link thisLink = (Link)this.getAttribute("nlblink");
        this.setVisible(!thisLink.isDeleted());
        PositionAndTotalCount positionAndTotalCount = this.findLinkPositionBetweenAdjacentLinks();
        Coords coords = thisLink.getCoords();
        if (this.m_linkToSelf) {
            this.changeTextPositionForSelfLink(coords, positionAndTotalCount);
            this.updateSelfLink(positionAndTotalCount);
        } else {
            this.changeTextPosition(coords, positionAndTotalCount);
            this.updateNonSelfLink(positionAndTotalCount);
        }
    }

    private void changeTextPosition(Coords coords, PositionAndTotalCount positionAndTotalCount) {
        Point2D origin = this.getLinkOrigin();
        int adv = this.m_metrics.stringWidth(this.m_textNode.getText());
        this.m_textNode.setBounds((double)(-adv) / 2.0 + (double)coords.getLeft(), (double)(-coords.getHeight() * (float)(positionAndTotalCount.getPosition() + 1) + coords.getTop()), (double)coords.getWidth(), (double)coords.getHeight());
        this.m_textNode.setRotation(this.getTextRotationAngle());
        this.m_textNode.setOffset(origin.getX(), origin.getY());
    }

    private void changeTextPositionForSelfLink(Coords coords, PositionAndTotalCount positionAndTotalCount) {
        Point2D.Float origin = new Point2D.Float();
        ((Point2D)origin).setLocation((float)this.m_nodeFrom.getFullBoundsReference().getMaxX(), (float)this.m_nodeFrom.getFullBoundsReference().getMinY());
        this.m_textNode.setBounds((double)coords.getLeft(), (double)(-coords.getHeight() * (float)(positionAndTotalCount.getPosition() + 1) + coords.getTop()), (double)coords.getWidth(), (double)coords.getHeight());
        this.m_textNode.setOffset(((Point2D)origin).getX(), ((Point2D)origin).getY());
    }

    private void updateSelfLink(PositionAndTotalCount positionAndTotalCount) {
        this.reset();
        double shift = Parameters.singleton().getArrowOffsetCoef() * (double)(positionAndTotalCount.getPosition() + 1);
        Point2D.Double ptBegin = new Point2D.Double(this.m_nodeFrom.getFullBoundsReference().getCenter2D().getX() + shift + this.m_nodeFrom.getFullBoundsReference().getWidth() / 2.0, this.m_nodeFrom.getFullBoundsReference().getCenter2D().getY());
        Point2D.Double ptEnd = new Point2D.Double(this.m_nodeTo.getFullBoundsReference().getCenter2D().getX(), this.m_nodeTo.getFullBoundsReference().getCenter2D().getY());
        int iRadiusFrom = 0;
        int iRadiusTo = (int)(this.m_nodeTo.getFullBoundsReference().getWidth() / 2.0);
        if (positionAndTotalCount.isLast()) {
            this.moveTo((float)this.m_nodeFrom.getFullBoundsReference().getMaxX(), (float)this.m_nodeFrom.getFullBoundsReference().getMinY());
            this.lineTo((float)((Point2D)ptBegin).getX(), (float)this.m_nodeFrom.getFullBoundsReference().getMinY());
            this.curveTo((float)((Point2D)ptBegin).getX(), (float)this.m_nodeFrom.getFullBoundsReference().getMinY(), (float)(((Point2D)ptBegin).getX() + this.m_nodeFrom.getFullBoundsReference().getHeight() / 2.0), (float)((this.m_nodeFrom.getFullBoundsReference().getMinY() + ((Point2D)ptBegin).getY()) / 2.0), (float)((Point2D)ptBegin).getX(), (float)((Point2D)ptBegin).getY());
        }
        boolean somethingWasDrawed = this.drawArrow(ptBegin, ptEnd, positionAndTotalCount, iRadiusFrom, iRadiusTo, positionAndTotalCount.isLast(), true);
        if (positionAndTotalCount.isLast()) {
            this.lineTo((float)((Point2D)ptBegin).getX(), (float)((Point2D)ptBegin).getY());
            this.curveTo((float)((Point2D)ptBegin).getX(), (float)((Point2D)ptBegin).getY(), (float)(((Point2D)ptBegin).getX() + this.m_nodeFrom.getFullBoundsReference().getHeight() / 2.0), (float)((this.m_nodeFrom.getFullBoundsReference().getMinY() + ((Point2D)ptBegin).getY()) / 2.0), (float)((Point2D)ptBegin).getX(), (float)this.m_nodeFrom.getFullBoundsReference().getMinY());
            this.lineTo((float)((Point2D)ptBegin).getX(), (float)this.m_nodeFrom.getFullBoundsReference().getMinY());
        }
        if (somethingWasDrawed) {
            this.closePath();
        }
    }

    private void updateNonSelfLink(PositionAndTotalCount positionAndTotalCount) {
        this.reset();
        Point2D.Double ptBegin = new Point2D.Double(this.m_nodeFrom.getFullBoundsReference().getCenter2D().getX(), this.m_nodeFrom.getFullBoundsReference().getCenter2D().getY());
        Point2D.Double ptEnd = new Point2D.Double(this.m_nodeTo.getFullBoundsReference().getCenter2D().getX(), this.m_nodeTo.getFullBoundsReference().getCenter2D().getY());
        int iRadiusFrom = (int)NodePath.countPageRadius((PNode)this.m_nodeFrom, (PNode)this.m_nodeTo);
        int iRadiusTo = (int)NodePath.countPageRadius((PNode)this.m_nodeTo, (PNode)this.m_nodeFrom);
        boolean somethingWasDrawed = this.drawArrow(ptBegin, ptEnd, positionAndTotalCount, iRadiusFrom, iRadiusTo, false, false);
        if (somethingWasDrawed) {
            this.closePath();
        }
    }

    private boolean drawArrow(Point2D ptBegin, Point2D ptEnd, PositionAndTotalCount positionAndTotalCount, int iRadiusFrom, int iRadiusTo, boolean continueDrawing, boolean forceDraw) {
        double arrowOffset = Parameters.singleton().getArrowOffsetCoef() * (double)positionAndTotalCount.getPosition();
        Point2D.Double lineVectorTo = new Point2D.Double(ptEnd.getX() - ptBegin.getX(), ptEnd.getY() - ptBegin.getY());
        double lineVectorNorm = Math.sqrt(((Point2D)lineVectorTo).getX() * ((Point2D)lineVectorTo).getX() + ((Point2D)lineVectorTo).getY() * ((Point2D)lineVectorTo).getY());
        if (lineVectorNorm > (double)(iRadiusFrom + iRadiusTo) || forceDraw) {
            Point2D.Double lineVector_1 = new Point2D.Double(((Point2D)lineVectorTo).getX() / lineVectorNorm, ((Point2D)lineVectorTo).getY() / lineVectorNorm);
            Point2D.Double lineVectorFrom = new Point2D.Double(((Point2D)lineVector_1).getX() * (double)iRadiusFrom, ((Point2D)lineVector_1).getY() * (double)iRadiusFrom);
            ((Point2D)lineVectorTo).setLocation(((Point2D)lineVector_1).getX() * ((double)iRadiusTo + arrowOffset), ((Point2D)lineVector_1).getY() * ((double)iRadiusTo + arrowOffset));
            ptBegin.setLocation(ptBegin.getX() + ((Point2D)lineVectorFrom).getX(), ptBegin.getY() + ((Point2D)lineVectorFrom).getY());
            ptEnd.setLocation(ptEnd.getX() - ((Point2D)lineVectorTo).getX(), ptEnd.getY() - ((Point2D)lineVectorTo).getY());
            Point2D.Double Ort_To_lineVector_1 = new Point2D.Double(-((Point2D)lineVector_1).getY(), ((Point2D)lineVector_1).getX());
            double arrowWidthCoef = Parameters.singleton().getArrowWidthCoef();
            double arrowHeightCoef = Parameters.singleton().getArrowHeightCoef();
            Point2D.Double ptEnd_Arrow1 = new Point2D.Double(arrowWidthCoef * (-((Point2D)lineVector_1).getX() - ((Point2D)Ort_To_lineVector_1).getX() * arrowHeightCoef) + ptEnd.getX(), arrowWidthCoef * (-((Point2D)lineVector_1).getY() - ((Point2D)Ort_To_lineVector_1).getY() * arrowHeightCoef) + ptEnd.getY());
            Point2D.Double ptEnd_Arrow2 = new Point2D.Double(arrowWidthCoef * (-((Point2D)lineVector_1).getX() + ((Point2D)Ort_To_lineVector_1).getX() * arrowHeightCoef) + ptEnd.getX(), arrowWidthCoef * (-((Point2D)lineVector_1).getY() + ((Point2D)Ort_To_lineVector_1).getY() * arrowHeightCoef) + ptEnd.getY());
            Point2D.Double ptEndArrowOnMainLine = new Point2D.Double((((Point2D)ptEnd_Arrow1).getX() + ((Point2D)ptEnd_Arrow2).getX()) / 2.0, (((Point2D)ptEnd_Arrow1).getY() + ((Point2D)ptEnd_Arrow2).getY()) / 2.0);
            if (continueDrawing) {
                this.lineTo((float)ptBegin.getX(), (float)ptBegin.getY());
            } else {
                this.moveTo((float)ptBegin.getX(), (float)ptBegin.getY());
            }
            this.lineTo((float)((Point2D)ptEndArrowOnMainLine).getX(), (float)((Point2D)ptEndArrowOnMainLine).getY());
            this.lineTo((float)((Point2D)ptEnd_Arrow1).getX(), (float)((Point2D)ptEnd_Arrow1).getY());
            this.lineTo((float)ptEnd.getX(), (float)ptEnd.getY());
            this.lineTo((float)((Point2D)ptEnd_Arrow2).getX(), (float)((Point2D)ptEnd_Arrow2).getY());
            this.lineTo((float)((Point2D)ptEndArrowOnMainLine).getX(), (float)((Point2D)ptEndArrowOnMainLine).getY());
            return true;
        }
        return false;
    }

    public void updateView() {
        this.update();
        this.m_textNode.setText(this.buildText());
    }

    @Override
    protected String buildText() {
        NonLinearBook nonLinearBook = (NonLinearBook)this.getAttribute("nlbmod");
        Link link = (Link)this.getAttribute("nlblink");
        Variable variable = nonLinearBook.getVariableById(link.getVarId());
        Variable variableCons = nonLinearBook.getVariableById(link.getConstrId());
        StringBuilder text = new StringBuilder();
        if (link.isAuto()) {
            text.append("<A> ");
        }
        if (link.isOnce()) {
            text.append("<O> ");
        }
        if (!StringHelper.isEmpty((String)link.getText())) {
            int captionSize = link.getText().length();
            if (captionSize > 22) {
                text.append(link.getText().substring(0, 22));
                text.append("...");
            } else {
                text.append(link.getText());
            }
            if (variable != null) {
                text.append(": ");
            }
        }
        if (variable != null) {
            text.append("[").append(variable.getName()).append("]");
        }
        if (variableCons != null) {
            text.append(": /").append(variableCons.getValue()).append("/");
        }
        return text.toString();
    }

    private class PositionAndTotalCount {
        private int m_position = 0;
        private int m_totalCount = 0;

        private PositionAndTotalCount() {
        }

        public int getPosition() {
            return this.m_position;
        }

        public void setPosition(int position) {
            this.m_position = position;
        }

        public int getTotalCount() {
            return this.m_totalCount;
        }

        public void setTotalCount(int totalCount) {
            this.m_totalCount = totalCount;
        }

        public boolean isLast() {
            return this.m_position == this.m_totalCount - 1;
        }
    }
}

