/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.view;

import com.nlbhub.nlb.api.Coords;
import com.nlbhub.nlb.api.NLBObserver;
import com.nlbhub.nlb.api.NodeItem;
import com.nlbhub.nlb.builder.view.ItemPath;
import com.nlbhub.nlb.builder.view.NodeResizeExecutor;
import com.nlbhub.nlb.builder.view.ResizeBar;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public abstract class NodePath
extends ItemPath
implements NLBObserver {
    private ResizeBar m_leftResizeBar;
    private ResizeBar m_rightResizeBar;
    private ResizeBar m_topResizeBar;
    private ResizeBar m_bottomResizeBar;
    private Rectangle2D.Float m_nodeRect;
    private PText m_textNode;
    private Rectangle2D.Float m_textRect;

    protected NodePath(NodeResizeExecutor nodeResizeExecutor, NodeItem nodeItem, Font font) {
        Coords coords = nodeItem.getCoords();
        this.m_nodeRect = new Rectangle2D.Float();
        this.m_textRect = new Rectangle2D.Float();
        this.m_nodeRect.setFrame(coords.getLeft(), coords.getTop(), coords.getWidth(), coords.getHeight());
        this.append(this.m_nodeRect, false);
        this.m_textNode = new PText();
        this.m_textNode.setFont(font);
        this.m_textNode.setHorizontalAlignment(0.5f);
        this.m_textNode.setConstrainHeightToTextHeight(false);
        this.m_textNode.setConstrainWidthToTextWidth(false);
        this.m_textNode.setPickable(false);
        this.addChild((PNode)this.m_textNode);
        this.m_leftResizeBar = new ResizeBar(nodeResizeExecutor, this, coords, NodeItem.Orientation.LEFT);
        this.addChild((PNode)this.m_leftResizeBar);
        this.m_rightResizeBar = new ResizeBar(nodeResizeExecutor, this, coords, NodeItem.Orientation.RIGHT);
        this.addChild((PNode)this.m_rightResizeBar);
        this.m_topResizeBar = new ResizeBar(nodeResizeExecutor, this, coords, NodeItem.Orientation.TOP);
        this.addChild((PNode)this.m_topResizeBar);
        this.m_bottomResizeBar = new ResizeBar(nodeResizeExecutor, this, coords, NodeItem.Orientation.BOTTOM);
        this.addChild((PNode)this.m_bottomResizeBar);
        nodeItem.addObserver((NLBObserver)this);
    }

    protected void resizeNode(Coords coords) {
        this.setOffset(0.0, 0.0);
        this.m_nodeRect.setFrame(coords.getLeft(), coords.getTop(), coords.getWidth(), coords.getHeight());
        this.setBounds(this.m_nodeRect);
        this.m_leftResizeBar.reposition(coords);
        this.m_rightResizeBar.reposition(coords);
        this.m_topResizeBar.reposition(coords);
        this.m_bottomResizeBar.reposition(coords);
        float fontSize = this.m_textNode.getFont().getSize2D();
        this.m_textRect.setFrame(coords.getLeft(), coords.getTop() + fontSize, coords.getWidth(), coords.getHeight() - fontSize);
        this.m_textNode.setBounds((Rectangle2D)this.m_textRect);
    }

    public Rectangle2D.Float getNodeRect() {
        return this.m_nodeRect;
    }

    public static double countPageRadius(@NotNull PNode nodeFrom, @NotNull PNode nodeTo) {
        double flRadiusVert;
        PBounds nodeFromFullBR = nodeFrom.getFullBoundsReference();
        PBounds nodeToFullBR = nodeTo.getFullBoundsReference();
        double flHorzKatetA = nodeFromFullBR.getWidth() / 2.0;
        double flVertKatetA = nodeFromFullBR.getHeight() / 2.0;
        Point2D.Double ptThis = new Point2D.Double(nodeFromFullBR.getMinX() + nodeFromFullBR.getWidth() / 2.0, nodeFromFullBR.getMinY() + nodeFromFullBR.getHeight() / 2.0);
        Point2D.Double ptTo = new Point2D.Double(nodeToFullBR.getMinX() + nodeToFullBR.getWidth() / 2.0, nodeToFullBR.getMinY() + nodeToFullBR.getHeight() / 2.0);
        double flLambdaHorz = Math.abs(((Point2D)ptTo).getX() - ((Point2D)ptThis).getX()) / flHorzKatetA;
        double flLambdaVert = Math.abs(((Point2D)ptTo).getY() - ((Point2D)ptThis).getY()) / flVertKatetA;
        double flHorzKatetB = Math.abs(((Point2D)ptTo).getY() - ((Point2D)ptThis).getY()) / flLambdaHorz;
        double flVertKatetB = Math.abs(((Point2D)ptTo).getX() - ((Point2D)ptThis).getX()) / flLambdaVert;
        double flRadiusHorz = Math.sqrt(flHorzKatetA * flHorzKatetA + flHorzKatetB * flHorzKatetB);
        if (flRadiusHorz < (flRadiusVert = Math.sqrt(flVertKatetA * flVertKatetA + flVertKatetB * flVertKatetB))) {
            return flRadiusHorz;
        }
        return flRadiusVert;
    }

    public void updateView() {
        NodeItem nodeItem = (NodeItem)this.getAttribute("nlbpage");
        if (nodeItem == null) {
            nodeItem = (NodeItem)this.getAttribute("nlbobj");
        }
        this.setVisible(!nodeItem.isDeleted());
        this.resizeNode(nodeItem.getCoords());
        this.m_textNode.setText(this.buildText());
    }
}

