/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.view;

import com.nlbhub.nlb.api.Coords;
import com.nlbhub.nlb.api.NodeItem;
import com.nlbhub.nlb.api.NonLinearBook;
import com.nlbhub.nlb.api.Obj;
import com.nlbhub.nlb.api.Variable;
import com.nlbhub.nlb.builder.view.NodePath;
import com.nlbhub.nlb.builder.view.NodeResizeExecutor;
import com.nlbhub.nlb.util.StringHelper;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;

public class ObjPath
extends NodePath {
    private static final int MAX_NAME_CHARS_IN_NAME_TEXT = 42;
    private static final String INFO_OBJ = "<Obj> ";
    private static final String INFO_CONTAINED = "<C> ";
    private final PText m_infoNode = new PText("<Obj> ");
    private String m_infoText = "<Obj> ";

    public ObjPath(NonLinearBook nonLinearBook, NodeResizeExecutor nodeResizeExecutor, Obj obj, Font font) {
        super(nodeResizeExecutor, (NodeItem)obj, font);
        this.m_infoNode.setVisible(true);
        this.addChild((PNode)this.m_infoNode);
        this.m_infoNode.setFont(font);
        this.m_infoNode.setPickable(false);
        this.setPaint(Color.white);
        this.addAttribute("nlbobj", obj);
        this.addAttribute("nlbmod", nonLinearBook);
        this.resizeNode(obj.getCoords());
    }

    @Override
    protected void resizeNode(Coords coords) {
        super.resizeNode(coords);
        this.m_infoNode.setBounds((Rectangle2D)this.getNodeRect());
        this.m_infoNode.setText(this.m_infoText);
    }

    @Override
    public void updateView() {
        Obj obj = (Obj)this.getAttribute("nlbobj");
        this.m_infoText = INFO_OBJ;
        if (!StringHelper.isEmpty((String)obj.getContainerId())) {
            this.m_infoText = this.m_infoText + INFO_CONTAINED;
        }
        super.updateView();
    }

    @Override
    protected String buildText() {
        Obj obj = (Obj)this.getAttribute("nlbobj");
        NonLinearBook nonLinearBook = (NonLinearBook)this.getAttribute("nlbmod");
        Variable variable = nonLinearBook.getVariableById(obj.getVarId());
        Variable constraint = nonLinearBook.getVariableById(obj.getConstrId());
        StringBuilder text = new StringBuilder();
        if (!StringHelper.isEmpty((String)obj.getName())) {
            int nameSize = obj.getName().length();
            if (nameSize > 42) {
                text.append(obj.getName().substring(0, 42));
                text.append("...");
            } else {
                text.append(obj.getName());
            }
        }
        if (variable != null) {
            text.append(": [").append(variable.getName()).append("]");
        }
        if (constraint != null) {
            text.append(": /").append(constraint.getValue()).append("/");
        }
        return text.toString();
    }
}

