/*
 * Decompiled with CFR 0.152.
 */
package com.nlbhub.nlb.builder.view;

import com.nlbhub.nlb.api.Coords;
import com.nlbhub.nlb.api.NodeItem;
import com.nlbhub.nlb.builder.view.NodePath;
import com.nlbhub.nlb.builder.view.NodeResizeExecutor;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Rectangle2D;

public class ResizeBar
extends PPath {
    private float m_resizeBarThickness = 5.0f;
    private float m_resizeBarCornerOffsetHorz = 22.0f;
    private float m_resizeBarCornerOffsetVert = 12.0f;
    private NodeItem.Orientation m_orientation;
    private Rectangle2D.Float m_resizeRect;
    private NodeResizeExecutor m_nodeResizeExecutor;

    public ResizeBar(NodeResizeExecutor nodeResizeExecutor, NodePath node, Coords coords, NodeItem.Orientation orientation) {
        this.m_nodeResizeExecutor = nodeResizeExecutor;
        this.m_orientation = orientation;
        this.m_resizeRect = new Rectangle2D.Float();
        this.reposition(coords);
        this.append(this.m_resizeRect, false);
        this.addInputEventListener((PInputEventListener)new ResizeBarEventHandler(node, this));
    }

    public void reposition(Coords coords) {
        this.setOffset(0.0, 0.0);
        switch (this.m_orientation) {
            case LEFT: {
                this.m_resizeRect.setFrame(coords.getLeft() - this.m_resizeBarThickness, coords.getTop() + this.m_resizeBarCornerOffsetVert, this.m_resizeBarThickness, coords.getHeight() - 2.0f * this.m_resizeBarCornerOffsetVert);
                break;
            }
            case RIGHT: {
                this.m_resizeRect.setFrame(coords.getLeft() + coords.getWidth(), coords.getTop() + this.m_resizeBarCornerOffsetVert, this.m_resizeBarThickness, coords.getHeight() - 2.0f * this.m_resizeBarCornerOffsetVert);
                break;
            }
            case TOP: {
                this.m_resizeRect.setFrame(coords.getLeft() + this.m_resizeBarCornerOffsetHorz, coords.getTop() - this.m_resizeBarThickness, coords.getWidth() - 2.0f * this.m_resizeBarCornerOffsetHorz, this.m_resizeBarThickness);
                break;
            }
            case BOTTOM: {
                this.m_resizeRect.setFrame(coords.getLeft() + this.m_resizeBarCornerOffsetHorz, coords.getTop() + coords.getHeight(), coords.getWidth() - 2.0f * this.m_resizeBarCornerOffsetHorz, this.m_resizeBarThickness);
            }
        }
        this.setBounds(this.m_resizeRect);
    }

    private class ResizeBarEventHandler
    extends PBasicInputEventHandler {
        private NodePath m_resizingNode;
        private ResizeBar m_resizeBar;
        private double m_totalDeltaX = 0.0;
        private double m_totalDeltaY = 0.0;

        private ResizeBarEventHandler(NodePath resizingNode, ResizeBar resizeBar2) {
            this.m_resizingNode = resizingNode;
            this.m_resizeBar = resizeBar2;
        }

        public void mousePressed(PInputEvent event) {
            this.clearResizeInfo();
            event.setHandled(true);
        }

        private void clearResizeInfo() {
            this.m_totalDeltaX = 0.0;
            this.m_totalDeltaY = 0.0;
        }

        public void mouseDragged(PInputEvent event) {
            PDimension delta = event.getDeltaRelativeTo((PNode)this.m_resizeBar);
            switch (this.m_resizeBar.m_orientation) {
                case LEFT: 
                case RIGHT: {
                    this.m_totalDeltaX += delta.getWidth();
                    ResizeBar.this.translate(delta.getWidth(), 0.0);
                    break;
                }
                case TOP: 
                case BOTTOM: {
                    this.m_totalDeltaY += delta.getHeight();
                    ResizeBar.this.translate(0.0, delta.getHeight());
                }
            }
            event.setHandled(true);
        }

        public void mouseReleased(PInputEvent event) {
            ResizeBar.this.m_nodeResizeExecutor.executeResize(this.m_resizingNode, this.m_resizeBar.m_orientation, this.m_totalDeltaX, this.m_totalDeltaY);
            this.clearResizeInfo();
            event.setHandled(true);
        }

        public void keyPressed(PInputEvent event) {
            event.setHandled(true);
        }

        public void keyReleased(PInputEvent event) {
            event.setHandled(true);
        }

        public void keyTyped(PInputEvent event) {
            event.setHandled(true);
        }

        public void mouseClicked(PInputEvent event) {
            event.setHandled(true);
        }

        public void mouseMoved(PInputEvent event) {
            event.setHandled(true);
        }

        public void mouseWheelRotated(PInputEvent event) {
            event.setHandled(true);
        }

        public void mouseWheelRotatedByBlock(PInputEvent event) {
            event.setHandled(true);
        }

        public void keyboardFocusGained(PInputEvent event) {
            event.setHandled(true);
        }

        public void keyboardFocusLost(PInputEvent event) {
            event.setHandled(true);
        }
    }
}

