/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.registry.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import org.apache.wink.common.internal.registry.Injectable;
import org.apache.wink.common.internal.registry.metadata.AbstractMetadata;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodMetadata
extends AbstractMetadata {
    private static final Logger logger = LoggerFactory.getLogger(MethodMetadata.class);
    private ClassMetadata parent;
    private Method reflectionMethod;
    private String httpMethod;
    private List<Injectable> formalParameters;

    public MethodMetadata(ClassMetadata parent) {
        this.parent = parent;
        this.formalParameters = new ArrayList<Injectable>();
        this.httpMethod = null;
        this.reflectionMethod = null;
    }

    public Method getReflectionMethod() {
        return this.reflectionMethod;
    }

    public void setReflectionMethod(Method reflectionMethod) {
        logger.trace("setReflectionMethod({}) entry", (Object)reflectionMethod);
        this.reflectionMethod = reflectionMethod;
        logger.trace("setReflectionMethod() exit");
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        logger.trace("setHttpMethod({}) entry", (Object)httpMethod);
        this.httpMethod = httpMethod;
        logger.trace("setHttpMethod() exit");
    }

    public List<Injectable> getFormalParameters() {
        return this.formalParameters;
    }

    @Override
    public Set<MediaType> getConsumes() {
        Set<MediaType> set = super.getConsumes();
        if (set.size() == 0) {
            set = this.parent.getConsumes();
        }
        return set;
    }

    @Override
    public Set<MediaType> getProduces() {
        Set<MediaType> set = super.getProduces();
        if (set.size() == 0) {
            set = this.parent.getProduces();
        }
        return set;
    }

    @Override
    public String toString() {
        return "MethodMetadata [" + super.toString() + (this.formalParameters != null ? "formalParameters=" + this.formalParameters + ", " : "") + (this.httpMethod != null ? "httpMethod=" + this.httpMethod + ", " : "") + (this.parent != null ? "parent=" + this.parent + ", " : "") + (this.reflectionMethod != null ? "reflectionMethod=" + this.reflectionMethod : "") + "]";
    }
}

