/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Dimension2D;

public class PNodeCache
extends PNode {
    private static final long serialVersionUID = 1L;
    private transient Image imageCache;
    private boolean validatingCache;

    public Image createImageCache(Dimension2D cacheOffsetRef) {
        return this.toImage();
    }

    public Image getImageCache() {
        if (this.imageCache == null) {
            PDimension cacheOffsetRef = new PDimension();
            this.validatingCache = true;
            this.resetBounds();
            this.imageCache = this.createImageCache((Dimension2D)cacheOffsetRef);
            PBounds b = this.getFullBoundsReference();
            this.setBounds(b.getX() + cacheOffsetRef.getWidth(), b.getY() + cacheOffsetRef.getHeight(), this.imageCache.getWidth(null), this.imageCache.getHeight(null));
            this.validatingCache = false;
        }
        return this.imageCache;
    }

    public void invalidateCache() {
        this.imageCache = null;
    }

    public void invalidatePaint() {
        if (!this.validatingCache) {
            super.invalidatePaint();
        }
    }

    public void repaintFrom(PBounds localBounds, PNode childOrThis) {
        if (!this.validatingCache) {
            super.repaintFrom(localBounds, childOrThis);
            this.invalidateCache();
        }
    }

    public void fullPaint(PPaintContext paintContext) {
        if (this.validatingCache) {
            super.fullPaint(paintContext);
        } else {
            Graphics2D g2 = paintContext.getGraphics();
            g2.drawImage(this.getImageCache(), (int)this.getX(), (int)this.getY(), null);
        }
    }

    protected boolean pickAfterChildren(PPickPath pickPath) {
        return false;
    }
}

