/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.event.PPanEventHandler;
import edu.umd.cs.piccolo.event.PZoomEventHandler;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDebug;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PStack;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.Timer;

public class PCanvas
extends JComponent
implements PComponent {
    private static final long serialVersionUID = 1L;
    public static final String INTERATING_CHANGED_NOTIFICATION = "INTERATING_CHANGED_NOTIFICATION";
    public static final String INTERACTING_CHANGED_NOTIFICATION = "INTERACTING_CHANGED_NOTIFICATION";
    public static final String PROPERTY_INTERACTING = "INTERACTING_CHANGED_NOTIFICATION";
    public static PCanvas CURRENT_ZCANVAS = null;
    private PCamera camera;
    private final PStack cursorStack;
    private int interacting;
    private int normalRenderQuality;
    private int animatingRenderQuality;
    private int interactingRenderQuality;
    private transient PPanEventHandler panEventHandler;
    private transient PZoomEventHandler zoomEventHandler;
    private boolean paintingImmediately;
    private boolean animatingOnLastPaint;
    private transient MouseListener mouseListener;
    private transient KeyEventPostProcessor keyEventPostProcessor;
    private transient MouseWheelListener mouseWheelListener;
    private transient MouseMotionListener mouseMotionListener;
    private static final int ALL_BUTTONS_MASK = 7168;
    private boolean isButton1Pressed;
    private boolean isButton2Pressed;
    private boolean isButton3Pressed;
    private PBounds repaintBounds = new PBounds();

    public PCanvas() {
        CURRENT_ZCANVAS = this;
        this.cursorStack = new PStack();
        this.setCamera(this.createDefaultCamera());
        this.setDefaultRenderQuality(1);
        this.setAnimatingRenderQuality(0);
        this.setInteractingRenderQuality(0);
        this.setPanEventHandler(new PPanEventHandler());
        this.setZoomEventHandler(new PZoomEventHandler());
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if (e.getComponent() == PCanvas.this) {
                    if (PCanvas.this.getParent() == null) {
                        PCanvas.this.removeInputSources();
                    } else if (PCanvas.this.isEnabled()) {
                        PCanvas.this.installInputSources();
                    }
                }
            }
        });
    }

    protected PCamera createDefaultCamera() {
        return PUtil.createBasicScenegraph();
    }

    public PPanEventHandler getPanEventHandler() {
        return this.panEventHandler;
    }

    public void setPanEventHandler(PPanEventHandler handler) {
        if (this.panEventHandler != null) {
            this.removeInputEventListener(this.panEventHandler);
        }
        this.panEventHandler = handler;
        if (this.panEventHandler != null) {
            this.addInputEventListener(this.panEventHandler);
        }
    }

    public PZoomEventHandler getZoomEventHandler() {
        return this.zoomEventHandler;
    }

    public void setZoomEventHandler(PZoomEventHandler handler) {
        if (this.zoomEventHandler != null) {
            this.removeInputEventListener(this.zoomEventHandler);
        }
        this.zoomEventHandler = handler;
        if (this.zoomEventHandler != null) {
            this.addInputEventListener(this.zoomEventHandler);
        }
    }

    public PCamera getCamera() {
        return this.camera;
    }

    public void setCamera(PCamera newCamera) {
        if (this.camera != null) {
            this.camera.setComponent(null);
        }
        this.camera = newCamera;
        if (this.camera != null) {
            this.camera.setComponent(this);
            this.camera.setBounds(this.getBounds());
        }
    }

    public PRoot getRoot() {
        return this.camera.getRoot();
    }

    public PLayer getLayer() {
        return this.camera.getLayer(0);
    }

    public void addInputEventListener(PInputEventListener listener) {
        this.getCamera().addInputEventListener(listener);
    }

    public void removeInputEventListener(PInputEventListener listener) {
        this.getCamera().removeInputEventListener(listener);
    }

    public boolean getInteracting() {
        return this.interacting > 0 || this.getRoot().getInteracting();
    }

    public boolean getAnimating() {
        return this.getRoot().getActivityScheduler().getAnimating();
    }

    public void setInteracting(boolean isInteracting) {
        boolean newInteracting;
        boolean wasInteracting = this.getInteracting();
        this.interacting = isInteracting ? ++this.interacting : --this.interacting;
        if (!this.getInteracting()) {
            int nextRenderQuality = this.normalRenderQuality;
            if (this.getAnimating()) {
                nextRenderQuality = this.animatingRenderQuality;
            }
            if (nextRenderQuality > this.interactingRenderQuality) {
                this.repaint();
            }
        }
        if (wasInteracting != (newInteracting = this.getInteracting())) {
            this.firePropertyChange("INTERACTING_CHANGED_NOTIFICATION", wasInteracting, newInteracting);
        }
    }

    public void setDefaultRenderQuality(int defaultRenderQuality) {
        this.normalRenderQuality = defaultRenderQuality;
        this.repaint();
    }

    public void setAnimatingRenderQuality(int animatingRenderQuality) {
        this.animatingRenderQuality = animatingRenderQuality;
        if (this.getAnimating()) {
            this.repaint();
        }
    }

    public void setInteractingRenderQuality(int interactingRenderQuality) {
        this.interactingRenderQuality = interactingRenderQuality;
        if (this.getInteracting()) {
            this.repaint();
        }
    }

    public void pushCursor(Cursor cursor) {
        this.cursorStack.push(this.getCursor());
        this.setCursor(cursor);
    }

    public void popCursor() {
        if (!this.cursorStack.isEmpty()) {
            this.setCursor((Cursor)this.cursorStack.pop());
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.isEnabled() && this.getParent() != null) {
            this.installInputSources();
        } else {
            this.removeInputSources();
        }
    }

    protected void installInputSources() {
        if (this.mouseListener == null) {
            this.mouseListener = new MouseEventInputSource();
            this.addMouseListener(this.mouseListener);
        }
        if (this.mouseMotionListener == null) {
            this.mouseMotionListener = new MouseMotionInputSourceListener();
            this.addMouseMotionListener(this.mouseMotionListener);
        }
        if (this.mouseWheelListener == null) {
            this.mouseWheelListener = new MouseWheelInputSourceListener();
            this.addMouseWheelListener(this.mouseWheelListener);
        }
        if (this.keyEventPostProcessor == null) {
            this.keyEventPostProcessor = new KeyEventInputSourceListener();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.keyEventPostProcessor);
        }
    }

    protected void removeInputSources() {
        this.removeMouseListener(this.mouseListener);
        this.removeMouseMotionListener(this.mouseMotionListener);
        this.removeMouseWheelListener(this.mouseWheelListener);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.keyEventPostProcessor);
        this.mouseListener = null;
        this.mouseMotionListener = null;
        this.mouseWheelListener = null;
        this.keyEventPostProcessor = null;
    }

    protected void sendInputEventToInputManager(InputEvent event, int type) {
        this.getRoot().getDefaultInputManager().processEventFromCamera(event, type, this.getCamera());
    }

    public void setBounds(int x, int y, int width, int height) {
        this.camera.setBounds(this.camera.getX(), this.camera.getY(), width, height);
        super.setBounds(x, y, width, height);
    }

    public void repaint(PBounds bounds) {
        PDebug.processRepaint();
        bounds.expandNearestIntegerDimensions();
        bounds.inset(-1.0, -1.0);
        this.repaint((int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height);
    }

    public void paintComponent(Graphics g) {
        PDebug.startProcessingOutput();
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.getAnimating()) {
            this.repaintBounds.add(g2.getClipBounds());
        }
        PPaintContext paintContext = new PPaintContext(g2);
        if (this.getInteracting() || this.getAnimating()) {
            if (this.interactingRenderQuality < this.animatingRenderQuality) {
                paintContext.setRenderQuality(this.interactingRenderQuality);
            } else {
                paintContext.setRenderQuality(this.animatingRenderQuality);
            }
        } else {
            paintContext.setRenderQuality(this.normalRenderQuality);
        }
        this.camera.fullPaint(paintContext);
        if (!this.getAnimating() && this.animatingOnLastPaint) {
            this.repaint(this.repaintBounds);
            this.repaintBounds.reset();
        }
        this.animatingOnLastPaint = this.getAnimating();
        PDebug.endProcessingOutput(g2);
    }

    public void paintImmediately() {
        if (this.paintingImmediately) {
            return;
        }
        this.paintingImmediately = true;
        RepaintManager.currentManager(this).paintDirtyRegions();
        this.paintingImmediately = false;
    }

    public Timer createTimer(int delay, ActionListener listener) {
        return new Timer(delay, listener);
    }

    public int getDefaultRenderQuality() {
        return this.normalRenderQuality;
    }

    public int getNormalRenderQuality() {
        return this.normalRenderQuality;
    }

    public int getAnimatingRenderQuality() {
        return this.animatingRenderQuality;
    }

    public int getInteractingRenderQuality() {
        return this.interactingRenderQuality;
    }

    public PInputEventListener[] getInputEventListeners() {
        return this.camera.getInputEventListeners();
    }

    public void printAll(Graphics graphics) {
        if (!(graphics instanceof Graphics2D)) {
            throw new IllegalArgumentException("Provided graphics context is not a Graphics2D object");
        }
        Graphics2D g2 = (Graphics2D)graphics;
        PBounds clippingRect = new PBounds(graphics.getClipBounds());
        clippingRect.expandNearestIntegerDimensions();
        PBounds originalCameraBounds = this.getCamera().getBounds();
        PBounds layerBounds = this.getCamera().getUnionOfLayerFullBounds();
        this.getCamera().setBounds(layerBounds);
        double clipRatio = clippingRect.getWidth() / clippingRect.getHeight();
        double nodeRatio = (double)this.getWidth() / (double)this.getHeight();
        double scale = nodeRatio <= clipRatio ? clippingRect.getHeight() / this.getCamera().getHeight() : clippingRect.getWidth() / this.getCamera().getWidth();
        g2.scale(scale, scale);
        g2.translate(-clippingRect.x, -clippingRect.y);
        PPaintContext pc = new PPaintContext(g2);
        pc.setRenderQuality(1);
        this.getCamera().fullPaint(pc);
        this.getCamera().setBounds(originalCameraBounds);
    }

    private boolean isAnyButtonDown(MouseEvent e) {
        return (e.getModifiersEx() & 0x1C00) != 0;
    }

    private final class MouseWheelInputSourceListener
    implements MouseWheelListener {
        private MouseWheelInputSourceListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            PCanvas.this.sendInputEventToInputManager(e, e.getScrollType());
            if (!e.isConsumed() && PCanvas.this.getParent() != null) {
                PCanvas.this.getParent().dispatchEvent(e);
            }
        }
    }

    private final class KeyEventInputSourceListener
    implements KeyEventPostProcessor {
        private KeyEventInputSourceListener() {
        }

        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            for (Component owner = FocusManager.getCurrentManager().getFocusOwner(); owner != null; owner = owner.getParent()) {
                if (owner != PCanvas.this) continue;
                PCanvas.this.sendInputEventToInputManager(keyEvent, keyEvent.getID());
                return true;
            }
            return false;
        }
    }

    private final class MouseEventInputSource
    implements MouseListener {
        private MouseEventInputSource() {
        }

        public void mouseClicked(MouseEvent e) {
            PCanvas.this.sendInputEventToInputManager(e, 500);
        }

        public void mouseEntered(MouseEvent e) {
            MouseEvent simulated = null;
            simulated = PCanvas.this.isAnyButtonDown(e) ? this.buildRetypedMouseEvent(e, 506) : this.buildRetypedMouseEvent(e, 503);
            PCanvas.this.sendInputEventToInputManager(e, 504);
            PCanvas.this.sendInputEventToInputManager(simulated, simulated.getID());
        }

        public void mouseExited(MouseEvent e) {
            MouseEvent simulated = null;
            simulated = PCanvas.this.isAnyButtonDown(e) ? this.buildRetypedMouseEvent(e, 506) : this.buildRetypedMouseEvent(e, 503);
            PCanvas.this.sendInputEventToInputManager(simulated, simulated.getID());
            PCanvas.this.sendInputEventToInputManager(e, 505);
        }

        public void mousePressed(MouseEvent rawEvent) {
            PCanvas.this.requestFocus();
            boolean shouldBalanceEvent = false;
            MouseEvent event = this.copyButtonsFromModifiers(rawEvent, 501);
            switch (event.getButton()) {
                case 1: {
                    if (PCanvas.this.isButton1Pressed) {
                        shouldBalanceEvent = true;
                    }
                    PCanvas.this.isButton1Pressed = true;
                    break;
                }
                case 2: {
                    if (PCanvas.this.isButton2Pressed) {
                        shouldBalanceEvent = true;
                    }
                    PCanvas.this.isButton2Pressed = true;
                    break;
                }
                case 3: {
                    if (PCanvas.this.isButton3Pressed) {
                        shouldBalanceEvent = true;
                    }
                    PCanvas.this.isButton3Pressed = true;
                    break;
                }
                default: {
                    throw new RuntimeException("mousePressed without buttons specified");
                }
            }
            if (shouldBalanceEvent) {
                this.sendRetypedMouseEventToInputManager(event, 502);
            }
            PCanvas.this.sendInputEventToInputManager(event, 501);
        }

        public void mouseReleased(MouseEvent rawEvent) {
            boolean shouldBalanceEvent = false;
            MouseEvent event = this.copyButtonsFromModifiers(rawEvent, 502);
            switch (event.getButton()) {
                case 1: {
                    if (!PCanvas.this.isButton1Pressed) {
                        shouldBalanceEvent = true;
                    }
                    PCanvas.this.isButton1Pressed = false;
                    break;
                }
                case 2: {
                    if (!PCanvas.this.isButton2Pressed) {
                        shouldBalanceEvent = true;
                    }
                    PCanvas.this.isButton2Pressed = false;
                    break;
                }
                case 3: {
                    if (!PCanvas.this.isButton3Pressed) {
                        shouldBalanceEvent = true;
                    }
                    PCanvas.this.isButton3Pressed = false;
                    break;
                }
                default: {
                    throw new RuntimeException("mouseReleased without buttons specified");
                }
            }
            if (shouldBalanceEvent) {
                this.sendRetypedMouseEventToInputManager(event, 501);
            }
            PCanvas.this.sendInputEventToInputManager(event, 502);
        }

        private MouseEvent copyButtonsFromModifiers(MouseEvent rawEvent, int eventType) {
            if (rawEvent.getButton() != 0) {
                return rawEvent;
            }
            int newButton = 0;
            if (this.hasButtonModifier(rawEvent, 16)) {
                newButton = 1;
            } else if (this.hasButtonModifier(rawEvent, 8)) {
                newButton = 2;
            } else if (this.hasButtonModifier(rawEvent, 4)) {
                newButton = 3;
            }
            return this.buildModifiedMouseEvent(rawEvent, eventType, newButton);
        }

        private boolean hasButtonModifier(MouseEvent event, int buttonMask) {
            return (event.getModifiers() & buttonMask) == buttonMask;
        }

        public MouseEvent buildRetypedMouseEvent(MouseEvent e, int newType) {
            return this.buildModifiedMouseEvent(e, newType, e.getButton());
        }

        public MouseEvent buildModifiedMouseEvent(MouseEvent e, int newType, int newButton) {
            return new MouseEvent((Component)e.getSource(), newType, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), newButton);
        }

        private void sendRetypedMouseEventToInputManager(MouseEvent e, int newType) {
            MouseEvent retypedEvent = this.buildRetypedMouseEvent(e, newType);
            PCanvas.this.sendInputEventToInputManager(retypedEvent, newType);
        }
    }

    private final class MouseMotionInputSourceListener
    implements MouseMotionListener {
        private MouseMotionInputSourceListener() {
        }

        public void mouseDragged(MouseEvent e) {
            PCanvas.this.sendInputEventToInputManager(e, 506);
        }

        public void mouseMoved(MouseEvent e) {
            PCanvas.this.sendInputEventToInputManager(e, 503);
        }
    }
}

