/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.Cursor;
import java.awt.Graphics2D;

public final class POffscreenCanvas
implements PComponent {
    private final PBounds bounds;
    private PCamera camera;
    private int renderQuality = 1;
    static final int DEFAULT_RENDER_QUALITY = 1;

    public POffscreenCanvas(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be at least zero, was " + width);
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be at least zero, was " + height);
        }
        this.bounds = new PBounds(0.0, 0.0, width, height);
        this.setCamera(PUtil.createBasicScenegraph());
    }

    public void render(Graphics2D graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException("graphics must not be null");
        }
        PPaintContext paintContext = new PPaintContext(graphics);
        paintContext.setRenderQuality(this.renderQuality);
        this.camera.fullPaint(paintContext);
    }

    public void setCamera(PCamera camera) {
        if (this.camera != null) {
            this.camera.setComponent(null);
        }
        this.camera = camera;
        if (camera != null) {
            camera.setComponent(this);
            camera.setBounds((PBounds)this.bounds.clone());
        }
    }

    public PCamera getCamera() {
        return this.camera;
    }

    public void setRenderQuality(int renderQuality) {
        if (renderQuality != 1 && renderQuality != 0) {
            throw new IllegalArgumentException("renderQuality must be one of PPaintContext.HIGH_QUALITY_RENDERING or PPaintContext.LOW_QUALITY_RENDERING, was " + renderQuality);
        }
        this.renderQuality = renderQuality;
    }

    public int getRenderQuality() {
        return this.renderQuality;
    }

    public void paintImmediately() {
    }

    public void popCursor() {
    }

    public void pushCursor(Cursor cursor) {
    }

    public void repaint(PBounds repaintBounds) {
    }

    public void setInteracting(boolean interacting) {
    }
}

