/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.contexts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.wink.common.internal.CaseInsensitiveMultivaluedMap;
import org.apache.wink.common.internal.WinkConfiguration;
import org.apache.wink.common.internal.http.Accept;
import org.apache.wink.common.internal.http.AcceptLanguage;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.utils.HeaderUtils;
import org.apache.wink.common.internal.utils.StringUtils;
import org.apache.wink.common.internal.utils.UnmodifiableMultivaluedMap;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.internal.DeploymentConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeadersImpl
implements HttpHeaders {
    private static final Logger logger = LoggerFactory.getLogger(HttpHeadersImpl.class);
    private MessageContext msgContext;
    private MultivaluedMap<String, String> headers;
    private MultivaluedMap<String, String> allHeaders;
    private List<Locale> acceptableLanguages;
    private List<MediaType> acceptableMediaTypes;
    private Map<String, Cookie> cookies;
    private Locale language;
    private MediaType mediaType;
    private MultivaluedMap<String, String> allHeadersView;
    private static final String VERSION = "$Version";
    private static final String DOMAIN = "$Domain";
    private static final String PATH = "$Path";

    public HttpHeadersImpl(MessageContext msgContext) {
        this.msgContext = msgContext;
        this.headers = new CaseInsensitiveMultivaluedMap();
        this.acceptableLanguages = null;
        this.acceptableMediaTypes = null;
        this.cookies = null;
        this.language = null;
        this.mediaType = null;
        this.allHeaders = null;
        this.allHeadersView = null;
    }

    public List<Locale> getAcceptableLanguages() {
        if (this.acceptableLanguages == null) {
            List<String> requestHeader = this.getRequestHeader("Accept-Language");
            if (requestHeader == null || requestHeader.isEmpty()) {
                this.acceptableLanguages = new LinkedList<Locale>();
            } else {
                StringBuilder acceptLanguageTemp = new StringBuilder();
                acceptLanguageTemp.append(requestHeader.get(0));
                for (int c = 1; c < requestHeader.size(); ++c) {
                    acceptLanguageTemp.append(",");
                    acceptLanguageTemp.append(requestHeader.get(c));
                }
                String acceptLanguage = acceptLanguageTemp.toString();
                logger.trace("Accept-Language combined header is {}", (Object)acceptLanguage);
                AcceptLanguage acceptLanguages = AcceptLanguage.valueOf((String)acceptLanguage);
                this.acceptableLanguages = acceptLanguages.getAcceptableLanguages();
            }
        }
        logger.trace("getAcceptableLanguages() returns {}", this.acceptableLanguages);
        return this.acceptableLanguages;
    }

    public List<MediaType> getAcceptableMediaTypes() {
        if (this.acceptableMediaTypes == null) {
            Accept acceptHeader = this.getAcceptHeader();
            this.acceptableMediaTypes = acceptHeader.getSortedMediaTypes();
        }
        logger.trace("getAcceptableMediaTypes() returns {}", this.acceptableMediaTypes);
        return this.acceptableMediaTypes;
    }

    private Accept getAcceptHeader() {
        String alternateParameter = (String)this.msgContext.getUriInfo().getQueryParameters().getFirst((Object)"alt");
        String acceptValue = null;
        logger.trace("alternateParameter is {}", (Object)alternateParameter);
        if (alternateParameter != null) {
            DeploymentConfiguration deploymentConfiguration = (DeploymentConfiguration)this.msgContext.getAttribute(WinkConfiguration.class);
            Map<String, String> alternateShortcutMap = deploymentConfiguration.getAlternateShortcutMap();
            logger.trace("alternateShortcutMap is {}", alternateShortcutMap);
            if (alternateShortcutMap != null) {
                acceptValue = alternateShortcutMap.get(alternateParameter);
            }
            if (acceptValue == null) {
                acceptValue = alternateParameter;
            }
            logger.trace("acceptValue set via alternateParameter is {}", (Object)acceptValue);
        } else {
            List<String> requestHeader = this.getRequestHeader("Accept");
            if (requestHeader == null || requestHeader.isEmpty()) {
                acceptValue = null;
            } else if (requestHeader.size() > 1) {
                StringBuilder acceptValueTemp = new StringBuilder();
                acceptValueTemp.append(requestHeader.get(0));
                for (int c = 1; c < requestHeader.size(); ++c) {
                    acceptValueTemp.append(",");
                    acceptValueTemp.append(requestHeader.get(c));
                }
                acceptValue = acceptValueTemp.toString();
            } else {
                acceptValue = requestHeader.get(0);
            }
        }
        try {
            logger.trace("Accept header is: {}", acceptValue);
            Accept acceptHeader = Accept.valueOf(acceptValue);
            logger.trace("getAcceptHeader() returns {}", (Object)acceptHeader);
            return acceptHeader;
        }
        catch (IllegalArgumentException e) {
            logger.error(Messages.getMessage((String)"illegalAcceptHeader", (Object[])new Object[]{acceptValue}), (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    public Map<String, Cookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, Cookie>();
            List<String> cookiesHeaders = this.getRequestHeaderInternal("Cookie");
            if (cookiesHeaders != null) {
                for (String cookieHeader : cookiesHeaders) {
                    List<Cookie> currentCookies = this.parseCookieHeader(cookieHeader);
                    for (Cookie c : currentCookies) {
                        this.cookies.put(c.getName(), c);
                    }
                }
            }
        }
        logger.trace("Cookies are: {}", this.cookies);
        return this.cookies;
    }

    private List<Cookie> parseCookieHeader(String cookieHeader) {
        String[] tokens = cookieHeader.split("[;,]");
        if (tokens.length <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        ModifiableCookie currentCookie = null;
        int version = 0;
        for (String token : tokens) {
            String value;
            String[] subTokens = token.trim().split("=", 2);
            String name = subTokens.length > 0 ? subTokens[0] : null;
            String string = value = subTokens.length > 1 ? subTokens[1] : null;
            if (value != null && value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                value = value.substring(1, value.length() - 1);
            }
            if (!name.startsWith("$")) {
                if (currentCookie != null && currentCookie.name != null && currentCookie.value != null) {
                    cookies.add(new Cookie(currentCookie.name, currentCookie.value, currentCookie.path, currentCookie.domain, currentCookie.version));
                }
                currentCookie = new ModifiableCookie();
                currentCookie.name = name;
                currentCookie.value = value;
                currentCookie.version = version;
                continue;
            }
            if (name.startsWith(VERSION)) {
                version = Integer.parseInt(value);
                continue;
            }
            if (name.startsWith(PATH) && currentCookie != null) {
                currentCookie.path = value;
                continue;
            }
            if (!name.startsWith(DOMAIN) || currentCookie == null) continue;
            currentCookie.domain = value;
        }
        if (currentCookie != null && currentCookie.name != null && currentCookie.value != null) {
            cookies.add(new Cookie(currentCookie.name, currentCookie.value, currentCookie.path, currentCookie.domain, currentCookie.version));
        }
        return cookies;
    }

    public Locale getLanguage() {
        if (this.language == null) {
            String languageStr = (String)this.headers.getFirst((Object)"Content-Language");
            if (languageStr == null) {
                List<String> s = this.getRequestHeaderInternal("Content-Language");
                if (s == null || s.isEmpty()) {
                    return null;
                }
                languageStr = s.get(0);
            }
            logger.trace("Language string is {}", (Object)languageStr);
            if (languageStr == null) {
                logger.trace("getLanguage() returning null");
                return null;
            }
            String[] locales = StringUtils.fastSplit((String)languageStr, (String)",");
            this.language = HeaderUtils.languageToLocale((String)locales[0].trim());
        }
        logger.trace("getLanguage() returning {}", (Object)this.language);
        return this.language;
    }

    public MediaType getMediaType() {
        if (this.mediaType == null) {
            String contentType = (String)this.headers.getFirst((Object)"Content-Type");
            if (contentType == null) {
                List<String> s = this.getRequestHeaderInternal("Content-Type");
                if (s == null || s.isEmpty()) {
                    logger.trace("getMediaType() returning null");
                    return null;
                }
                contentType = s.get(0);
            }
            logger.trace("Content-type is {}", (Object)contentType);
            this.mediaType = MediaType.valueOf((String)contentType);
        }
        logger.trace("getMediaType() returning {}", (Object)this.mediaType);
        return this.mediaType;
    }

    private List<String> getRequestHeaderInternal(String name) {
        if (this.allHeaders != null) {
            List value = (List)this.allHeaders.get((Object)name);
            logger.trace("Returning {} header value from allHeaders cache: {}", (Object)name, (Object)value);
            return value;
        }
        ArrayList<String> list = (ArrayList<String>)this.headers.get((Object)name);
        if (list == null) {
            Enumeration headerValues = ((HttpServletRequest)this.msgContext.getAttribute(HttpServletRequest.class)).getHeaders(name);
            list = new ArrayList<String>();
            while (headerValues.hasMoreElements()) {
                String val = (String)headerValues.nextElement();
                if (val == null) continue;
                list.add(val);
            }
            logger.trace("HttpServletRequest.getHeaders({}) returned {} so putting into headers cache", (Object)name, list);
            this.headers.put((Object)name, list);
        }
        logger.trace("getRequestHeaderInternal({}) returning {}", (Object)name, (Object)list);
        return list;
    }

    public List<String> getRequestHeader(String name) {
        if (name == null) {
            logger.trace("getRequestHeader({}) returns null", (Object)name);
            return null;
        }
        List<String> list = this.getRequestHeaderInternal(name);
        if (list == null || list.isEmpty()) {
            logger.trace("getRequestHeader({}) returns null due to empty or non-existent header", (Object)name);
            return null;
        }
        logger.trace("getRequestHeader({}) returns {}", (Object)name, list);
        return Collections.unmodifiableList(list);
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        if (this.allHeadersView == null) {
            this.allHeadersView = new UnmodifiableMultivaluedMap((MultivaluedMap)new MultivaluedRequestHeaderDelegate());
        }
        return this.allHeadersView;
    }

    private MultivaluedMap<String, String> buildRequestHeaders() {
        CaseInsensitiveMultivaluedMap map = new CaseInsensitiveMultivaluedMap();
        Enumeration names = ((HttpServletRequest)this.msgContext.getAttribute(HttpServletRequest.class)).getHeaderNames();
        if (names == null) {
            return map;
        }
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration headerValues = ((HttpServletRequest)this.msgContext.getAttribute(HttpServletRequest.class)).getHeaders(name);
            ArrayList<String> values = new ArrayList<String>();
            while (headerValues.hasMoreElements()) {
                String val = (String)headerValues.nextElement();
                if (val == null) continue;
                values.add(val);
            }
            logger.trace("buildRequestHeaders() adding {} header with values {}", (Object)name, values);
            map.put((Object)name, values);
        }
        return new UnmodifiableMultivaluedMap((MultivaluedMap)map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultivaluedRequestHeaderDelegate
    implements MultivaluedMap<String, String> {
        private MultivaluedRequestHeaderDelegate() {
        }

        public void setupAllHeaders() {
            if (HttpHeadersImpl.this.allHeaders == null) {
                HttpHeadersImpl.this.allHeaders = HttpHeadersImpl.this.buildRequestHeaders();
            }
        }

        public void add(String key, String value) {
            throw new UnsupportedOperationException();
        }

        public String getFirst(String key) {
            List headers = HttpHeadersImpl.this.getRequestHeaderInternal(key);
            if (headers == null || headers.isEmpty()) {
                return null;
            }
            return (String)headers.get(0);
        }

        public void putSingle(String key, String value) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            this.setupAllHeaders();
            return HttpHeadersImpl.this.allHeaders.containsKey(key);
        }

        public boolean containsValue(Object value) {
            this.setupAllHeaders();
            return HttpHeadersImpl.this.allHeaders.containsValue(value);
        }

        public Set<Map.Entry<String, List<String>>> entrySet() {
            this.setupAllHeaders();
            return HttpHeadersImpl.this.allHeaders.entrySet();
        }

        public List<String> get(Object key) {
            this.setupAllHeaders();
            return (List)HttpHeadersImpl.this.allHeaders.get(key);
        }

        public boolean isEmpty() {
            this.setupAllHeaders();
            return HttpHeadersImpl.this.allHeaders.isEmpty();
        }

        public Set<String> keySet() {
            this.setupAllHeaders();
            return HttpHeadersImpl.this.allHeaders.keySet();
        }

        public List<String> put(String key, List<String> value) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map<? extends String, ? extends List<String>> t) {
            throw new UnsupportedOperationException();
        }

        public List<String> remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            this.setupAllHeaders();
            return HttpHeadersImpl.this.allHeaders.size();
        }

        public Collection<List<String>> values() {
            this.setupAllHeaders();
            return HttpHeadersImpl.this.allHeaders.values();
        }
    }

    private static class ModifiableCookie {
        public String name;
        public String value;
        public int version = 0;
        public String path;
        public String domain;

        private ModifiableCookie() {
        }
    }
}

