/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.registry;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ws.rs.core.MediaType;
import org.apache.wink.common.DynamicResource;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.lifecycle.LifecycleManagersRegistry;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.apache.wink.common.internal.registry.Injectable;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.apache.wink.common.internal.registry.metadata.MethodMetadata;
import org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;
import org.apache.wink.common.internal.uritemplate.UriTemplateProcessor;
import org.apache.wink.server.internal.ServerCustomProperties;
import org.apache.wink.server.internal.registry.ResourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRecordFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRecordFactory.class);
    private final LifecycleManagersRegistry lifecycleManagerRegistry;
    private final Map<Class<?>, ResourceRecord> cacheByClass;
    private Lock readersLock;
    private Lock writersLock;
    private final boolean isStrictConsumesProduces;

    public ResourceRecordFactory(LifecycleManagersRegistry lifecycleManagerRegistry) {
        this(lifecycleManagerRegistry, new Properties());
    }

    public ResourceRecordFactory(LifecycleManagersRegistry lifecycleManagerRegistry, Properties customProperties) {
        if (lifecycleManagerRegistry == null) {
            throw new NullPointerException("lifecycleManagerRegistry");
        }
        this.lifecycleManagerRegistry = lifecycleManagerRegistry;
        this.cacheByClass = new HashMap();
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readersLock = readWriteLock.readLock();
        this.writersLock = readWriteLock.writeLock();
        if (customProperties == null) {
            customProperties = new Properties();
        }
        String value = customProperties.getProperty(ServerCustomProperties.STRICT_INTERPRET_CONSUMES_PRODUCES_SPEC_CUSTOM_PROPERTY.getPropertyName(), ServerCustomProperties.STRICT_INTERPRET_CONSUMES_PRODUCES_SPEC_CUSTOM_PROPERTY.getDefaultValue());
        this.isStrictConsumesProduces = Boolean.valueOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceRecord getResourceRecord(Class<?> cls) {
        this.readersLock.lock();
        try {
            ResourceRecord record = this.cacheByClass.get(cls);
            if (record == null) {
                ObjectFactory of = this.lifecycleManagerRegistry.getObjectFactory(cls);
                this.readersLock.unlock();
                try {
                    record = this.createStaticResourceRecord(cls, of);
                }
                finally {
                    this.readersLock.lock();
                }
            }
            ResourceRecord resourceRecord = record;
            return resourceRecord;
        }
        finally {
            this.readersLock.unlock();
        }
    }

    public ResourceRecord getResourceRecord(Object instance) {
        return this.getResourceRecord(instance, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResourceRecord getResourceRecord(Object instance, boolean isRootResource) {
        Class<?> cls = instance.getClass();
        ResourceRecord record = null;
        this.readersLock.lock();
        try {
            ObjectFactory of;
            if (isRootResource) {
                if (ResourceMetadataCollector.isStaticResource(cls)) {
                    record = this.cacheByClass.get(cls);
                    if (record == null) {
                        of = this.lifecycleManagerRegistry.getObjectFactory(instance);
                        this.readersLock.unlock();
                        try {
                            record = this.createStaticResourceRecord(cls, of);
                        }
                        finally {
                            this.readersLock.lock();
                        }
                    }
                } else {
                    if (!ResourceMetadataCollector.isDynamicResource(cls)) throw new IllegalArgumentException(Messages.getMessage((String)"rootResourceInstanceIsAnInvalidResource", (Object[])new Object[]{instance.getClass().getCanonicalName()}));
                    of = this.lifecycleManagerRegistry.getObjectFactory(instance);
                    this.readersLock.unlock();
                    try {
                        record = this.createDynamicResourceRecord((DynamicResource)instance, of);
                    }
                    finally {
                        this.readersLock.lock();
                    }
                }
            } else {
                of = new InstanceObjectFactory(instance);
                this.readersLock.unlock();
                try {
                    record = this.createSubResourceRecord(instance, of);
                }
                finally {
                    this.readersLock.lock();
                }
            }
            ResourceRecord resourceRecord = record;
            return resourceRecord;
        }
        finally {
            this.readersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceRecord createStaticResourceRecord(Class<? extends Object> cls, ObjectFactory<?> of) {
        ClassMetadata metadata = this.createMetadata(cls);
        UriTemplateProcessor processor = this.createUriTemplateProcessor(metadata);
        ResourceRecord record = new ResourceRecord(metadata, of, processor);
        this.writersLock.lock();
        try {
            if (this.cacheByClass.get(cls) == null) {
                this.cacheByClass.put(cls, record);
            }
        }
        finally {
            this.writersLock.unlock();
        }
        return record;
    }

    private ResourceRecord createDynamicResourceRecord(DynamicResource instance, ObjectFactory<?> of) {
        Class<?> cls = instance.getClass();
        ClassMetadata metadata = this.createMetadata(cls);
        metadata = this.fixInstanceMetadata(metadata, instance);
        UriTemplateProcessor processor = this.createUriTemplateProcessor(metadata);
        return new ResourceRecord(metadata, of, processor);
    }

    private ResourceRecord createSubResourceRecord(Object instance, ObjectFactory<?> of) {
        Class<?> cls = instance.getClass();
        ClassMetadata metadata = this.createMetadata(cls);
        return new ResourceRecord(metadata, of, null);
    }

    private ClassMetadata createMetadata(Class<? extends Object> cls) {
        ClassMetadata md = ResourceMetadataCollector.collectMetadata(cls);
        md = this.fixConsumesAndProduces(md);
        return md;
    }

    private UriTemplateProcessor createUriTemplateProcessor(ClassMetadata metadata) {
        StringBuilder path = new StringBuilder();
        this.appendPathWithParent(metadata, path);
        return UriTemplateProcessor.newNormalizedInstance((String)path.toString());
    }

    private void appendPathWithParent(ClassMetadata metadata, StringBuilder pathStr) {
        String path;
        ResourceRecord parentRecord = this.getParent(metadata);
        if (parentRecord != null) {
            ClassMetadata parentMetadata = parentRecord.getMetadata();
            this.appendPathWithParent(parentMetadata, pathStr);
        }
        if (!(path = UriTemplateProcessor.normalizeUri((String)metadata.getPath())).endsWith("/")) {
            pathStr.append("/");
        }
        pathStr.append(path);
    }

    private ResourceRecord getParent(ClassMetadata metadata) {
        Class parent = metadata.getParent();
        Object parentInstance = metadata.getParentInstance();
        ResourceRecord parentRecord = null;
        if (parent != null) {
            parentRecord = this.getResourceRecord(parent);
        } else if (parentInstance != null) {
            parentRecord = this.getResourceRecord(parentInstance);
        }
        return parentRecord;
    }

    private ClassMetadata fixInstanceMetadata(ClassMetadata classMetadata, DynamicResource dynamicResource) {
        String collectionTitle;
        String workspaceTitle;
        Object parent;
        String path = dynamicResource.getPath();
        if (path != null) {
            classMetadata.addPath(path);
            if (logger.isTraceEnabled()) {
                logger.trace("Adding dispatched path from instance: {}", (Object)path);
            }
        }
        if ((parent = dynamicResource.getParent()) != null) {
            classMetadata.getParentInstances().add(parent);
            if (logger.isTraceEnabled()) {
                logger.trace("Adding parent beans from instance: {}", parent);
            }
        }
        if ((workspaceTitle = dynamicResource.getWorkspaceTitle()) != null) {
            classMetadata.setWorkspaceName(workspaceTitle);
        }
        if ((collectionTitle = dynamicResource.getCollectionTitle()) != null) {
            classMetadata.setCollectionTitle(collectionTitle);
        }
        return classMetadata;
    }

    ClassMetadata fixConsumesAndProduces(ClassMetadata classMetadata) {
        logger.trace("fixConsumesAndProduces({}) entry", (Object)classMetadata);
        if (this.isStrictConsumesProduces) {
            logger.trace("fixConsumesAndProduces() exit returning because custom property {} is set to true.", (Object)ServerCustomProperties.STRICT_INTERPRET_CONSUMES_PRODUCES_SPEC_CUSTOM_PROPERTY.getPropertyName());
            return classMetadata;
        }
        Set produces = classMetadata.getProduces();
        Set consumes = classMetadata.getConsumes();
        HashSet allMethodMetadata = new HashSet();
        allMethodMetadata.addAll(classMetadata.getResourceMethods());
        allMethodMetadata.addAll(classMetadata.getSubResourceMethods());
        for (MethodMetadata methodMetadata : allMethodMetadata) {
            Method method = methodMetadata.getReflectionMethod();
            if (!Void.TYPE.equals(method.getReturnType()) || produces.size() <= 0 || !((Object)methodMetadata.getProduces()).equals(produces)) continue;
            methodMetadata.addProduces(MediaType.WILDCARD_TYPE);
            logger.trace("Method has a @Produces value but also a void return type so adding a */* to allow any response: {} ", (Object)methodMetadata);
        }
        for (MethodMetadata methodMetadata : allMethodMetadata) {
            if (consumes.size() <= 0 || !((Object)methodMetadata.getConsumes()).equals(consumes)) continue;
            List params = methodMetadata.getFormalParameters();
            boolean isEntityParamFound = false;
            for (Injectable p : params) {
                if (!Injectable.ParamType.ENTITY.equals((Object)p.getParamType())) continue;
                isEntityParamFound = true;
            }
            if (isEntityParamFound) continue;
            methodMetadata.addConsumes(MediaType.WILDCARD_TYPE);
            logger.trace("Method has a @Consumes value but no entity parameter so adding a */* to allow any request: {} ", (Object)methodMetadata);
        }
        logger.trace("fixConsumesAndProduces() exit returning {}", (Object)classMetadata);
        return classMetadata;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceObjectFactory<T>
    implements ObjectFactory<T> {
        private final T object;

        public InstanceObjectFactory(T object) {
            this.object = object;
        }

        public T getInstance(RuntimeContext context) {
            return this.object;
        }

        public Class<T> getInstanceClass() {
            return this.object.getClass();
        }

        public String toString() {
            return String.format("InstanceObjectFactory: %s", this.getInstanceClass());
        }

        public void releaseInstance(T instance, RuntimeContext context) {
        }

        public void releaseAll(RuntimeContext context) {
        }
    }
}

